#include "npconfig.h"

void search_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Config *config = ( NP_Config *)data;

   if ( !config->active_groups )
      return;

   if ( *config->search_text == '\n' || *config->search_text == '\0' )
      return;
   
   gtk_signal_handler_block( GTK_OBJECT( config->search_button ),
                             config->search_id );
   gtk_signal_handler_unblock( GTK_OBJECT( config->search_button ),
                               config->stop_id );
   gtk_label_set( GTK_LABEL( config->search_label ), " Stop " );

   static int changed = 0, old = 0;
   int result;
   
   static char memory[ 512 ] = "\0";
   char buffer[ 512 ];

   if ( *config->search_text == '\0' )
      return;
   
   if ( strcmp( memory, config->search_text ))
   {
      if ( config->regex_alloc )
         regfree( &config->regex );

      config->regex_alloc = 0;
      
      if (( result = regcomp( &config->regex, config->search_text,
                              REG_EXTENDED | REG_NOSUB )))
      {
         regerror( result, &config->regex, buffer, sizeof buffer );
         config->show_message( config->search_text, 0 );
         return;
      }

      old = 0;
      changed = 1;
      
      config->regex_alloc = 1;
      strcpy( memory, config->search_text );
   }
   else
   {
      changed = 0;
      
      if ( ++old >= config->active_groups )
         old = 0;
   }

   GtkWidget *clist
      = ( GtkWidget *)gtk_object_get_data( GTK_OBJECT( widget->parent ),
                                           "active" );

   config->busy_cursor_and_block_signals( 1 );

   if ( !changed && old != config->active_clist_line &&
        config->active_clist_line < config->active_groups )
      old = config->active_clist_line + 1;

   config->stop = 0;

   gtk_clist_freeze( GTK_CLIST( clist ));

   for( int i = old; i < config->active_groups; ++i )
   {
      char *pointer;
      gtk_clist_get_text( GTK_CLIST( clist ), i, 0, &pointer );

      if ( !( i % 200 ))
         SIGALRM_handler( 0 );

      if ( config->stop )
         break;

      if (( result = regexec( &config->regex, pointer, 0, NULL, 0 )))
         if ( result == REG_NOMATCH )
            continue;
         else
         {
            regerror( result, &config->regex, buffer, sizeof buffer );
            config->show_message( buffer, 0 );
            gtk_clist_thaw( GTK_CLIST( clist ));
            return;
         }

      gtk_clist_select_row( GTK_CLIST( clist ), i, 0 );
      gtk_clist_moveto( GTK_CLIST( clist ), i, -1, 0.5, 0.0 );
      config->active_clist_line = old = i;
      break;
   }

   gtk_clist_thaw( GTK_CLIST( clist ));
   config->busy_cursor_and_block_signals( 0 );

   gtk_signal_handler_block( GTK_OBJECT( config->search_button ),
                             config->stop_id );
   gtk_signal_handler_unblock( GTK_OBJECT( config->search_button ),
                               config->search_id );
   gtk_label_set( GTK_LABEL( config->search_label ), " Search " );

   return;
}

