#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::update_node( char *node )
{
   if ( node == NULL )
   {
      strcpy( error_message, "NP_Tree: update_node(): "
              "NULL node name passed as argument." );
      return 1;
   }

   if ( !total_nodes || nodes == NULL )
   {
      strcpy( error_message, "NP_Tree: update_node(): "
              "this tree object is empty." );
      return 1;
   }

   NP_Node **pointer = nodes;
   int i;
   for( i = 0; i < total_nodes; ++i )
      if ( !strcmp( ( *pointer++ )->get_name(), node ))
         break;
   
   if ( i == total_nodes )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update_node(): "
                "no such node in this tree: %s", node );
      return 1;
   }

   if ( read_groups( node ))
      return 1;

   --pointer;

   if ( array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update_node():"
                " %s", array.get_error() );
      return 1;
   }
   
   if (( *pointer )->update_groups( array ))
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: update_node(): "
                "%s", ( *pointer )->get_error());
      return 1;
   }

   array.clear();
   
   return 0;
}
