#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"

int NP_Tree::get_nodes( NP_Stringarray& node_array )
{
   if ( !total_nodes )
      return 0;

   if ( node_array.clear() )
   {
      snprintf( error_message, sizeof error_message, "NP_Tree: get_nodes(): "
                " %s", array.get_error() );
      return 1;
   }

   NP_Node **pointer = nodes;
   for( int i = 0; i < total_nodes; ++i )
   {
      char *name;
      if (( name = ( *pointer++ )->get_name()) == NULL )
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Tree: get_nodes(): NULL name returned "
                   "for node: %d.", i );
         return 1;
      }
      
      if ( node_array.add_item( name ))
      {
         snprintf( error_message, sizeof error_message,
                   "NP_Tree: get_nodes(): %s",
                   node_array.get_error() );
         return 1;
      }
   }

   return 0;
}

