#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"

int NP_Node::update_groups( NP_Stringarray& array )
{
   clear();

   int total = array.get_total();
   if ( !total )
      return 0;
   
   if (( groups = ( NP_Group **)calloc( total, sizeof *groups )) == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   NP_Group **pointer = groups;
   for( int i = 0; i < total; ++i )
   {
      if (( *pointer = new NP_Group( name, ( char *)array[ i ] )) == NULL )
      {
         perror( "new" );
         exit( 1 );
      }

      ++total_groups;

      int messages, unseen, requested, headers;
      if ( ( *pointer )->get_stats( &messages, &unseen, &requested, &headers ))
      {
         snprintf( error_message, sizeof error_message, "NP_Node: "
                   "update_groups(): %s", ( *pointer )->get_error() );
         return 1;
      }
      
      total_messages += messages;
      total_unseen += unseen;
      total_requested += requested;
      total_headers += headers;
      ++pointer;
   }
   
      return 0;
}
