/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __QUEUE_ITEM__H__
#define __QUEUE_ITEM__H__

#include <pthread.h>

#include <glib.h>

#include "server.h"
#include "sockets.h"
#include "status-item.h"

#define QUEUE_ITEM(a) ((QueueItem*)a)

#define QUEUE_ITEM_STATUS_ESOCKET (-2)

typedef struct _QueueItem QueueItem;
typedef int (*QueueItemRunFunc)(QueueItem*);

struct _QueueItem
{
	/* Parent Class */
	StatusItem status;

	/* Private Fields */  
	server_data *sdata;
	gboolean high_priority;
	pthread_t thread_id;
	gboolean needs_socket;
	PanSocket *sock;
	gboolean is_paused;
	gboolean abort;
	gboolean is_leech;

	/* virtual functions */
	QueueItemRunFunc run;
};

/* protected */
void queue_item_destructor (PanObject*);
void queue_item_constructor (QueueItem*,
	PanObjectDestructor,
	StatusItemDescribeFunc,
	QueueItemRunFunc, server_data*, gboolean high_priority, gboolean needs_socket);

/* public */
extern gboolean queue_item_is_high_priority (const QueueItem*);
extern gboolean queue_item_needs_socket (const QueueItem*);
extern PanSocket* queue_item_get_socket (QueueItem*);
extern void queue_item_set_socket (QueueItem*, PanSocket*);
extern gint queue_item_run (QueueItem*);
extern void queue_item_abort (QueueItem*);

extern void queue_item_emit_sockread_err (QueueItem*);
extern void queue_item_emit_sockwrite_err (QueueItem*);

extern void queue_item_set_paused (QueueItem*, gboolean paused);
extern gboolean queue_item_is_paused (const QueueItem*);

#endif
