/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef QUEUE_ITEM_GROUPLIST__H
#define QUEUE_ITEM_GROUPLIST__H

#include "queue-item.h"
#include "group.h"

#define QUEUE_ITEM_GROUPLIST(a) ((QueueItemGrouplist *)a)

typedef struct _QueueItemGrouplist QueueItemGrouplist;

typedef enum
{
	GROUPLIST_ALL,
	GROUPLIST_NEW
}
GrouplistDownloadType;

struct _QueueItemGrouplist
{
	/* parent */
	QueueItem item;

	/* private fields */
	server_data *sdata;
	GrouplistDownloadType download_type;
};

extern PanObject* queue_item_grouplist_new (
	server_data *sdata,
	gboolean high_priority,
	GrouplistDownloadType type);

#endif
