/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __GUI_H__
#define __GUI_H__

#include <gtk/gtkwidget.h>
#include <libgnomeui/gnome-app.h>
#include <libgnomeui/gnome-app-helper.h>

#include "article.h"
#include "group.h"
#include "status-item.h"

extern GtkWidget *groups_vbox;
extern GtkWidget *articlelist_ctree;
extern GtkWidget *text_box;
extern GtkWidget *contents_vbox;

extern void    clist_unselect_all (GtkWidget *);

extern void     widget_set_font    (GtkWidget* w, const char* font_name);

extern void dialog_draw_centered (GtkWidget *dialog, GtkWidget *window);

extern GnomeUIInfo help_menu[];

extern void gui_about (void);
extern void gui_shutdown (void);

enum {
	GUI_PANED = 1,
	GUI_NOTEBOOK
};
extern void gui_set_layout(int);

void gui_construct (const gchar *geometry);

enum {
	GROUPS_PAGE = 0,
	ARTICLELIST_PAGE,
	MESSAGE_PAGE
};

void gui_page_set (int page, GtkWidget *focus_item);
void gui_page_change (int change);

void gui_set_title (const group_data*);

void gui_popup_draw (GtkWidget *dialog, GtkWidget *parent);

void gui_restore_column_widths (GtkWidget *clist, gchar *type);
void gui_save_column_widths    (GtkWidget *clist, gchar *type);

void gui_select_all (void);

extern GtkWidget* server_menu_create   (void);

/**
 * These are the flgs passed in via the "header_fields" argument in
 * the function gui_set_headers().  For each flag, that header will
 * be displayed.
 */
enum {
	HEADER_SUBJECT		= 1<<0,
	HEADER_AUTHOR		= 1<<1,
	HEADER_MESSAGE_ID	= 1<<2,
	HEADER_REFERENCES	= 1<<3,
	HEADER_REPLY_TO		= 1<<4,
	HEADER_FOLLOWUP_TO	= 1<<5,
	HEADER_DATE		= 1<<6,
	HEADER_NEWSGROUPS	= 1<<7
};

/**
 * Updates the specified GtkTable to show the specified header_fields
 * associated with the article struct.  If a header is too long to fit
 * conveniently, it is truncated in a hopefully-reasonable way and
 * displayed as a button insted of a label.  When this button is clicked,
 * the untruncated header will be shown in a popup dialog.
 *
 * @param GtkTable the gtktable to use.  Its previous contents are removed.
 * @param article_data the article whose headers to use.
 * @param header_fields which headers to show.
 */
extern void gui_set_headers (
	GtkWidget *table,
	const article_data*,
	gulong header_fields);

/**
 * The same as gui_set_headers, but uses the default header_fields specified
 * in the user's configuration file.  This is a convenience so that callers
 * don't have to query the configuration file by hand.
 */
extern void gui_set_headers_default (
	GtkWidget *table,
	const article_data*);

/**
 * Adds the specified StatusItem to the main window's list of StatusItems to
 * track.  This will ensure that Pan's main window will keep the user informed
 * of this StatusItem's progress.
 *
 * @see gui_remove_status_item
 * @param StatusItem the StatusItem to track
 */
extern void gui_add_status_item (
	StatusItem*);

/**
 * Removes the specified StatusItem from the main window.
 *
 * @see gui_add_status_item
 * @param StatusItem the StatusItem to remove from the main window.
 */
extern void gui_remove_status_item (
	StatusItem*);

extern void gui_set_queue_size (int size);

#endif /* __GUI_H__ */
