/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __DEBUG_H__
#define __DEBUG_H__

#include <glib.h>

typedef enum
{
	DEBUG_QUEUE		= (1<<0),
	DEBUG_SOCKET_INPUT	= (1<<1),
	DEBUG_SOCKET_OUTPUT	= (1<<2),
	DEBUG_DECODE		= (1<<3),
	DEBUG_ACACHE		= (1<<4),
	DEBUG_LOCK		= (1<<5),
	DEBUG_DB		= (1<<6),
	DEBUG_PAN_OBJECT	= (1<<7)
}
DebugFlags;

extern void set_debug_level (gulong flags);

extern void debug (gulong flag, const gchar* fmt, ...);

#endif
