/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ARTICLE_HEADERS_DB_H__
#define __ARTICLE_HEADERS_DB_H__

#include "article.h"
#include "group.h"
#include "pan-db.h"
#include "server.h"

/* NOTE: If the field order in ahdb changes, these
 * values need to be updated to match */
enum {
	AHDB_FIELD_DATE		= 0,
	AHDB_FIELD_STATE	= 1,
	AHDB_FIELD_LINECOUNT	= 2,
	AHDB_FIELD_PARTS	= 3,
	AHDB_FIELD_PART		= 4,
	AHDB_FIELD_NUMBER	= 5,
	AHDB_FIELD_SUBJECT	= 6,
	AHDB_FIELD_AUTHOR	= 7,
	AHDB_FIELD_REFERENCES	= 8,
	AHDB_FIELD_NEWSGROUPS	= 9,
	AHDB_FIELD_FOLLOWUP_TO	= 10
};

typedef struct AHDB* article_db;

extern article_db ahdb_ref(const server_data*, const group_data*);
extern void ahdb_unref(article_db);

extern article_data* ahdb_get(article_db, const char* message_id);
extern GSList* ahdb_get_all(article_db, GFunc, gpointer);
extern int ahdb_length(article_db);

extern gboolean ahdb_exists (const server_data*, const group_data*);
extern void ahdb_delete_db_file (const server_data*, const group_data*);

extern void ahdb_save (article_db, const article_data*, gboolean sync);
extern void ahdb_save_all (article_db, GSList* headers, GFunc, gpointer);
extern void ahdb_erase (article_db, const article_data*, const char *);
extern void ahdb_erase_all (article_db);
extern void ahdb_sync (article_db);
extern void ahdb_foreach (article_db, DBFunc, gpointer);
extern const char * ahdb_field (const char *, int);

#endif
