/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#ifndef __ACACHE_H__
#define __ACACHE_H__

#include <stdio.h>
#include <glib.h>
#include "article.h"

extern FILE * acache_open_header(const article_data *);
extern void acache_putline_header(FILE *, const char *);
extern void acache_close_header(FILE *);
extern char* acache_load_header(const char* message_id);
extern gboolean acache_header_exists(const char* message_id);

extern FILE * acache_open_body(const article_data *);
extern void acache_putline_body(FILE *, const char *);
extern void acache_close_body(FILE *);
extern char* acache_load_body(const char* message_id);
extern gboolean acache_body_exists(const char* message_id);

extern void acache_delete(const char* message_id);
extern int acache_expire(void);
extern int acache_expire_all(void);

extern void acache_file_checkin (const char *message_id);
extern void acache_file_checkout (const char *message_id);
extern void acache_init (void);

#endif /* __ACACHE_H__ */
