'\"
'\" Copyright (c) 1997-1999 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) $Id: TnmEther.n,v 1.1 1999/02/12 16:39:57 schoenw Exp $
'\" 
.so man.macros
.TH TnmEther n "February 1999" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TnmEther \- A Tcl package containing information about Ethernet addresses.
.BE

.SH DESCRIPTION

The TnmEther package provides a database of IEEE 802 Ethernet
addresses.

.SH USING THE PACKAGE

The TnmEther package is loaded into a Tcl interpreter by using the
following sequence of Tcl commands:

.CS
package require Tnm
.br
package require TnmEther $tnm(version)
.CE

All the TnmEther commands live in the TnmEther namespace. You can
import these commands into the current namespace by using the
following Tcl command:

.CS
namespace import TnmEther::*
.CE

It is however suggested to import commands explicitely or to use the
full name in scripts to avoid name clashes.

.SH COMMANDS

.TP
.B TnmEther::GetVendor \fIether\fR
Get the vendor for a given IEEE 802 ethernet address. The ethernet
address must be in the format aa:bb:cc:dd:ee:ff. The command returns
the name of the vendor or an empty string if there is no known vendor
for the given ethernet address.

.TP
.B TnmEther::GetEthers \fIpattern\fR
Get the ethernet address prefixes for all vendors that match a given
pattern. Regular expression style pattern matching is used when
matching the pattern against vendor names. The command returns a list
of ethernet address prefixes in the format aa:bb:cc.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
