#include "config.h"

#ifndef _P_DB_H
# define _P_DB_H

# ifdef HAVE_LIBDB

/*
 * 
 * Interface to db.
 *
 */

#  ifdef HAVE_DB_185_H
#   include <db_185.h>
#  else
#   include <db.h>
#  endif

#  include <fcntl.h>
#  include <sys/file.h>

#  define P_DB DB
#  define P_DBT DBT

#  define p_dptr data
#  define p_dsize size

#  define p_dbopen(a) dbopen (a, O_CREAT|O_RDWR, 0600, DB_HASH, NULL)
#  define p_dbclose(a) a->close (a)
#  define p_dbput(a,b,c) a->put (a,b,c,0)
#  define p_dbget(a,b,c) a->get (a,b,c,0)

# else

/*
 * 
 * Interface to ndbm
 * 
 */

#  include <ndbm.h>

#  define P_DB DBM
#  define P_DBT datum

#  define p_dptr dptr
#  define p_dsize dsize

#  define p_dbopen(a) dbm_open (a, O_CREAT|O_RDWR, 0600)
#  define p_dbclose(a) dbm_close (a)
#  define p_dbput(a,b,c) dbm_store(a, *(b), *(c), DBM_REPLACE)


int p_dbget (P_DBM *dbm, P_DBT *key, P_DBT *dat);

# endif

#endif
