/* a somewhat specialized client which records query times */

#define _MAIN_C

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#ifdef HAVE_GETOPT_H
# include <getopt.h>
#endif
#include <time.h>
#include <errno.h>

#include "hkp.h"
#include "client.h"

int main (int argc, const char *argv[])
{
  int c;
  const char *hostname = "localhost";
  const char *db = NULL;
  int port = 11372;

  int succeeded = 0;
  int force = 0;
  
  time_t t;
  
  Progname = argv[0];
  Debug = 0;
  
  while ((c = getopt (argc, argv, "s:p:b:df")) != EOF)
  {
    switch (c)
    {
      case 'd': Debug++; break;
      case 's': hostname = optarg; break;
      case 'p': port = atoi (optarg); break;
      case 'b': db = optarg; break;
      case 'f': force = 1; break;
      default: 
      {
	fprintf (stderr, "%s: Bad command line parameter.\n", Progname);
	return 1;
      }
    }
  }
  
  argv += optind;
  argc -= optind;
  
  if (argc == 0)
  {
    fprintf (stderr, "%s: Nothing to do.\n", Progname);
    return 1;
  }

  if (pkspxyc_init_db (db) != 0)
    return 1;
  
  while (argc > 0)
  {
    if (force)
      t = 0;
    else
      t = pkspxyc_get_timestamp (argv[0]);

    if (hkp_doit (hostname, port, argv[0], t, stdout, NULL) == 200)
    {
      succeeded++;
      if (pkspxyc_set_timestamp (argv[0], 0) != 0)
      {
	fprintf (stderr, "%s: pksxyc_set_timestamp failed: %s\n",
		 Progname, strerror (errno));
      }
    }
    argc--;
    argv++;
  }

  pkspxyc_close_db ();

  return succeeded ? 0 : 1;
}

