/*
** oidentd - ojnk ident daemon
** Copyright (C) 1998,1999,2000 Ryan McCabe <odin@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
**
** $Id: oidentd.h,v 1.6 2000/01/02 00:44:49 odin Exp $
*/

/*
** See ../config.h for user-configurable values.
*/

#ifndef __OIDENTD_H_
#define __OIDENTD_H_

#define _GNU_SOURCE

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <syslog.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <netdb.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define WAIT		0x01
#define REVSPOOF	0x02
#define HIDEO		0x04
#define HIDEE		0x08
#define INETD		0x10
#define SPOOF		0x20
#define RANDOM		0x40
#define ALL			0x80
#define WRAPPED		0x100
#define DEBUG		0x200 
#define UID			0x400
#define GID			0x800
#define NOIDENT		0x1000
#define NUMERIC		0x2000
#define MASQ		0x4000
#define FWD			0x8000
#define PROXY		0x10000
#define QUIET		0x20000

/*
** Maximum length of identd replies
** Use caution when changing this value in environment that lacks an snprintf
** function... It should never be less than 12
*/
#define MAX_ULEN 64

/*
** If you're going to change these default ports, be sure to make them a 
** string (eg. "113" not 113).
*/

#define DEFAULT_PORT	"auth"
#define DEFAULT_FPORT	"auth"

#define DEFAULT_TIMEOUT		15
#define DEFAULT_WTIMEOUT	120
#define DEFAULT_UMASK		0022

#define FACILITY LOG_DAEMON
#define PRIORITY LOG_INFO
#define DPRI LOG_DEBUG

/*
** 0: User is not allowed to spoof identd replies
** 1: User may provide its own identd reply (which is contained in ~/.ispoof)
** 2: User's identd reply is specified in the /etc/identd.spoof file
*/
#define SPOOF_NOPERM	0
#define SPOOF_OK		1
#define SPOOF_SET		2

#define ERROR(x) ((flags & HIDEE) ? "UNKNOWN-ERROR" : (x))
#define OS(x) ((flags & HIDEO) ? (u_char *) "OTHER" : ((u_char *) (x)))
#define VALID_PORT(p) (((p) != 0 && (((p) & 0xffff) == (p))))

#define EMAIL	"odin@numb.org"
#define URL		"http://ojnk.sourceforge.net"

void *xmalloc(size_t);
int get_user(int, int, const struct in_addr *, const struct in_addr *);
int get_addr(const u_char *const, u_long *);
ssize_t sockread(int fd, u_char *buf, size_t len);

#ifndef HAVE_DPRINTF
	int dprintf(int, const char *, ...);
#endif

#if defined(__linux__)
#	if defined(MASQ_SUPPORT)
		int masq(int, int, int, const struct in_addr *);
#	endif /* masq */
#else
		int k_open(void);
#endif /* __linux__ */


#endif /* __OIDENTD_H_ */
