/* NetLeds applet - Lights from a network device
 * Copyright (C) 1999 Michael Witrant
 *
 * Homepage: http://netleds.port5.com
 * Author: Michael Witrant
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "config.h"
#include "netleds.h"
#include "proc.h"
#include <glibtop.h>
#include <glibtop/close.h>


/* Timer's id */
int timer = -1;

/* Delay between updates (ms) */
gint update_delay = DEFAULT_DELAY;

/* Name of the device to monitor */
char *device_name = NULL;

/* The applet */
GtkWidget *applet = NULL;

/* Current panel orientation */
PanelOrientType orient;

static void about_cb (AppletWidget *widget, gpointer data);
static void applet_change_orient(GtkWidget *w, PanelOrientType o, gpointer data);



static void about_cb (AppletWidget *widget, gpointer data)
{
	GtkWidget *about;
	const gchar *authors[8];

	authors[0] = "Michael Witrant <bmbros@magicnet.org>";
	authors[1] = NULL;

        about = gnome_about_new ( _("NetLeds Applet"), VERSION,
			"(C) 1999",
			authors,
			_("Released under the GNU General Public License.\n"
			"A network device status indicator."),
			NULL);
	gtk_widget_show (about);
}

/* The timer seems to be deleted after the pixmaps and may call 'draw' when
   pixmaps are destroyed. So we must remove it manually before gtk deletes 
   pixmaps */
static void close_applet(GtkWidget *w, GdkEvent *event, gpointer data)
{
	if (timer != -1)
		gtk_timeout_remove(timer);
	leds_destroy_widget();
	gtk_main_quit();
}

static void applet_change_orient(GtkWidget *w, PanelOrientType o, gpointer data)
{
	orient = o;
	draw_orient_changed();
}

/* Start a new timer (and remove the previous one if it exists) */
void start_timer()
{
	if (timer != -1)
		gtk_timeout_remove(timer);
	timer = gtk_timeout_add(update_delay, (GtkFunction)draw, NULL);
}

/* sesion save signal handler*/
static gint applet_save_session(GtkWidget *w,
		const char *privcfgpath,
		const char *globcfgpath)
{
	property_save(privcfgpath);
	return FALSE;
}

int main(int argc, char **argv)
{
	glibtop_init();

	/* intialize, this will basically set up the applet, corba and
	   call gnome_init */
	applet_widget_init("netleds_applet", VERSION, argc, argv, NULL, 0, NULL);

	/* create a new applet_widget */
	applet = applet_widget_new("netleds_applet");
	/* in the rare case that the communication with the panel
	   failed, error out */

	if (!applet)
		g_error("Can't create applet!\n");

	orient = applet_widget_get_panel_orient(APPLET_WIDGET(applet));

	memset(leds,0,NBLEDS_MAX * sizeof(led));

	/* default properties */
	led_set_properties( 0, 1, 0 );
	led_set_properties( 1, 0, 0 );
	led_set_properties( 2, 6, 1 );

	property_load(APPLET_WIDGET(applet)->privcfgpath);

	gtk_signal_connect(GTK_OBJECT(applet),"delete_event",
				GTK_SIGNAL_FUNC(close_applet),
				NULL);
	gtk_signal_connect(GTK_OBJECT(applet),"change_orient",
				GTK_SIGNAL_FUNC(applet_change_orient),
				NULL);

	gtk_signal_connect(GTK_OBJECT(applet),"save_session",
			   GTK_SIGNAL_FUNC(applet_save_session),
			   NULL);

	if (!draw_init(applet))
		g_error("Can't init drawing\n");

	/* display the lights */
	draw_all();

	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
		"properties",
		GNOME_STOCK_MENU_PROP,
		_("Properties..."),
		property_show,
		NULL);
	applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					      "about",
					      GNOME_STOCK_MENU_ABOUT,
					      _("About..."),
					      about_cb, NULL);

	gtk_widget_show (applet);

	start_timer();

	/* special corba main loop */
	applet_widget_gtk_main ();

	glibtop_close();

	gtk_exit(0); 
	return 0;
}

