!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  bcc_ladd.S
!* Purpose: Routines required by bcc
!* Entries: laddl, ldecl, lincl, lnegl, lsubl, laddul, ldecul, lincul,
!*          lnegul, lsubul
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text


! If we are using the peephole optimizer for BCC all routines in this
! file should be unnecessary, so prevent it from getting included by
! disabling all public definitions.
#ifndef OPT386
	public	laddl		! define entry points
	public	ldecl
	public	lincl
	public	lnegl
	public	lsubl
	public	laddul
	public	ldecul
	public	lincul
	public	lnegul
	public	lsubul
#endif


!
!**************************************************************************
!
! Define BCC support functions
!
! ADD
laddl:
laddul:	add	ax,[di]
	adc	bx,2[di]
	ret


! SUB
lsubl:
lsubul:	sub	ax,[di]
	sbb	bx,2[di]
	ret


! NEG
lnegl:
lnegul:	neg	bx
	neg	ax
	sbb	bx,#0
	ret


! DEC
ldecl:
ldecul:
#ifdef IS386
	dec	dword ptr [bx]
#else
	cmp	word ptr [bx],#0
	jne	ldec8
	dec	word ptr 2[bx]
ldec8:	dec	word ptr [bx]
#endif
	ret


! INC
lincl:
lincul:
#ifdef IS386
	inc	dword ptr [bx]
#else
	inc	word ptr [bx]
	jne	lincl9
	inc	word ptr 2[bx]
#endif
lincl9:	ret	


!
!**************************************************************************
!
	end

