;;; liece-modules.el --- Module definitions.
;; Copyright (C) 1999 Daiki Ueno

;; Author: Daiki Ueno <ueno@ueda.info.waseda.ac.jp>
;; Created: 1999-04-12
;; Revised: 1999-03-02
;; Keywords: IRC, liece, APEL

;; This file is part of Liece.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(defvar liece-modules-to-compile
  '(queue-m
    gettext
    llunf
    liece-compat
    liece-version
    liece-vars
    liece-globals
    liece-inlines
    liece-filter
    liece-dcc
    liece-menu
    liece-000
    liece-200
    liece-300
    liece-400
    liece-500
    liece-nick
    liece-channel
    liece-commands
    liece-ctcp
    liece-q-el
    liece-message
    liece-handle
    liece-hilit
    liece-intl
    liece-mail
    liece-minibuf
    liece-misc
    liece-tcp
    liece-url
    liece-x-face
    liece-window
    liece-crypt
    liece))

(require 'emu)
(if running-xemacs
    (add-to-list 'liece-modules-to-compile 'liece-xemacs)
  (add-to-list 'liece-modules-to-compile 'liece-emacs)
  (if (fboundp 'set-face-stipple)
      (add-to-list 'liece-modules-to-compile 'bitmap-stipple))
  )

(when (featurep 'mule)
    (add-to-list 'liece-modules-to-compile 'liece-coding)
    )

(condition-case ()
    (progn
      (require 'pccl)
      (require 'ccl))
  (error nil))

(require 'broken)

(unless-broken ccl-usable
  (add-to-list 'liece-modules-to-compile 'liece-q-ccl))

(condition-case ()
    (require 'cus-face)
  (file-error nil))

(setq liece-modules (cons 'liece-setup liece-modules-to-compile))

;;; liece-modules.el ends here.