/*
 ui-printtext.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

typedef struct
{
    PLUGIN_REC *plugin;
    FORMAT_REC *formats;
}
PLUGIN_FORMAT_REC;

static GHashTable *pluginformats;

void printformat_plugin_init(PLUGIN_REC *plugin, FORMAT_REC *formats)
{
    PLUGIN_FORMAT_REC *rec;

    rec = g_new0(PLUGIN_FORMAT_REC, 1);
    rec->plugin = plugin;
    rec->formats = formats;
    g_hash_table_insert(pluginformats, plugin, rec);
}

static gboolean sig_plugin_destroyed(PLUGIN_REC *plugin)
{
    PLUGIN_FORMAT_REC *rec;

    rec = g_hash_table_lookup(pluginformats, plugin);
    if (rec != NULL)
    {
	g_free(rec);
	g_hash_table_remove(pluginformats, plugin);
    }

    return TRUE;
}

void printformat_plugin(SERVER_REC *server, gchar *channel, gint level, PLUGIN_REC *plugin, gint formatnum, ...)
{
    PLUGIN_FORMAT_REC *format;
    PLUGIN_THEME_REC *theme;
    GString *out;
    va_list args;

    if (pluginformats == NULL)
    {
	/* When quitting this is NULL while plugins try to print their
	   quit messages.. */
	return;
    }

    va_start(args, formatnum);
    out = g_string_new(NULL);

    /* Find plugin default formats */
    format = g_hash_table_lookup(pluginformats, plugin);
    g_return_if_fail(format != NULL);

    /* Find theme specific formats */
    theme = g_hash_table_lookup(current_theme->plugins, plugin->name);

    output_format_text_args(out, server, channel, level, &format->formats[formatnum+1],
			    theme == NULL ? NULL : theme->format[formatnum], args);
    printtext(server, channel, level, "%s", out->str);

    g_string_free(out, TRUE);
    va_end(args);
}

void ui_printtext_plugin_init(void)
{
    pluginformats = g_hash_table_new((GHashFunc) g_direct_hash, (GCompareFunc) g_direct_equal);

    signal_add("plugin destroyed", (SIGNAL_FUNC) sig_plugin_destroyed);
}

void ui_printtext_plugin_deinit(void)
{
    GList *tmp;

    for (tmp = plugins; tmp != NULL; tmp = tmp->next)
	sig_plugin_destroyed(tmp->data);

    g_hash_table_destroy(pluginformats);
    pluginformats = NULL;

    signal_remove("plugin destroyed", (SIGNAL_FUNC) sig_plugin_destroyed);
}
