/*
 setup-channels.c : Irssi settings

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

static SETUP_CHANNEL_REC *setupchannel_add(GList **channels, proplist_t prop)
{
    SETUP_CHANNEL_REC *rec;
    gchar *channel, *ircnet, *password, *botmasks, *autosendcmd, *background, *font;
    gboolean autojoin;

    g_return_val_if_fail(channels != NULL, NULL);
    g_return_val_if_fail(prop != NULL, NULL);

    channel = config_get_str(prop, "name", NULL);
    ircnet = config_get_str(prop, "ircnet", NULL);
    if (channel == NULL || ircnet == NULL)
    {
	/* missing information.. */
	return NULL;
    }

    autojoin = config_get_bool(prop, "autojoin", FALSE);
    password = config_get_str(prop, "password", NULL);
    botmasks = config_get_str(prop, "botmasks", NULL);
    autosendcmd = config_get_str(prop, "autosendcmd", NULL);
    background = config_get_str(prop, "background", NULL);
    font = config_get_str(prop, "font", NULL);

    rec = g_new(SETUP_CHANNEL_REC, 1);
    rec->autojoin = autojoin;
    rec->name = g_strdup(channel);
    rec->ircnet = g_strdup(ircnet);
    rec->password = (password == NULL || *password == '\0') ? NULL : g_strdup(password);
    rec->botmasks = (botmasks == NULL || *botmasks == '\0') ? NULL : g_strdup(botmasks);
    rec->autosendcmd = (autosendcmd == NULL || *autosendcmd == '\0') ? NULL : g_strdup(autosendcmd);
    rec->background = (background == NULL || *background == '\0') ? NULL : g_strdup(background);
    rec->font = (font == NULL || *font == '\0') ? NULL : g_strdup(font);

    *channels = g_list_append(*channels, rec);
    return rec;
}

void setup_channels_init(void)
{
    proplist_t sprop, pvalue;
    gint num, max;

    source_host_ok = FALSE;

    /* Read channels */
    sprop = config_get_prop(cprop, "channels");
    max = sprop == NULL ? 0 : PLGetNumberOfElements(sprop);
    for (num = 0; num < max; num++)
    {
	pvalue = PLGetArrayElement(sprop, num);
        setupchannel_add(&setupchannels, pvalue);
    }
}

void setup_channels_deinit(void)
{
}
