#ifndef __SERVER_IDLE_H
#define __SERVER_IDLE_H

/* Add new idle command to queue */
gint server_idle_add(SERVER_REC *server, gchar *cmd, gchar *arg, gint last, ...);

/* Add new idle command to first of queue */
gint server_idle_add_first(SERVER_REC *server, gchar *cmd, gchar *arg, gint last, ...);

/* Add new idle command to specified position of queue */
gint server_idle_insert(SERVER_REC *server, gchar *cmd, gchar *arg, gint tag, gint last, ...);

/* Check if record is still in queue */
gboolean server_idle_find(SERVER_REC *server, gint tag);

/* Remove record from idle queue */
gboolean server_idle_remove(SERVER_REC *server, gint tag);

void servers_idle_init(void);
void servers_idle_deinit(void);

#endif
