/*
 levels.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"

#define LEVELS 24

static gchar *levels[] =
{
    "CRAP",
    "MSGS",
    "PUBLIC",
    "NOTICES",
    "SNOTES",
    "CTCPS",
    "ACTIONS",
    "JOINS",
    "PARTS",
    "QUITS",
    "KICKS",
    "MODES",
    "SMODES",
    "TOPICS",
    "WALLOPS",
    "INVITES",
    "NICKS",
    "PONGS",
    "DCC",
    "CLIENTNOTICE",
    "CLIENTCRAP",
    "CLIENTERROR",
    "HILIGHT",

    "NOHILIGHT",
};

gint level2bits(gchar *str)
{
    gchar *orig, *ptr;
    gint level;

    g_return_val_if_fail(str != NULL, 0);

    if (*str == '\0') return 0;

    orig = str = g_strdup(str);
    g_strup(str);

    level = 0;
    for (ptr = str; ; str++)
    {
        if (*str == ' ' || *str == '\0')
        {
            gint neg, n;

            if (*str == ' ') *str++ = '\0';

            neg = *ptr == '-' ? 1 : 0;
            if (*ptr == '-' || *ptr == '+') ptr++;

            if (strcmp(ptr, "ALL") == 0)
            {
                if (!neg)
                    level |= MSGLEVEL_ALL;
                else
                    level &= ~MSGLEVEL_ALL;
            }
	    else if (strcmp(ptr, "NEVER") == 0)
	    {
                if (!neg)
                    level |= MSGLEVEL_NEVER;
                else
                    level &= ~MSGLEVEL_NEVER;
	    }
	    else
            {
                for (n = 0; n < LEVELS; n++)
                {
                    if (strcmp(ptr, levels[n]) == 0)
                    {
                        if (!neg)
                            level |= 1 << n;
                        else
                            level &= ~(1 << n);
                        break;
                    }
                }
            }

            while (*str == ' ') str++;
            if (*str == '\0') break;
            ptr = str;
        }
    }
    g_free(orig);

    return level;
}

gchar *bits2level(gint bits)
{
    GString *str;
    gchar *ret;
    gint n;

    if (bits == MSGLEVEL_ALL)
        return g_strdup("ALL");

    str = g_string_new(NULL);
    if (bits & MSGLEVEL_NEVER)
	g_string_append(str, "NEVER");

    for (n = 0; n < LEVELS; n++)
    {
        if (bits & (1 << n))
        {
            if (*str->str != '\0')
                g_string_append_c(str, ' ');

            g_string_append(str, levels[n]);
        }
    }

    ret = str->str;
    g_string_free(str, FALSE);

    return ret;
}

gint combine_level(gint level, gchar *str)
{
    GList *list, *tmp;
    gchar *item;
    gint itemlevel;

    g_return_val_if_fail(str != NULL, level);

    list = str2list(str, ' ');
    for (tmp = list; tmp != NULL; tmp = tmp->next)
    {
        item = tmp->data;

        itemlevel = level2bits(item + (*item == '+' || *item == '-' ? 1 : 0));
        if (*item == '+')
            level |= itemlevel;
        else if (*item == '-')
            level &= ~(itemlevel);
        else
            level = itemlevel;
    }

    if (list != NULL)
    {
	g_free(list->data);
	g_list_free(list);
    }

    return level;
}
