/*

 gui-textwidget.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "../ui-common/txt.h"

static gchar *gui_window_line2text(LINE_REC *line)
{
    gint n, color;
    GString *str;
    gboolean uline;
    gchar *s;

    g_return_val_if_fail(line != NULL, NULL);

    str = g_string_new(NULL);

    color = -1; uline = FALSE;
    for (n = 0; n < line->linelen; n++)
    {
        if (line->line[n*2] != color)
        {
	    color = line->line[n*2];

	    /* underline */
	    if ((color & ATTR_UNDERLINE) || (uline && (color & ATTR_UNDERLINE) == 0))
	    {
		g_string_append_c(str, 31);
		uline = (color & ATTR_UNDERLINE);
	    }

	    if (color & ATTR_COLOR8)
		g_string_sprintfa(str, "\003%c%c", 9, ((color & 0xf0) >> 4)+1);
	    else
		g_string_sprintfa(str, "\003%c%c", (color & 0x0f)+1, ((color & 0xf0) >> 4)+1);
        }
        g_string_append_c(str, line->line[n*2+1]);
    }

    s = str->str;
    g_string_free(str, FALSE);
    return s;
}

static gboolean cmd_last(gchar *data)
{
    GList *tmp, *arglist;
    GSList *list, *line;
    gchar *params, *str, *args, *text;
    struct tm *tm;
    gint level;

    g_return_val_if_fail(data != NULL, FALSE);

    params = cmd_get_params(data, 2 | PARAM_FLAG_GETREST | PARAM_FLAG_OPTARGS, &args, &text);

    /* level can be specified in arguments.. */
    level = 0;
    arglist = str2list(args, ' ');
    for (tmp = arglist; tmp != NULL; tmp = tmp->next)
        level |= level2bits((gchar *) (tmp->data)+1);
    if (level == 0) level = MSGLEVEL_ALL;

    if (arglist != NULL)
    {
	g_free(arglist->data);
	g_list_free(arglist);
    }

    printformat(NULL, NULL, MSGLEVEL_CLIENTCRAP, IRCTXT_LASTLOG_START);

    list = gui_window_find_text(CHANNEL_PARENT(cur_channel), text);
    for (line = list; line != NULL; line = line->next)
    {
        LINE_REC *rec = line->data;

        if (rec->loglevel & level)
        {
	    text = gui_window_line2text(rec);
	    if (setup_get_bool("toggle_show_timestamps"))
		printtext(NULL, NULL, MSGLEVEL_CLIENTCRAP, text);
            else
            {
                tm = localtime(&rec->time);

                str = g_strdup_printf("[%02d:%02d] %s", tm->tm_hour, tm->tm_min, text);
                printtext(NULL, NULL, MSGLEVEL_CLIENTCRAP, str);
                g_free(str);
	    }
	    g_free(text);
        }
    }

    printformat(NULL, NULL, MSGLEVEL_CLIENTCRAP, IRCTXT_LASTLOG_END);

    g_slist_free(list);
    g_free(params);
    return TRUE;
}

void gui_textwidget_init(void)
{
    command_bind("last", NULL, (SIGNAL_FUNC) cmd_last);
}

void gui_textwidget_deinit(void)
{
    command_unbind("last", (SIGNAL_FUNC) cmd_last);
}
