/*
 setup-session.c :

    Copyright (C) 1999 Timo Sirainen
                       Kari Lavikka (tuner@bdb.fi)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(GtkWidget *dialog)
{
    return TRUE;
}

static gboolean sig_setup_destroyed(void)
{
    setup_dialog = NULL;

    return TRUE;
}

static void sig_new_window(GtkWidget *widget, GtkCTree *ctree)
{
    GtkCTreeNode *node;
    gchar *texts[2];

    texts[0] = "Window";
    texts[1] = "blah";
    node = gtk_ctree_insert_node(ctree, NULL, NULL, texts, 0,
				 NULL, NULL, NULL, NULL, FALSE, FALSE);
}

static void sig_new_tab(GtkWidget *widget, GtkCTree *ctree)
{
    GtkCTreeNode *node;
    gchar *texts[2];

    node = gtk_object_get_data(GTK_OBJECT(ctree), "selection");
    if (node == NULL) return;

    if (gtk_ctree_node_get_row_data(ctree, node) != NULL)
	return;

    texts[0] = "Tab";
    texts[1] = "blah";
    node = gtk_ctree_insert_node(ctree, node, NULL, texts, 0,
				 NULL, NULL, NULL, NULL, FALSE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node, "1");
}

static void sig_new_channel(GtkWidget *widget, GtkCTree *ctree)
{
    GtkCTreeNode *node;
    gchar *texts[2];

    node = gtk_object_get_data(GTK_OBJECT(ctree), "selection");
    if (node == NULL) return;

    texts[0] = "#channel";
    texts[1] = "blah";
    node = gtk_ctree_insert_node(ctree, node, NULL, texts, 0,
				 NULL, NULL, NULL, NULL, FALSE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node, "2");
}

static void sig_remove(GtkWidget *widget, GtkCTree *ctree)
{
}

static void sig_select_row(GtkCTree *ctree, GtkCTreeNode *node, gint column)
{
    gtk_object_set_data(GTK_OBJECT(ctree), "selection", node);
}

static void sig_unselect_row(GtkCTree *ctree, GtkCTreeNode *node, gint column)
{
    gtk_object_set_data(GTK_OBJECT(ctree), "selection", NULL);
}

static gboolean setup_session(GtkWidget *dialog)
{
    GtkWidget *hbox, *scrollbox, *ctree, *buttonbox, *button;

    setup_dialog = dialog;

    hbox = gtk_hbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(hbox), 7);

    scrollbox = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollbox),
                                   GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_box_pack_start(GTK_BOX(hbox), scrollbox, TRUE, TRUE, 0);

    ctree = gtk_ctree_new(2, 0);
    gtk_clist_set_column_auto_resize(GTK_CLIST(ctree), 0, TRUE);
    gtk_clist_set_column_auto_resize(GTK_CLIST(ctree), 1, TRUE);
    gtk_container_add(GTK_CONTAINER(scrollbox), ctree);

    gtk_signal_connect(GTK_OBJECT(ctree), "tree_select_row",
                       GTK_SIGNAL_FUNC(sig_select_row), NULL);
    gtk_signal_connect(GTK_OBJECT(ctree), "tree_unselect_row",
                       GTK_SIGNAL_FUNC(sig_unselect_row), NULL);

    buttonbox = gtk_vbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox), buttonbox, FALSE, FALSE, 0);

    button = gtk_button_new_with_label (_("New Window..."));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			      GTK_SIGNAL_FUNC(sig_new_window), ctree);
    gtk_container_add(GTK_CONTAINER(buttonbox), button);

    button = gtk_button_new_with_label (_("New Tab..."));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			      GTK_SIGNAL_FUNC(sig_new_tab), ctree);
    gtk_container_add(GTK_CONTAINER(buttonbox), button);

    button = gtk_button_new_with_label (_("New Channel..."));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
			      GTK_SIGNAL_FUNC(sig_new_channel), ctree);
    gtk_container_add(GTK_CONTAINER(buttonbox), button);

    button = gtk_button_new_with_label (_("Remove"));
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(sig_remove), ctree);
    gtk_container_add(GTK_CONTAINER(buttonbox), button);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
				   hbox, gtk_label_new(_("Session")));

    return TRUE;
}

void init_session(void)
{
    setup_dialog = NULL;

    signal_add("setup session apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup session destroyed", (SIGNAL_FUNC) sig_setup_destroyed);
    signal_add("setup session", (SIGNAL_FUNC) setup_session);
}

void deinit_session(void)
{
    if (setup_dialog != NULL)
        gtk_widget_destroy(setup_dialog);

    signal_remove("setup session apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup session destroyed", (SIGNAL_FUNC) sig_setup_destroyed);
    signal_remove("setup session", (SIGNAL_FUNC) setup_session);
}
