/*
 setup-lookandfeel.c : irssi

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "irssi.h"
#include "setup-int.h"

static GtkWidget *setup_dialog;

static gboolean sig_setup_apply(void)
{
    setup_write("lookandfeel", lookandfeel_options);
    return TRUE;
}

static void sig_change_taborient(GtkWidget *menuitem, gpointer data)
{
    GtkWidget *dialog;

    g_return_if_fail(menuitem != NULL);

    gtk_object_set_data(GTK_OBJECT(menuitem->parent), "value", data);
    dialog = gtk_object_get_data(GTK_OBJECT(menuitem->parent), "dialog");
    gnome_property_box_changed(GNOME_PROPERTY_BOX(setup_dialog));
}

static void sig_nomsgwin_clicked(GtkToggleButton *button, GtkWidget *widget)
{
    gboolean active;

    active = gtk_toggle_button_get_active(button);
    gtk_widget_set_sensitive(widget, active);
    if (!active)
	gtk_toggle_button_set_active(lookandfeel_options[OPTION_AUTOCREATE_QUERIES].widget, FALSE);
}

static gboolean setup_lookandfeel(GtkWidget *dialog)
{
    GtkWidget *vbox, *mainvbox, *hbox, *frame, *checkbox;
    GtkWidget *label, *optionmenu, *menu, *menuitem;

    setup_dialog = dialog;

    mainvbox = gtk_vbox_new(FALSE, 7);
    gtk_container_border_width(GTK_CONTAINER(mainvbox), 7);

    hbox = gtk_hbox_new(FALSE, 7);
    gtk_box_pack_start(GTK_BOX(mainvbox), hbox, FALSE, FALSE, 0);

    /* --- */
    frame = gtk_frame_new(_("Interface"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Show menubar"));
    lookandfeel_options[OPTION_SHOW_MENUBAR].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Show toolbar"));
    lookandfeel_options[OPTION_SHOW_TOOLBAR].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Show status bar"));
    lookandfeel_options[OPTION_SHOW_STATUSBAR].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Notifylist popup dialogs"));
    lookandfeel_options[OPTION_NOTIFYLIST_POPUPS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Beep on private msgs"));
    lookandfeel_options[OPTION_PRIVMSG_BEEPS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* --- */
    frame = gtk_frame_new(_("Channels"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Show nick list"));
    lookandfeel_options[OPTION_SHOW_NICKLIST].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Show time stamps"));
    lookandfeel_options[OPTION_SHOW_TIMESTAMPS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Show time stamps with msgs"));
    lookandfeel_options[OPTION_SHOW_MSGS_TIMESTAMPS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Do not show styling (bold, colors, etc.)"));
    lookandfeel_options[OPTION_HIDE_TEXT_STYLES].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Allow beeping"));
    lookandfeel_options[OPTION_BELL_BEEPS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* --- */
    hbox = gtk_hbox_new(FALSE, 7);
    gtk_box_pack_start(GTK_BOX(mainvbox), hbox, FALSE, FALSE, 0);

    frame = gtk_frame_new(_("Window and Tabs"));
    gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(vbox), 5);
    gtk_container_add(GTK_CONTAINER(frame), vbox);

    checkbox = gtk_check_button_new_with_label(_("Use a special window for status information"));
    lookandfeel_options[OPTION_USE_STATUS_WINDOW].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_radio_button_new_with_label(NULL, _("Use a special window for all incoming messages"));
    lookandfeel_options[OPTION_USE_MSGS_WINDOW].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(checkbox)),
					       _("Do not use a special window for all incoming messages"));
    /* ... -> */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbox), TRUE);
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* just to add some space .. any better ways? */
    hbox = gtk_hbox_new(FALSE, 14);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), gtk_label_new(""), FALSE, FALSE, 0);

    /* <- ... */
    gtk_signal_connect(GTK_OBJECT(checkbox), "clicked",
                       GTK_SIGNAL_FUNC(sig_nomsgwin_clicked), hbox);

    checkbox = gtk_check_button_new_with_label(_("Create a new window for each incoming query"));
    lookandfeel_options[OPTION_AUTOCREATE_QUERIES].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(hbox), checkbox, TRUE, TRUE, 0);

    checkbox = gtk_check_button_new_with_label(_("Automatically raise Messages Window(s)"));
    lookandfeel_options[OPTION_AUTORAISE_MSGS_WINDOW].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    checkbox = gtk_check_button_new_with_label(_("Use Tabs instead of new Windows"));
    lookandfeel_options[OPTION_USE_TABBED_WINDOWS].widget = checkbox;
    gtk_box_pack_start(GTK_BOX(vbox), checkbox, FALSE, FALSE, 0);

    /* just to add some space .. any better ways? */
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    label = gtk_label_new(_("Tab position"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    optionmenu = gtk_option_menu_new();
    gtk_widget_set_usize(optionmenu, 100, -1);
    gtk_box_pack_start(GTK_BOX(hbox), optionmenu, FALSE, FALSE, 0);

    menu = gtk_menu_new();
    lookandfeel_options[OPTION_TAB_ORIENTATION].widget = menu;
    gtk_object_set_data(GTK_OBJECT(menu), "value", GINT_TO_POINTER(*((gint *) lookandfeel_options[OPTION_TAB_ORIENTATION].data)));

    menuitem = gtk_menu_item_new_with_label(_("Left"));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(sig_change_taborient), GINT_TO_POINTER(0));
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_("Right"));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(sig_change_taborient), GINT_TO_POINTER(1));
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_("Top"));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(sig_change_taborient), GINT_TO_POINTER(2));
    gtk_menu_append(GTK_MENU(menu), menuitem);

    menuitem = gtk_menu_item_new_with_label(_("Bottom"));
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(sig_change_taborient), GINT_TO_POINTER(3));
    gtk_menu_append(GTK_MENU(menu), menuitem);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu), menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu), *((gint *) lookandfeel_options[OPTION_TAB_ORIENTATION].data));

    setup_finish_init(dialog, lookandfeel_options);

    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dialog),
                                   mainvbox, gtk_label_new(_("Look & Feel")));
    return TRUE;
}

void init_lookandfeel(void)
{
    signal_add("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_add("setup preferences", (SIGNAL_FUNC) setup_lookandfeel);
}

void deinit_lookandfeel(void)
{
    signal_remove("setup preferences apply", (SIGNAL_FUNC) sig_setup_apply);
    signal_remove("setup preferences", (SIGNAL_FUNC) setup_lookandfeel);
}
