/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* transfer class for iroffer (.cpp) */
void t_initvalues (transfer *t) {
      t->status = 'U';
      t->listensocket=1000;
      t->clientsocket=1000;
      t->filedescriptor=1000;
      t->lastcontact = curtime;
      t->id = 200;   
   }

void t_setuplisten (transfer *t) {
      int i;
      
      if ((t->listensocket = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
         outerror(1,"Could Not Create Socket, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }

      bzero (&t->serveraddress, sizeof (struct sockaddr_in));
      
      t->serveraddress.sin_family = AF_INET;
      
	  t->serveraddress.sin_addr.s_addr = INADDR_ANY;
	  
	  if (firewall)
	     t->serveraddress.sin_port = htons(dccrangestart+t->whichtransfer);
	  else
	     t->serveraddress.sin_port = htons(0);
      
      i = 0;
      while ( i < 20 ) {
         if ((bind(t->listensocket, (struct sockaddr *)&t->serveraddress, sizeof(struct sockaddr_in))) < 0) {
            i++;
            if (firewall)
               t->serveraddress.sin_port = htons(dccrangestart+t->whichtransfer+i);
            else i = 50;
            }
         else
            i = 50;
         }
      if ( i != 50) {
         outerror(1,"Couldn't Bind to Socket, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
      
      t->addrlen = sizeof (struct sockaddr_in);

      if ((getsockname (t->listensocket, (struct sockaddr *)&t->serveraddress, &t->addrlen)) < 0) {
         outerror(1,"Couldn't get Port Number, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
      
	  t->listenport = ntohs (t->serveraddress.sin_port);
	  
	  if (listen (t->listensocket, 1) < 0) {
         outerror(1,"Couldn't Listen, Aborting");
         t_closeconn(t,"Connection Error, Try Again");
         return;
         }
	  
	  t->status = 'L';
	  
	  highestsock();
   }

void t_establishcon (transfer *t) {
   char *tempstr;

#if !defined(_OS_SunOS)
   SIGNEDSOCK int tempi;
   int tempc;
#endif
   
   
   t->addrlen = sizeof (t->serveraddress);
   
   if (!attop) gototop();
   
   if ((t->clientsocket = accept(t->listensocket, (struct sockaddr *) &t->serveraddress, &t->addrlen)) < 0) {
      outerror(1,"Accept Error, Aborting");
      t_closeconn(t,"Connection Error, Try Again");
      return;
      }
      
   FD_CLR(t->listensocket, &readset);
   t->status='S';
   close(t->listensocket);
   t->listensocket = 1000;
   highestsock();
   
   tempstr = mycalloc(maxtextlength,"t_establishcon");
   snprintf(tempstr,maxtextlength-2,"XDCC [%02i:%s]: Connection established",t->id,t->nick);
   ioutput1(0,OUT_S|OUT_L|OUT_D,"0;33",tempstr);
   mydelete(tempstr);
   
   if (debug) {
      ioutput1(1,OUT_S,"0;33","clientsock = ");
      ioutputi(OUT_S,t->clientsocket);
      ioutput1(3,OUT_S,"0;33","");
      }
      
   t->filedescriptor=open(t->xpack->file, O_RDONLY);
   if (t->filedescriptor < 0) {
      outerror(1,"An Offered File Could Not Be Opened Or Read, Aborting");
      t_closeconn(t,"File Error, Report the Problem to the Owner");
      return;
      }
   
   lseek(t->filedescriptor, t->startresume, SEEK_SET);
   t->bytessent = t->startresume;
   
#if !defined(_OS_SunOS)
   tempi = sizeof(int);
   if (debug) printf("SO_SNDBUF ");
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (debug) printf(" a %li",(long)tempc);
   
   tempc = 65535;
   setsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, sizeof(int));

   if (debug) printf(" b %li",(long)tempc);
   getsockopt(t->clientsocket, SOL_SOCKET, SO_SNDBUF, &tempc, &tempi);
   if (debug) printf(" c %li\n",(long)tempc);
#endif
   
#if defined(_OS_BSD_ANY)
   /* #define SO_SNDLOWAT     0x1003     */
   if (debug) printf("SO_SNDLOWAT ");
   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (debug) printf(" %i",tempc);
      
   tempc = 24577;
   setsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, sizeof(int));
   if (debug) printf(" %i",tempc);

   getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
   if (debug) printf(" %i\n",tempc);
#endif
   
   if (fcntl(t->clientsocket, F_SETFL, O_NONBLOCK) < 0 )
      outerror(2,"Couldn't Set Non-Blocking");
   
   
   t->lastcontact = curtime;
   t->connecttime = curtime;
   t->lastspeed = 0;
   t->lastspeedamt = t->startresume;
   
   
   }

void t_transfersome (transfer *t) {
   int i, j, howmuch, howmuch2, tbufsize2;
   SIGNEDSOCK int tempi;
#if defined(_OS_BSD_ANY)
   int tempc;
#endif
   
   if (t->status == 'E') return;
   tbufsize2 = tbufsize;
   
   /* max bandwidth start.... */
   
   j = xdccsent[getend(120,curtime%120)] 
        + xdccsent[getend(120,(curtime%120)-1)]
        + xdccsent[getend(120,(curtime%120)-2)]
        + xdccsent[getend(120,(curtime%120)-3)];
   
   if ( maxb && (j >= maxb*1024)) return; /* over limit */
   
   /* max bandwidth end.... */
   
   
   howmuch = 4096;
   howmuch2 = 1;
   for (i=0; i<tbufsize2; i++) {
      if (howmuch == 4096 && howmuch2 > 0) {
         howmuch = read(t->filedescriptor, sendbuff, 4096);
         howmuch2 = write(t->clientsocket, sendbuff, howmuch);
         
         if (howmuch2 < 0 && errno != EAGAIN) { t->status = 'E'; return;}
         howmuch2 = max2(0,howmuch2);
         
         if (howmuch2 < howmuch)
            lseek(t->filedescriptor,howmuch2-howmuch,SEEK_CUR);
         
         if (howmuch2 > 0) t->lastcontact = curtime;
         
         t->bytessent += howmuch2;
         xdccsent[curtime%120] += howmuch2;
         j += howmuch2;
         
         if (debug2) {
            ioutput1(1,OUT_S,"0;34","File ");
            ioutputi(OUT_S,howmuch);
            ioutput1(2,OUT_S,"0;34"," Write ");
            ioutputi(OUT_S,howmuch2);
            ioutput1(3,OUT_S,"0;34","");
            }
         
         }
      
      /* if over 33% send half to be fair */
      if ( maxb && ((j*100) > (maxb*1024*33)) ) tbufsize2 = max2(1,tbufsize/2);
      
      /* if over 66% send just 1 to be fair */
      if ( maxb && ((j*100) > (maxb*1024*66)) ) tbufsize2 = 1;
      
      }
   
   if ( howmuch < 4096 && howmuch2 == howmuch) {
      t->status = 'W';
   
      tempi =0;
#if defined(_OS_BSD_ANY)
      tempi = sizeof(int);

      /* #define SO_SNDLOWAT     0x1003    */
      /*if (debug) printf("SO_SNDLOWAT "); */
      getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
      /*if (debug) printf(" %i",*tempc); */
  
      tempc = 65534;
      setsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, sizeof(int));
      /*if (debug) printf(" %i",*tempc); */

      getsockopt(t->clientsocket, SOL_SOCKET, 0x1003, &tempc, &tempi);
      /*if (debug) printf(" %i\n",*tempc); */
#endif
      
      }

   
   }

void t_readjunk (transfer *t) {
   int i;
   i = read(t->clientsocket, sendbuff, 4095);

   if (i) t->lastcontact = curtime;

   if (debug2) {
      ioutput1(1,OUT_S,"0;34","Read ");
      ioutputi(OUT_S,i);
      ioutput1(3,OUT_S,"0;34","");
      }
   if (i == -1) {
      if (!attop) gototop();
      t_closeconn(t,"Connection Lost");
      }
   }

void t_istimeout (transfer *t) {
   if ( XFR_TMOUT && (curtime - t->lastcontact > 180)) {
      if (!attop) gototop();
      t_closeconn(t,"DCC Timeout (180 Sec Timeout)");
      }
   }

void t_flushed (transfer *t) {
   char *templine1, *cmpline, *cmpline1, *tempstr;
   int notmatch;
   long timetook;
   int tfiledescriptor;
   int bufflength;
   int whereinbuff;
   int i;
   
   if (t->lastcontact == curtime) return;
   
   templine1 = mycalloc(maxtextlength,"t_flushed");
   cmpline = mycalloc(maxtextlengthshort,"t_flushed");
   cmpline1 = mycalloc(maxtextlengthshort,"t_flushed");
   
   notmatch = 0;
   
#if defined(_OS_BSD_ANY) || defined(_OS_SunOS) 
   if (FD_ISSET(t->clientsocket, &writeset))
      notmatch = 0;
   else
      notmatch = 1;
   tempstr=NULL; /* unused */
   tfiledescriptor=bufflength=whereinbuff=i=1; /* unused */
#elif defined(_OS_Linux_ANY)
   if (t->socknotfound < 60) {
      tfiledescriptor=open("/proc/net/tcp", O_RDONLY);
      if (tfiledescriptor < 0) {
         outerror(1,"/proc/net/tcp could not be opened");
         t->socknotfound++;
         mydelete(templine1);
         mydelete(cmpline);
         mydelete(cmpline1);
         return;
         }

      snprintf(cmpline,maxtextlengthshort-2,"%4.4X",t->listenport);
      
#if defined(_OS_Linux_x86) || defined(_OS_Linux_alpha) 
      snprintf(cmpline1,maxtextlengthshort-2,"%8.8lX",(unsigned long)htonl(ourip));
#else
      snprintf(cmpline1,maxtextlengthshort-2,"%8.8lX",(unsigned long)ourip);
#endif
      
      if (!attop) gototop();
      bufflength = read(tfiledescriptor,tempbuffsock, SOCKLINES * 128);
      tempbuffsock[bufflength] = '\0';
      whereinbuff=0;
      
      while((whereinbuff+127)<bufflength) {
         for (i=0; i<100; i++)
            templine1[i] = tempbuffsock[whereinbuff+i];
         templine1[100] = '\0';
         whereinbuff += 128;
         
         if (PRINTSOCK && debug)
            printf("      %s:%s\n%s\n",cmpline1,cmpline,templine1);
         
         notmatch=0;
         for (i=0; i<8; i++)
            if (templine1[6+i] != cmpline1[i])
               notmatch++;
         for (i=0; i<4; i++)
            if (templine1[15+i] != cmpline[i])
               notmatch++;
         if (!notmatch)
            break;
         }
      
      close (tfiledescriptor);
      
      if (notmatch && t->socknotfound < 60) {
         if (!attop) gototop();
         outerror(1,"Socket Not Found in /proc/net/tcp!");
         t->socknotfound++;
         mydelete(templine1);
         mydelete(cmpline);
         mydelete(cmpline1);
         return;
         }
      
      notmatch=0;
      for (i=37; i<45; i++)
         notmatch += templine1[i]-'0';
      }
#endif /* linux */

   if (!notmatch || t->socknotfound > 59) {
#if defined(_OS_BSD_ANY) || defined(_OS_SunOS)
      if (1) {
#else
      if (t->twicewait) {
#endif
         timetook = curtime - t->connecttime - 1;
         if (timetook < 1)
            timetook = 1;
         
         tempstr = mycalloc(maxtextlength,"t_flushed");
         
         snprintf(tempstr,maxtextlength-2,
              "XDCC [%02i:%s]: Transfer Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              t->id,t->nick,
              (t->xpack->size-t->startresume)/1024,
              (timetook < 3600) ? timetook/60 : timetook/60/60,
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)(t->xpack->size-t->startresume))/1024.0/((float)timetook)
              );
         ioutput1(0,OUT_S|OUT_L|OUT_D,"0;33",tempstr);

         snprintf(tempstr,maxtextlength-2,
              "NOTICE %s :*** Transfer Completed (%li kbytes, %li %s %li %s, %0.1f kbytes/sec)",
              t->nick,
              (t->xpack->size-t->startresume)/1024,
              (timetook < 3600) ? timetook/60 : timetook/60/60,
              (timetook < 3600) ? "min" : "hr",
              (timetook < 3600) ? timetook%60 : (timetook/60)%60,
              (timetook < 3600) ? "sec" : "min",
              ((float)(t->xpack->size-t->startresume))/1024.0/((float)timetook)
              );
         writeserver(tempstr);
         
         mydelete(tempstr);
         
         if ( ((float)(t->xpack->size-t->startresume))/1024.0/((float)timetook) > record )
            record = ((float)(t->xpack->size-t->startresume))/1024.0/((float)timetook);
         
         if (debug) {
            ioutput1(1,OUT_S,"0;33","clientsock = ");
            ioutputi(OUT_S,t->clientsocket);
            ioutput1(3,OUT_S,"0;33","");
            }
         FD_CLR(t->clientsocket, &writeset);
         FD_CLR(t->clientsocket, &readset);
         close(t->clientsocket);
         close(t->filedescriptor);
         t->status='D';
         t->xpack->gets++;
         highestsock();
         }
      else
         t->twicewait = 1;
      }
   
   mydelete(templine1);
   mydelete(cmpline);
   mydelete(cmpline1);
   }

void t_closeconn(transfer *t, char *msg) {
      char *tempstr = mycalloc(maxtextlength,"t_closeconn");
      
      snprintf(tempstr,maxtextlength-2,"XDCC [%02i:%s]: Connection closed: %s",t->id,t->nick,msg);
      ioutput1(0,OUT_S|OUT_L|OUT_D,"0;33",tempstr);
      
      if (debug) printf("[0;33mclientsock = %i[0m\n",t->clientsocket);
      if (t->listensocket != 1000 && t->listensocket > 3) {
         FD_CLR(t->listensocket, &readset);
         close (t->listensocket);
         }
      if (t->clientsocket != 1000 && t->clientsocket > 3) {
         FD_CLR(t->clientsocket, &writeset);
         FD_CLR(t->clientsocket, &readset);
         close(t->clientsocket);
         }
      if (t->filedescriptor != 1000 && t->filedescriptor > 3)
         close(t->filedescriptor);
      t->status='D';
      highestsock();
      
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Closing Connection: %s",t->nick,msg);
      writeserver(tempstr);
      
      mydelete(tempstr);
   }

void t_setresume(transfer *t, char *amt) {
   amt[strlen(amt)-1] = '\0';
   t->startresume = atoi(amt);
   }

void t_remind(transfer *t) {
   char *tempstr = mycalloc(maxtextlength,"t_remind");
   snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** You have a DCC pending, Set your client to receive the transfer. (%li seconds remaining until timeout)",
      t->nick,t->lastcontact+180-curtime);
   writeserver(tempstr);
   t->reminded++;
   mydelete(tempstr);
   }

void t_checkminspeed(transfer *t) {
   char *tempstr2;
   if (t->status != 'S')                             return; /* no checking unless we're sending */
   if (t->connecttime+MIN_TL > curtime)              return; /* no checking until time has passed */
   if (t->nomin || !(t->xpack->minspeed))            return; /* no minspeed for this transfer */
   if ( t->lastspeed > (((float)t->xpack->minspeed)-0.09) ) return; /* over minspeed */
   
   tempstr2 = mycalloc(maxtextlength,"t_checkminspeed");
   snprintf(tempstr2,maxtextlength-2,
        "Under Min Speed Requirement, %2.1fK/sec is less than %i.0K/sec",
         t->lastspeed,t->xpack->minspeed);
   if (!attop) gototop();
   t_closeconn(t,tempstr2);
   mydelete(tempstr2);
   
   }


