/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* misc for iroffer */

void getconfig (char *filename) {
   char *templine = mycalloc(maxtextlength,"getconfig_templine");
   char *tempc = mycalloc(2,"getconfig_tempc");
   int i,filedescriptor;
   
   printf("*** Loading %s ... \n",filename);
   
   filedescriptor=open(filename, O_RDONLY);
   if (filedescriptor < 0)
      outerror(0,"Couldn't Open Config File");
   
   highmeminfo=1;
   
   i = 0;
   while(read(filedescriptor,tempc,1) == 1) {
      if (tempc[0] == '\n' || tempc[0] == 13) {  /* 13 is ^M */
         templine[i] = '\0';
         if ( templine[0] != '#' && strlen(templine) != 0 ) {
            for (i=strlen(templine)-1; i>2 && templine[i] == ' '; i--)
               templine[i] = '\0';
            getconfig_set (templine,0);
            }
         i = 0;
         }
      else {
         templine[i] = tempc[0];
         i++;
         }
       }
   
   printf("*** Checking for completeness of config file ...\n");
   
   if ( server[0] == NULL
        || user_nick == NULL || user_realname == NULL
        || channel[0] == NULL || slotsmax == 0 
        || xdccautosavetime == 0 || xdccfile == 0)
      outerror(0,"Config File Missing Necessary Information");

   if ( autosend && ( autoword == NULL || automsg == NULL || !autopack ) )
      outerror(0,"Config File Missing Autosend Information");

   if ( plist && ( plisttime == 0 || plistchans == NULL ) )
      outerror(0,"Config File Missing Plist Information");

   
   if (background) debug = 0;
   
   if ( USESCREEN  && !background) {
      printf("[%i;12H%s) >",termlines,user_nick);
      printf("[%i;%iH",termlines, (int)(user_nick ? 16+strlen(user_nick) : 16));
      gototop();
      }
   
   caps_nick = mycalloc(maxtextlengthshort,"getconfig_caps_nick");
   strcpy(caps_nick, user_nick);
   caps(caps_nick);
   
   highmeminfo = 0;
   
   mydelete(tempc);
   mydelete(templine);
   }

void getconfig_set (char *line, int rehash) {
   char *type = mycalloc(maxtextlength,"getconfig_set_type");
   char *var2 = mycalloc(maxtextlength,"getconfig_set_var2");
   char *var;
   char *a,*b;
   struct hostent *thost;
   struct sockaddr_in tsocka;
   int i,j;
   
   for (i=0; i<maxtextlength; i++) {
      if (line[i] == ' ' || line[i] == '\0')
         break;
      type[i] = line[i];
      }
   type[i] = '\0';
   
   for (j=i+1; j<maxtextlength; j++) {
      if (line[j] == '\0')
         break;
      var2[j-i-1] = line[j];
      }
   var2[j-i-1] = '\0';
   
   var = mycalloc(strlen(var2)+2,"getconfig_set_var");
   strcpy(var,var2);
   
   /* parse it */
   if (!strcmp(type,"debug")) {
      if (!strcmp(var,"yes")) {
         debug = 1;
         debug2 = 1;
         }
      else {
         debug = 0;
         debug2 = 0;
         }
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && !rehash) {
      if (!strcmp(var,"yes")) virthost = 1;
      else virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"virthost") && rehash) {
      if (!strcmp(var,"yes")) r_virthost = 1;
      else r_virthost = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"autosend")) {
      if (!strcmp(var,"yes")) autosend = 1;
      else autosend = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"plist")) {
      if (!strcmp(var,"yes")) plist = 1;
      else plist = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"plistminimal")) {
      if (!strcmp(var,"yes")) plistminimal = 1;
      else plistminimal = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"logstats")) {
      if (!strcmp(var,"yes")) logstats = 1;
      else logstats = 0;
      mydelete(var);
      }
   else if (!strcmp(type,"slowlink")) {
      /* no longer used */
      mydelete(var);
      }
   else if (!strcmp(type,"firewall")) {
      if (!strcmp(var,"yes")) firewall = 1;
      else firewall = 0;
      mydelete(var);
      }
   else if ( ! strcmp(type,"dccrangestart")) {
      dccrangestart = atoi(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"server")) {
      for (i=0; server[i] && i<MAXSRVS; i++) ;
      server[i] = var;
      }
   else if ( ! strcmp(type,"channel") && !rehash) {
      for (i=0; channel[i] && i<MAXCHNLS; i++) ;
      channel[i] = var;
      }
   else if ( ! strcmp(type,"channel") && rehash) {
      for (i=0; r_channel[i] && i<MAXCHNLS; i++) ;
      r_channel[i] = var;
      }
   else if ( ! strcmp(type,"adminhost")) {
      for (i=0; adminhost[i] && i<MAXAHOST; i++) ;
      hostmasktoregex(caps(var2));
      adminhost[i] = mycalloc(sizeof(regex_t),"getconfig_set_adminhost[i]");
      if (regcomp(adminhost[i],var2,REG_ICASE|REG_NOSUB))
         adminhost[i] = NULL;
      mydelete(var);
      }
   else if ( ! strcmp(type,"user_nick") && !rehash) {
      mydelete(user_nick);
      user_nick = var;
      }
   else if ( ! strcmp(type,"user_nick") && rehash) {
      mydelete(r_user_nick);
      r_user_nick = var;
      }
   else if ( ! strcmp(type,"user_realname")) {
      mydelete(user_realname);
      user_realname = var;
      }
   else if ( ! strcmp(type,"user_modes")) {
      mydelete(user_modes);
      user_modes = var;
      }
   else if ( ! strcmp(type,"slotsmax")) {
      slotsmax = between(1,atoi(var),MAXTRANS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxpack")) {
      slotsmaxpack = between(0,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxslots")) {
      slotsmaxslots = between(1,atoi(var),MAXTRANS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"vhost_ip") && !rehash) {
      mydelete(vhost_ip);
      vhost_ip = var;
      }
   else if ( ! strcmp(type,"vhost_ip") && rehash) {
      mydelete(r_vhost_ip);
      r_vhost_ip = var;
      }
   else if ( ! strcmp(type,"autoword")){
      mydelete(autoword);
      autoword = var;
      }
   else if ( ! strcmp(type,"automsg")){
      mydelete(automsg);
      automsg = var;
      }
   else if ( ! strcmp(type,"autopack")) {
      autopack = between(1,atoi(var),MAXXDCCS);
      mydelete(var);
      }
   else if ( ! strcmp(type,"plisttime")) {
      plisttime = max2(1,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallminspeed")) {
      overallminspeed = atoi(var);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeed")) {
      overallmaxspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddayspeed")) {
      overallmaxspeeddayspeed = max2(0,atoi(var)*4);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaytime")) {
      a = getpart(var,1,"getconfig_set"); b = getpart(var,2,"getconfig_set");
      if (a && b) {
         overallmaxspeeddaytimestart = between(0,atoi(a),23);
         overallmaxspeeddaytimeend   = between(0,atoi(b),23);
         }
      mydelete(a); mydelete(b);
      mydelete(var);
      }
   else if ( ! strcmp(type,"overallmaxspeeddaydays")) {
      overallmaxspeeddaydays = 0;
      for (i=0; (i<sstrlen(var) && i<8); i++)
         overallmaxspeeddaydays |= dayofweektomask(var[i]);
      mydelete(var);
      }
   else if ( ! strcmp(type,"logrotate")) {
      logrotate = 0;
      if (!strcmp(var,"daily")) logrotate = 1;
      if (!strcmp(var,"weekly")) logrotate = 2;
      if (!strcmp(var,"monthly")) logrotate = 3;
      mydelete(var);
      }
   else if ( ! strcmp(type,"plistchan")) {
      if (!plistchans)
         plistchans = var;
      else {
         strcat(plistchans,",");
         strcat(plistchans,var);
         mydelete(var);
         }
      }
   else if ( ! strcmp(type,"xdccautosavetime")) {
      xdccautosavetime = max2(5,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"slotsmaxqueue")) {
      slotsmaxqueue = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"queuesize")) {
      queuesize = between(0,atoi(var),MAXQUEUE);
      mydelete(var);
      }
   else if ( ! strcmp(type,"adminpass")) {
      mydelete(adminpass);
      adminpass = caps(var);
      }
   else if ( ! strcmp(type,"pidfile") && !rehash) {
      mydelete(pidfile);
      pidfile = var;
      }
   else if ( ! strcmp(type,"pidfile") && rehash) {
      mydelete(r_pidfile);
      r_pidfile = var;
      }
   else if ( ! strcmp(type,"lowbdwth")) {
      lowbdwth = max2(0,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"filedir")) {
      mydelete(filedir);
      filedir = var;
      }
   else if ( ! strcmp(type,"messagefile")) {
      mydelete(messagefile);
      messagefile = var;
      i = open(messagefile, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR );
      if (i > 2) close(i);
      }
   else if ( ! strcmp(type,"logfile")) {
      mydelete(logfile);
      logfile = var;
      }
   else if ( ! strcmp(type,"xdccfile") && !rehash) {
      mydelete(xdccfile);
      xdccfile = var;
      }
   else if ( ! strcmp(type,"xdccfile") && rehash) {
      mydelete(r_xdccfile);
      r_xdccfile = var;
      }
   else if ( ! strcmp(type,"creditline")) {
      mydelete(creditline);
      creditline = var;
      }
   else if ( ! strcmp(type,"plistlimit")) {
      plistlimit = max2(0,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"loginname")) {
      mydelete(loginname);
      loginname = var;
      }
   else if ( ! strcmp(type,"proxyinfo")) {
      mydelete(proxyinfo);
      proxyinfo = var;
      }
   else if ( ! strcmp(type,"maxtransfersperperson")) {
      maxtransfersperperson = max2(1,atoi(var));
      mydelete(var);
      }
   else if ( ! strcmp(type,"usenatip")) {
      usenatip = 1;
      if (( thost = gethostbyname(var)) == NULL) {
         outerror(1,"Can't Resolve NAT Host, Ignoring");
         usenatip = 0;
         }
      else {
         memcpy(&tsocka.sin_addr, *((struct in_addr **)thost->h_addr_list), sizeof(struct in_addr));
         ourip = ntohl(tsocka.sin_addr.s_addr);
         printf("ip=0x%8.8lX\n",ourip);
         }
      mydelete(var);
     /* mydelete(thost); */
      }
   else {
      outerror2(1,"Ignored invalid line in config file: ",type);
      mydelete(var);
      }

   mydelete(type);
   mydelete(var2);
   }

int connectirc (char *tserver) {
   struct sockaddr_in ircserverip;
   struct sockaddr_in localaddr;
   struct hostent *remotehost, *localhost;
   int i;
   
   SIGNEDSOCK int addrlen;
   
   for (i=0; i<30; i++)
      serversent[i]=0;
   
   if (!tserver) return 1;
   
   nocon++;
   
   mydelete(curserverip);
   mydelete(curserverport);
   curserverip = getpart(tserver,1,"connectirc_curserverip");
   curserverport = getpart(tserver,2,"connectirc_curserverport");
   
   if (!curserverport) {
      curserverport = mycalloc(7,"connectirc_curserverport");
      strcpy(curserverport,"6667");
      }
   
   if (virthost && vhost_ip)
      ioutput4(0,OUT_S|OUT_L|OUT_D,NULL,"Attempting Connecting to ",tserver," from ",vhost_ip);
   else
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Attempting Connecting to ",tserver);
   
   if (attop) gotobot();
   
   bzero ((char *) &ircserverip, sizeof (ircserverip));
   
   ircserver = socket( AF_INET, SOCK_STREAM, 0);
   if (ircserver < 0) {
      outerror(1,"Socket Error");
      return 1;
      }
   
   ircserverip.sin_family = AF_INET;
   ircserverip.sin_port = htons(atoi(curserverport));
   
   if (( remotehost = gethostbyname(curserverip)) == NULL) {
      outerror(1,"Can't Resolve Server Host");
      close(ircserver);
      return 1;
      }
   
   memcpy(&ircserverip.sin_addr, *((struct in_addr **)remotehost->h_addr_list), sizeof(struct in_addr));
   
   if (virthost) {
      if (!vhost_ip) outerror(0,"virthost = yes, but no vhost_ip set");
      bzero((char*)&localaddr, sizeof(struct sockaddr_in));
      localaddr.sin_family = AF_INET;
      localaddr.sin_port = 0;
      if (( localhost = gethostbyname(vhost_ip)) == NULL) {
         outerror(1,"Can't Resolve Virtual Host");
         close(ircserver);
         return 1;
         }
      memcpy(&localaddr.sin_addr, *((struct in_addr **)localhost->h_addr_list), sizeof(struct in_addr));
      if (bind(ircserver, (struct sockaddr *) &localaddr, sizeof(localaddr)) < 0) {
         outerror(1,"Couldn't Bind To Virtual Host");
         close(ircserver);
         return 1;
         }
      }
   
   if (fcntl(ircserver, F_SETFL, O_NONBLOCK) < 0 )
      outerror(2,"Couldn't Set Non-Blocking");
   
   alarm(CTIMEOUT);
   /* EINPROGRESS = 115 linux, 150 sunos */
   if (
     connect(ircserver, (struct sockaddr *) &ircserverip, sizeof(ircserverip)) < 0
     && errno != EINPROGRESS) {
      outerror(1,"Connection to Server Failed");
      alarm(0);
      close(ircserver);
      return 1;
      }
   alarm(0);
   
   addrlen = sizeof (ircserverip);
   if (getsockname(ircserver,(struct sockaddr *) &ircserverip, &addrlen) < 0) {
      outerror(1,"Couldn't get sock name");
      close(ircserver);
      return 1;
      }
   
   if (!usenatip)
      ourip = ntohl(ircserverip.sin_addr.s_addr);
   
   if (debug) {
      ioutput1(1,OUT_S,"0;33","ircserver socket = ");
      ioutputi(OUT_S,ircserver);
      ioutput1(3,OUT_S,"0;33","");
      }

   highestsock();
   
   lastservercontact=time(NULL);
   return 0;
   }

void initirc() {
   char *tempstr = mycalloc(maxtextlength,"initirc");
   int i;
   
   highestsock();
   
   if (proxyinfo) {
      snprintf(tempstr,maxtextlength-2,"%s\n",proxyinfo);
      write(ircserver, tempstr, strlen(tempstr));
      }
   
   snprintf(tempstr,maxtextlength-2,"NICK %s",user_nick);
   writeserver2(tempstr,1);
   snprintf(tempstr,maxtextlength-2,"USER %s 32 . :%s",loginname,user_realname);
   writeserver2(tempstr,1);
   if (user_modes && strlen(user_modes)) {
      snprintf(tempstr,maxtextlength-2,"MODE %s %s",user_nick,user_modes);
      writeserver2(tempstr,1);
      }
   
   for (i=0; i<MAXCHNLS; i++)
      if (channel[i]) {
         snprintf(tempstr,maxtextlength-2,"JOIN %s",channel[i]);
         writeserver2(tempstr,1);
         onchan[i] = 0;
         }
   
   recentsent = 0;
   
   mydelete(tempstr);
   
   }

void writeserver2 (char *msg, int send) {
   int i, found;
   found = 0;
   
   if ( ( send || ! SND_FPROT ) && serverstatus == 'C') {
      if (debug)
         ioutput2(0,OUT_S,"0;35","<SND<: ",msg);
      strcat(msg, "\n");
      write(ircserver, msg, strlen(msg));
      }
   else if (exiting)
     return;
   else {
      if (debug)
         ioutput2(0,OUT_S,"0;35","<QUE<: ",msg);
      found=0;
      for (i=0; (!found && i<MAXSENDQ); i++)
         if (serverq[i] == NULL) {
            found=1;
            serverq[i] = mycalloc(strlen(msg)+2,"writeserver2");
            strcpy(serverq[i],msg);
            }
      if (!found) {
         if (!attop) gototop();
         outerror(2,"Server Queue Is Full!! Are We Being Flooded??");
         }
      }
   }

void sendserver() {
   int i,j,count,curnum,howmany,temp1,sendmsg;
   char *tempstr;
   
   sendmsg = curtime%3;
   curnum = curtime%30;
   
   if (serverq[0] == NULL && exiting && !recentsent) {
      FD_CLR(ircserver, &readset);
      close(ircserver);
      serverstatus = 'N';
      ioutput3(0,OUT_S|OUT_D,NULL,"Connection to ",curserverip," Closed");
      return;
      }
   
   if (serverq[0] == NULL || serverstatus != 'C') {
      serversent[curnum] = 0;
      return;
      }
   
   temp1 = 0;
   for (i=1; i<30; i++)
      temp1 += serversent[getend(30,curnum-i)];
   
   if (temp1 > 15) howmany = 0;
   else if (temp1 > 10) howmany = 1;
   else if (temp1 >  7) howmany = 2;
   else if (temp1 >  5) howmany = 3;
   else howmany = 4;
   
   count=0;
   for (i=0; i<howmany; i++)
      if (serverq[0] != NULL) {
         if (!attop) gototop();
         if (debug)
            ioutput2(0,OUT_S,"0;35","<IRC<: ",serverq[0]);
         strcat(serverq[0], "\n");
         write(ircserver, serverq[0], strlen(serverq[0]));
         
         mydelete(serverq[0]);
         for (j=1; j<MAXSENDQ && serverq[j]; j++)
            serverq[j-1] = serverq[j];
         serverq[j-1] = NULL;
         
         if (j>srvqnotify && !sendmsg) {
            tempstr = mycalloc(maxtextlength,"sendserver");
            snprintf(tempstr,maxtextlength-2,"Server Queue Is Getting Big (%i Lines)",j);
            outerror(2,tempstr);
            mydelete(tempstr);
            }
         count++;
         if (serverq[0] == NULL)
            recentsent = 6;
         else
            recentsent = 0;
         }

   serversent[curnum] = count;
   }

void getxdccconfig(char *filename) {
   char *templine1 = mycalloc(maxtextlength,"getxdccconfig_templine1");
   char *templine2 = mycalloc(maxtextlength,"getxdccconfig_templine2");
   char *templine3 = mycalloc(maxtextlength,"getxdccconfig_templine3");
   char *templine4 = mycalloc(maxtextlength,"getxdccconfig_templine4");
   char *templine5 = mycalloc(maxtextlength,"getxdccconfig_templine5");
   char *msg;
   int ok,i,count,hasspaces;
   long c1,c2;
   int filedescriptor,xfiledescriptor;
   
   highmeminfo = 1;
   
   printf("*** Loading %s ... \n",filename);
   
   filedescriptor=open(filename, O_RDONLY | O_CREAT, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0)
      outerror3(0,"Couldn't Open/Create the xdcc File\"",filename,"\"");
   
   if (getfline(templine1,filedescriptor,0) != NULL) {            
      ok=0;
      
      msg = getpart(templine1,6,"getxdccconfig");
      if (msg) {
         record=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
         
      msg = getpart(templine1,7,"getxdccconfig");
      if (msg) {
         sentrecord=atof(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      c1 = 0;
      msg = getpart(templine1,8,"getxdccconfig");
      if (msg) {
         c1=atol(msg);
         mydelete(msg);
         }
      else
         ok++;
      
      c2 = (long)   (((int)record) +   ((int)sentrecord) - 2*((int)record)*((int)record) - 2*((int)sentrecord)*((int)sentrecord)
                   + 3*((int)record) + 3*((int)sentrecord)*((int)sentrecord) - 4*((int)record) - 4*((int)sentrecord)
                   + 5*((int)record)*((int)record) + 5*((int)sentrecord) +13);
      c2 = c2%500;
         
      if (((int)record)+((int)sentrecord) == 0)
         c2 = 0;
      
      if (c1 != c2)
         ok++;
      
      if (ok) {
         outerror(1,"First Line of XDCC File Has Been Changed, Reverting Values to 0");
         record = 0.0;
         sentrecord = 0.0;
         }
      
      }
   else {
      outerror(1,"Empty XDCC File, Starting With No Packs Offered");
      numpacks=0;
   
      slotsfull=0;
      close(filedescriptor);

      mydelete(templine1);
      mydelete(templine2);
      mydelete(templine3);
      mydelete(templine4);
      mydelete(templine5);
      return;
      }

   ok=0;
   count=0;
   
   while (getfline(templine1,filedescriptor,1) != NULL) {
   
      if (getfline(templine1,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine2,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine3,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine4,filedescriptor,0) == NULL)  ok++;
      if (getfline(templine5,filedescriptor,0) == NULL)  ok++;
      
      if (ok)
         outerror(0,"XDCC file syntax error (missing/extra line)");
      
      for (i=strlen(templine1)-1; i>2 && templine1[i] == ' '; i--)
         templine1[i] = '\0';
      for (i=strlen(templine2)-1; i>2 && templine2[i] == ' '; i--)
         templine2[i] = '\0';
      for (i=strlen(templine3)-1; i>2 && templine3[i] == ' '; i--)
         templine3[i] = '\0';
      for (i=strlen(templine4)-1; i>2 && templine4[i] == ' '; i--)
         templine4[i] = '\0';
      for (i=strlen(templine5)-1; i>2 && templine5[i] == ' '; i--)
         templine5[i] = '\0';

      if ( templine1[3] != 'f' || templine1[4] != 'i' || templine1[5] != 'l' || templine1[6] != 'e' ) ok++;
      if ( templine2[3] != 'd' || templine2[4] != 'e' || templine2[5] != 's' || templine2[6] != 'c' ) ok++;
      if ( templine3[3] != 'n' || templine3[4] != 'o' || templine3[5] != 't' || templine3[6] != 'e' ) ok++;
      if ( templine4[3] != 'g' || templine4[4] != 'e' || templine4[5] != 't' || templine4[6] != 's' ) ok++;
      if ( templine5[3] != 'm' || templine5[4] != 'i' || templine5[5] != 'n' || templine5[6] != 's' ) ok++;
      
      if (ok)
         outerror(0,"XDCC file syntax error (incorrect order?)");
      
      for (i=8; i<sstrlen(templine1); i++)
         templine1[i-8] = templine1[i];
      templine1[i-8]='\0';
      for (i=8; i<sstrlen(templine2); i++)
         templine2[i-8] = templine2[i];
      templine2[i-8]='\0';
      for (i=8; i<sstrlen(templine3); i++)
         templine3[i-8] = templine3[i];
      templine3[i-8]='\0';
      for (i=8; i<sstrlen(templine4); i++)
         templine4[i-8] = templine4[i];
      templine4[i-8]='\0';
      for (i=8; i<sstrlen(templine5); i++)
         templine5[i-8] = templine5[i];
      templine5[i-8]='\0';
      
      xdccs[count] = mycalloc(sizeof(xdcc),"getxdccconfig_xdccs[count]");
      xdccs[count]->offered = 1;
      
      strcpy(xdccs[count]->file,templine1);
      
      hasspaces=0;
      for (i=0; i<sstrlen(xdccs[count]->file); i++)
         if (xdccs[count]->file[i] == ' ') hasspaces++;
      if (hasspaces)
         outerror3(0,"The file \"",xdccs[count]->file,"\" has a space in the filename");

      strcpy(xdccs[count]->desc,templine2);
      
      if ( strlen(templine3) )
         strcpy(xdccs[count]->note,templine3);
      else
         strcpy(xdccs[count]->note,"");
      
      xdccs[count]->gets     = atoi(templine4);
      
      xdccs[count]->minspeed = overallminspeed;
      if ( atoi(templine5) )
         xdccs[count]->minspeed = atoi(templine5);
            
      xfiledescriptor=open(xdccs[count]->file, O_RDONLY);
      if (xfiledescriptor < 0)
         outerror3(0,"The file \"",xdccs[count]->file,"\" Could Not Be Opened Or Read");
      
      xdccs[count]->size = lseek(xfiledescriptor, 0, SEEK_END);
      
      if ( xdccs[count]->size == 0 )
         outerror3(0,"The file \"",xdccs[count]->file,"\" has size of 0 bytes!");
      
      close(xfiledescriptor);
      
      count++;
      }
   
   numpacks=count;
   
   slotsfull=0;
   close(filedescriptor);
   
   highmeminfo=0;
   
   mydelete(templine1);
   mydelete(templine2);
   mydelete(templine3);
   mydelete(templine4);
   mydelete(templine5);

   }

char* getfilename(char* name, char* full) {
   int i,lastslash;
   
   lastslash = -1;
   for (i=0; i<sstrlen(full); i++)
      if (full[i] == '/')
         lastslash=i;
   
   for (i=lastslash+1; i<sstrlen(full); i++)
      name[i-lastslash-1]=full[i];
   name[i-lastslash-1]='\0';
   
   return name;
   }

void pingserver() {
   char *tempstr = mycalloc(maxtextlength,"pingserver");
   snprintf(tempstr,maxtextlength-2,"PING %s",curserverip);
   writeserver2(tempstr, 1);
   mydelete(tempstr);
   }
  
void xdccsave(int autosave) {
   char *tempstr, *tempstr2;
   int i, filedescriptor, p;
   long count;

   if (autosave && noautosave > curtime ) return;
   
   tempstr = mycalloc(maxtextlength,"xdccsave");
   tempstr2 = mycalloc(maxtextlengthshort,"xdccsave");
   
   if (autosave)
      ioutput1(1,OUT_S|OUT_D,NULL,"XDCC Autosave: Backing Up... ");
   else
      ioutput1(1,OUT_S|OUT_D,NULL,"XDCC Save: Backing up... ");
   fflush(stdout);
   snprintf(tempstr,maxtextlength-1,"%s.bkup",xdccfile);
   rename(xdccfile,tempstr);
   fflush(stdout);
   
   ioutput1(2,OUT_S|OUT_D,NULL,"Saving... ");
   fflush(stdout);
   
   filedescriptor=open(xdccfile, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0) outerror(0,"Permission Denied");
   
   count = (long)   ((int)record) +   ((int)sentrecord) - 2*((int)record)*((int)record) - 2*((int)sentrecord)*((int)sentrecord)
                + 3*((int)record) + 3*((int)sentrecord)*((int)sentrecord) - 4*((int)record) - 4*((int)sentrecord)
                + 5*((int)record)*((int)record) + 5*((int)sentrecord) +13;
   
   count = count%500;
   
   if (((int)record)+((int)sentrecord) == 0)
      count = 0;

   snprintf(tempstr,(maxtextlength*2)-2,"Do Not Edit This File: %1.2f %1.2f %li\n",record,sentrecord,count);
   write(filedescriptor,tempstr,strlen(tempstr));
   
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while ( p<(MAXXDCCS-1) && (xdccs[p] == NULL || xdccs[p]->offered == 0))
         p++;
      
      if ( xdccs[p]->minspeed && overallminspeed != xdccs[p]->minspeed)
         snprintf(tempstr,maxtextlength-2,"\n"
              "%02i_file %s\n" "%02i_desc %s\n"
              "%02i_note %s\n" "%02i_gets %i\n" "%02i_mins %i\n",
              i,xdccs[p]->file, i,xdccs[p]->desc,
              i,xdccs[p]->note, i,xdccs[p]->gets,
              i,xdccs[p]->minspeed );
      else
         snprintf(tempstr,maxtextlength-2,"\n"
              "%02i_file %s\n" "%02i_desc %s\n"
              "%02i_note %s\n" "%02i_gets %i\n" "%02i_mins \n",
              i,xdccs[p]->file, i,xdccs[p]->desc,
              i,xdccs[p]->note, i,xdccs[p]->gets,i );
      
      write(filedescriptor,tempstr,strlen(tempstr));
      }
   close(filedescriptor);
   ioutput1(3,OUT_S|OUT_D,NULL,"Done");
   fflush(stdout);
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void writepidfile (char *filename) {
   char *tempstr2 = mycalloc(maxtextlengthshort,"writepidfile");
   int filedescriptor;
   
   ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Writing pid file...");
   
   filedescriptor=open(filename, O_WRONLY | O_TRUNC | O_CREAT, S_IRUSR | S_IWUSR);
   if (filedescriptor < 0) outerror(0,"PID File: Permission Denied");
   
   snprintf(tempstr2,maxtextlengthshort,"%i",getpid());
   write(filedescriptor,tempstr2,strlen(tempstr2));
   write(filedescriptor,"\n",1);
   
   close(filedescriptor);
   
   mydelete(tempstr2);
   }

char* getfline(char* str, int descr, int ret) {
   char tempc[2];
   int j;
   
   j = 0;
   strcpy(str,"");
   while(read(descr,&tempc,1) == 1) {
      if (tempc[0] == '\n' || tempc[0] == 13) { /* 13 is ^M */
         str[j] = '\0';
         j = 0;
         if (strlen(str) != 0 ) return str;
         else if ( ret )        return str;
         else                   return NULL;
         }
      else {
         str[j] = tempc[0];
         j++;
         }
      }
   return NULL;
   }

void gobackground() {
   int s,i;
   printf("\n*** Entering Background Mode\n"
          "*** All Commands must be issued by remote administration\n");
   fflush(stdout);
   fflush(stderr);
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(0,"Unable to Fork");
   else if (s > 0) {
      /* parent exits */
      exit(0);
      }

/*   struct rlimit r = { 0 }; */
/*   r.rlim_max = 0; */
/*   s = getrlimit(RLIMIT_NOFILE, &r); */
/*   if ( r.rlim_max < 1 || s < 0) */
/*      outerror(0,"Couldn't get rlimit"); */
   
   for (i=0; i< 4; i++) close(i);
/*   for (i=0; i< r.rlim_max; i++) close(i); */
   
   s = setsid();
   if (s < 0)
      outerror(0,"Couldn't setsid");
   
   /* parent forks */
   s = fork();
   if (s < 0)
      outerror(0,"Unable to Fork");
   else if (s > 0)
      /* parent exits */
      exit(0);
   
   
   /* background continues... */
   
/*   umask(0); */
   s = open("/dev/null", O_RDWR); /* stdin */
   dup(s);                        /* stdout */
   dup(s);                        /* stderr */
   
   log1(0,"Entered Background Mode");
   background = 2;
   
/*   execlp(program,"iroffer","--background-mode--",config,NULL); */
/*   exit(0); */
   
   }

void gotserverswitch (int sig) {
   sig = sig; /* -Wall complains its unused */
   signal(SIGUSR1,gotserverswitch);
   ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Caught SIGUSR1, Switching Servers");
   serverstatus='S';
   }

void gothup (int sig) {
   sig = sig; /* -Wall complains its unused */
   signal(SIGHUP,gothup);
   ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Caught SIGHUP, SIGHUP no longer used, read README");
   }

void gotsigrehash (int sig) {
   sig = sig; /* -Wall complains its unused */
   signal(SIGUSR2,gotsigrehash);
   needsrehash = 1;
   }

void gotalarm (int sig) {
   sig = sig; /* -Wall complains its unused */
   signal(SIGALRM,gotalarm);
   }

char* getuptime(char *str, int type) {
   int days, hours, mins;
   long temp;
   
   temp  = (curtime-startuptime)/60;
   days  = temp/60/24;
   hours = temp/60 - (24*days);
   mins  = temp - (60*hours) - (24*60*days);
   
   if (type)
      snprintf(str,maxtextlengthshort-2,"%dD %dH %dM",days,hours,mins);
   else
      snprintf(str,maxtextlengthshort-2,"%d Days %d Hrs and %d Min",days,hours,mins);
      
   return str;
   }


void parsestdin() {
   int length;
   char* tempbuff1 = mycalloc(maxtextlength,"parsestdin");
   userinput ui;
   
   length = read (0, tempbuff1, maxtextlength-1);
   tempbuff1[length] = '\0';
   
   if (!attop) gototop();
   needsclear = strlen(tempbuff1);
   
   u_fillwith_stdin(&ui,tempbuff1);
   u_parseit(&ui);
   
   mydelete(tempbuff1);
   }

void shutdowniroffer(int sig) {
   int i;
   char *tempstr2;
   char *tempstr = mycalloc(maxtextlength,"shutdowniroffer");
   
   if (!attop) gototop();
   signal(SIGINT,shutdowniroffer);
   signal(SIGTERM,shutdowniroffer);
   
   if (exiting || serverstatus != 'C') {
      if (exiting)
         ioutput1(0,OUT_S,NULL,"Shutting Down (FORCED)");
      else
         ioutput1(0,OUT_S,NULL,"Shutting Down");
      
      if (sig)
         log1(0,"iroffer exited (shutdown/SIGTERM/SIGINT)\n\n");
      else
         log1(0,"iroffer exited (shutdown)\n\n");

      if (!background) printf("[r[%i;1H\n",termlines);
      if (pidfile) unlink(pidfile);
      exit(0);
      }
   
   
   ioutput1(0,OUT_S,NULL,"Shutting Down... (Issue \"SHUTDOWN\" again to force quit)");
   
   if ( SAVEQUIT )
      xdccsave(0);
   
   /* empty queue */
   for (i=0; i<MAXSENDQ; i++)
      serverq[i] = NULL;
   
   /* close connections */
   for (i=0; i<MAXTRANS; i++)
      if (trans[i] != NULL) {
         snprintf(tempstr,maxtextlength-2,
           "NOTICE %s :*** Shutting Down. Closing Connection. (Resume Supported)",trans[i]->nick);
         writeserver(tempstr);
      
         FD_CLR(trans[i]->clientsocket, &writeset);
         FD_CLR(trans[i]->clientsocket, &readset);
         if (trans[i]->listensocket != 1000)
            close(trans[i]->listensocket);
         if (trans[i]->clientsocket != 1000)
            close(trans[i]->clientsocket);
         if (trans[i]->filedescriptor != 1000)
            close(trans[i]->filedescriptor);
         trans[i]->status='D';
         trans[i]->xpack->gets++;
         
         ioutput3(0,OUT_S|OUT_D,"0;33","XDCC Transfer to ",trans[i]->nick," Closed");
         }
   
   /* quit */
   tempstr2 = mycalloc(maxtextlengthshort,"shutdowniroffer");
   tempstr2 = getuptime(tempstr2,1);
   snprintf(tempstr,maxtextlength-2,"QUIT :iroffer v" VERSION " By PMG - %s - running %s",osstring,tempstr2);
   mydelete(tempstr2);
   if (serverstatus == 'C')
      writeserver(tempstr);
   
   exiting = 1;
   
   ioutput1(0,OUT_S|OUT_D,NULL,"Waiting for Server Queue To Flush...");
   
   write(dccchat,"Shutdown Recieved, Closing DCC Chat\n",36);
   FD_CLR(dccchat, &readset);
   close(dccchat);
   dccchat = 1000;
   highestsock();

   mydelete(tempstr);
   }

void switchserver() {
   char *tempstr = mycalloc(maxtextlength,"switchserver");
   int i, snum;
   float j;
   
   /* quit */
   if (serverstatus == 'C') {
      strcpy(tempstr, "QUIT :Changing Servers");
      writeserver2(tempstr,1);
      ioutput1(0,OUT_S|OUT_L|OUT_D,"0;31","Changing Servers");
   
      FD_CLR(ircserver, &readset);
      close(ircserver);
      }
   
   serverstatus = 'N';
   
   while (serverstatus == 'N') {
   
      for (i=0; server[i] && i<MAXSRVS; i++);
      j = (float)i;
      
      snum = (int) (j*rand()/(RAND_MAX+0.0));
      
      /* weird problem? */
      if (snum > i || snum < 0)
         outerror(1,"rand() returned out of range value, it broke!?!?");
      while (snum > i || snum < 0) {
         if (snum < 0) snum += i;
         if (snum > i) snum -= i;
         }
      
      if (!connectirc(server[snum]))
         serverstatus = 'T';
      
      }
   
   servertime = 0;
   mydelete(tempstr);
   }

char* getstatusline(char *str) {
   int i,count,srvq;
   
   count = 0;
   for (i=0; i<120; i++)
      count += xdccsent[i];
   
   for (srvq=0; serverq[srvq] && srvq<MAXSENDQ; srvq++);
   
   snprintf(str,maxtextlength-2,"Stat: %i/%i Sls, %i/%i,%i/%i Q, %1.1fK/s Rcd, %i SrQ (Bdw: %iK, %1.1fK/s, %1.1fK/s Rcd)",
      slotsfull,slotsmax,inqueue,queuesize,inslotsmaxqueue,slotsmaxqueue,
      record,srvq,count/1024,((float)count)/120.0/1024.0,sentrecord);
   
   return str;
   
   }

char* getstatuslinenums(char *str) {
   int i,count,gcount,srvq;
   float scount,ocount;
   
   count = 0;
   for (i=0; i<120; i++)
      count += xdccsent[i];
   
   for (srvq=0; serverq[srvq]; srvq++);
   
   gcount = 0;
   scount = ocount = 0;
   for (i=0; i<MAXXDCCS; i++)
      if (xdccs[i] && xdccs[i]->offered) {
         gcount += xdccs[i]->gets;
         ocount += (float)xdccs[i]->size;
         scount += ((float)xdccs[i]->gets)*((float)xdccs[i]->size);
         }
   
   snprintf(str,maxtextlength-2,"stat %i %1.0f %i %1.0f %i %i %i %i %i %i %1.1f %i %i %1.1f %1.1f",
      numpacks,ocount/1024/1024,gcount,scount/1024/1024,
      slotsfull,slotsmax,inqueue,queuesize,inslotsmaxqueue,slotsmaxqueue,
      record,srvq,count/1024,((float)count)/120.0/1024.0,sentrecord);
   
   return str;
   
   }

void sendxdlqueue () {
   int i;
   char *tempstr;
   userinput ui;
   
   if (!(xlistqueue[0])) return;
   
   tempstr = mycalloc(maxtextlength,"sendxdlqueue");
   
   tempstr[0] = '\0';
   strcat(tempstr,xlistqueue[0]);
   for (i=1; i<MAXXLQUE && xlistqueue[i]; i++) {
      strcat(tempstr,",");
      strcat(tempstr,xlistqueue[i]);
      }
   
   ioutput2(0,OUT_S|OUT_D,"0;33","Sending XDCC LIST to: ",tempstr);
   
   u_fillwith_msg(&ui,tempstr,"A A A A A xdl");
   ui.method = 5;
   u_parseit(&ui);
   
   for (i=0; i<MAXXLQUE && xlistqueue[i]; i++)
      mydelete(xlistqueue[i]);
   
   mydelete(tempstr);
   }

int isthisforme (char *dest, char *msg1) {
   if (!msg1 || !dest) { outerror(1,"isthisforme() got NULL value"); return 1; }
   
   
   if (
         !strcmp(msg1,":\1CLIENTINFO") || !strcmp(msg1,":\1CLIENTINFO\1")
      || !strcmp(msg1,":\1PING") || !strcmp(msg1,":\1PING\1") 
      || !strcmp(msg1,":\1VERSION") || !strcmp(msg1,":\1VERSION\1")
      || !strcmp(msg1,":\1UPTIME") || !strcmp(msg1,":\1UPTIME\1") 
      || !strcmp(msg1,":\1STATUS") || !strcmp(msg1,":\1STATUS\1")
      || (!strcmp(caps_nick,dest) && !strcmp(caps(msg1),":\1DCC"))
      || (!strcmp(caps_nick,dest) && !strcmp(caps(msg1),":ADMIN"))
      || (!strcmp(caps_nick,dest) && (!strcmp(caps(msg1),":XDCC") || !strcmp(msg1,":\1XDCC") ))
      || !strcmp(dest,caps_nick)
      ) return 1;
   
   return 0;
   
   }

void initvars() {
   
   bzero(serverq, MAXSENDQ * sizeof(char*) );
   bzero(inamnt, 10 * sizeof(int) );
   bzero(xdccsent, 120 * sizeof(unsigned long) );
   bzero(onchan, 50 * sizeof(int) );
   bzero(adminhost, MAXAHOST * sizeof(regex_t) );
   bzero(xlistqueue, MAXXLQUE * sizeof(char *) );
   
   bzero(meminfo, MAXMEMINFO * sizeof(meminfo_t) );
   
   
   ignore = 0;
   servertime = 0;
   serverstatus = 'N';
   record = 0.0;
   nocon = 0;
   slotsmaxpack = 0;
   slotsmaxslots = 0;
   sentrecord = 0.0;
   exiting = 0;
   slotsmaxqueue = 0;
   inslotsmaxqueue = 0;
   queuesize = 0;
   inqueue = 0;
   termcols = 0;
   termlines = 0;
   lowbdwth = 0;
   dccchat = 1000;
   dccchatlisten = 1000;
   logstats = 1;
   logrotate = 0;
   firewall = 0;
   dccrangestart = 4000;
   overallminspeed = 0;
   noautosave = 0;
   nonewcons = 0;
   nolisting = 0;
   overallmaxspeed = overallmaxspeeddayspeed = 0;
   overallmaxspeeddaytimestart = overallmaxspeeddaytimeend = 0;
   overallmaxspeeddaydays = 0x7F; /* all days */
   maxb = 0;
   maxtransfersperperson = 1;
   virthost = 0;
   autosend = 0;
   plist = 0;
   plisttime = 0;
   plistlimit = 100;
   debug = 0;
   debug2 = 0;
   plistminimal = 0;
   delayedshutdown = needsrehash = 0;
   highmeminfo = 1;
   usenatip = 0;
   messagefile = filedir = NULL;
   
   termcols = 80;
   termlines = 24;
   
   startuptime = curtime = time(NULL);
   
   }
   
void startupiroffer(char *argv[]) {
   char *tempstr23, *tempstr;
   struct passwd *p;
   
   srand((unsigned int)(getpid()*65000));
   
   if (!background) {
      initscreen();
      gotobot();
      gototop();
      }
   
   printf("\n");
   if (!background) printf("[1;33m");
   printf("Welcome to iroffer by PMG\nVersion " VERSION " [" VERSIONDATE "]\n");
   if ( ! RELEASE )
      printf("\n                *** PRE-RELEASE VERSION - DO NOT DISTRIBUTE ***");
   printf("\n       *** Visit the iroffer web site http://centerclick.org/iroffer/ ***"
          "\n       *** Have you joined the iroffer mailing list? see the web site ***");
   if (!background) printf("[0m");
   printf("\n\n");
   
   /* signal handling */
   signal(SIGPIPE,SIG_IGN);
   signal(SIGALRM,gotalarm);
   signal(SIGHUP,gothup);
   
   signal(SIGTERM,shutdowniroffer);
   signal(SIGINT, shutdowniroffer);
   
   signal(SIGUSR1,gotserverswitch);
   signal(SIGUSR2,gotsigrehash);

   printf("*** iroffer is distributed under the GNU General Public License.\n"
          "***    please see the README for more information.\n");

   printf("\n*** Starting up...\n");
   
   if (!background)
      printf("*** Window Size: %ix%i\n",termcols,termlines);
   
   tempstr23 = mycalloc(maxtextlength,"startupiroffer_temp");
   printf("*** Started on: %s\n",getdatestr(tempstr23,0));
   mydelete(tempstr23);
   
   loginname = mycalloc(maxtextlengthshort,"startupiroffer_loginname");
   p = getpwuid(getuid());
   if (p == NULL || p->pw_name == NULL) {
      outerror(1,"Couldn't Get username, specify loginname in config file");
      strcpy(loginname,"UNKNOWN");
      }
   else
      strcpy(loginname,p->pw_name);
   
   if (background) 
      configfile = argv[2];
   else 
      configfile = argv[1];
   
   getconfig(configfile);
   
   if (RELEASE) log5(0,"iroffer started v",VERSION," [",VERSIONDATE,"]");
   else log5(0,"iroffer started v",VERSION," [",VERSIONDATE,"] *PRERELEASE*");

   getxdccconfig(xdccfile);
   
   getos();
   
   if ( time(NULL) > VERSIONDATEUTC + 60*24*60*60 )
      printf("\n*** NOTICE: This version is over 60 days old. ***\n"
               "***         Please check for a newer version. ***\n\n");

   if (messagefile) {
      tempstr = mycalloc(maxtextlength,"startupiroffer_temp");
      msglog_howmany(tempstr);
      printf("%s\n",tempstr);
      mydelete(tempstr);
      }

   /* fork to background if in background mode */
   if (background) gobackground();
   
   if (pidfile)
      writepidfile(pidfile);
   
   serverstatus = 'N';
   switchserver();
   
   
#if !defined _IROFFER_NOPLUGINS
   plugin_initialize();
#endif
   
   }


void isrotatelog() {
   time_t now, then;
   struct tm *lnow = NULL, *lthen = NULL;
   char *newname;
   
   time(&now);
   lnow = localtime(&now);
   
   if (lnow == NULL || lnow->tm_hour != 0)
      return;
   
   newname = mycalloc(maxtextlength-2,"isrotatelog");
   if (logrotate == 1) {
      then = now - 60*60*24;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-%02i-%02i",
         logfile,lthen->tm_year+1900,lthen->tm_mon+1,lthen->tm_mday);
      log1(0,"Rotating Log");
      rename(logfile,newname);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (daily) to ",newname);
      }
   if (logrotate == 2 && lnow->tm_wday == 0) {
      then = now - 60*60*24*7;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-w%02i",
         logfile,lthen->tm_year+1900,lthen->tm_yday/7);
      log1(0,"Rotating Log");
      rename(logfile,newname);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (weekly) to ",newname);
      }
   if (logrotate == 3 && lnow->tm_mday == 1) {
      then = now - 60*60*24*2;
      lthen = localtime(&then);
      snprintf(newname,maxtextlength-1,"%s.%04i-%02i",
         logfile,lthen->tm_year+1900,lthen->tm_mon+1);
      log1(0,"Rotating Log");
      rename(logfile,newname);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Logfile moved (monthly) to ",newname);
      }
   
   
   mydelete(newname);
   }






