/*
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is
 * available in the README file.
 * 
 */

/* include the headers */
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* userinput class for iroffer (.cpp) */

void u_fillwith_stdin (userinput *u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_stdin");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_stdin");
   int i;
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = 1;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_stdin"));
   u->arg1 = getpart(line,2,"u_fillwith_stdin");
   u->arg2 = getpart(line,3,"u_fillwith_stdin");
   u->arg3 = getpart(line,4,"u_fillwith_stdin");
   
   strcpy(tempstr1,"");
   if (u->arg1) {
      strcpy(tempstr1,line);
      for (i=strlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strcpy(tempstr2,"");
   if (u->arg1 && u->arg2) {
      strcpy(tempstr2,line);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_dcc (userinput *u, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_dcc");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_dcc");
   int i;
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = 2;
   u->snick = NULL;

   u->cmd = caps(getpart(line,1,"u_fillwith_dcc"));
   u->arg1 = getpart(line,2,"u_fillwith_dcc");
   u->arg2 = getpart(line,3,"u_fillwith_dcc");
   u->arg3 = getpart(line,4,"u_fillwith_dcc");
   
   strcpy(tempstr1,"");
   if (u->arg1) {
      strcpy(tempstr1,line);
      for (i=sstrlen(u->cmd)+1; i<=sstrlen(line); i++)
         tempstr1[i-strlen(u->cmd)-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strcpy(tempstr2,"");
   if (u->arg1 && u->arg2) {
      strcpy(tempstr2,line);
      for (i=sstrlen(u->cmd)+sstrlen(u->arg1)+2; i<=sstrlen(line); i++)
         tempstr2[i-strlen(u->cmd)-strlen(u->arg1)-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   }

void u_fillwith_msg (userinput *u, char* n, char *line) {
   char* tempstr1 = mycalloc(maxtextlength,"u_fillwith_msg");
   char* tempstr2 = mycalloc(maxtextlength,"u_fillwith_msg");
   char *t1,*t2,*t3,*t4,*t5;
   int i,len;
   
   if (line[strlen(line)-1] == '\n') line[strlen(line)-1] = '\0';
   
   u->method = 3;
   u->snick = n;
   t1 = getpart(line,1,"u_fillwith_msg"); t2 = getpart(line,2,"u_fillwith_msg");
   t3 = getpart(line,3,"u_fillwith_msg"); t4 = getpart(line,4,"u_fillwith_msg");
   t5 = getpart(line,5,"u_fillwith_msg");
   
   u->cmd = caps(getpart(line,6,"u_fillwith_msg"));
   u->arg1 = getpart(line,7,"u_fillwith_msg");
   u->arg2 = getpart(line,8,"u_fillwith_msg");
   u->arg3 = getpart(line,9,"u_fillwith_msg");
   
   len = strlen(t1) + strlen(t2) + strlen(t3) + strlen(t4) + strlen(t5) +5;
   if (u->cmd) len += strlen(u->cmd);
   
   strcpy(tempstr1,"");
   if (u->arg1) {
      strcpy(tempstr1,line);
      for (i=len+1; i<=sstrlen(line); i++)
         tempstr1[i-len-1] = tempstr1[i];
      }
   u->arg1e = tempstr1;
   
   strcpy(tempstr2,"");
   if (u->arg1 && u->arg2) {
      len += strlen(u->arg1);
      strcpy(tempstr2,line);
      for (i=len+2; i<=sstrlen(line); i++)
         tempstr2[i-len-2] = tempstr2[i];
      }
   u->arg2e = tempstr2;
   
   mydelete(t1);
   mydelete(t2);
   mydelete(t3);
   mydelete(t4);
   mydelete(t5);
   }

void u_fillwith_clean (userinput *u) {
 /*  mydelete(u->snick); */
   mydelete(u->cmd);
   mydelete(u->arg1e);
   mydelete(u->arg2e);
   mydelete(u->arg1);
   mydelete(u->arg2);
   mydelete(u->arg3);
   }

void u_respond(userinput *u, char *a) {
   
   if (u->method == 1)
      ioutput1(0,OUT_S,NULL,a);
   if (u->method == 2)
      ioutput1(0,OUT_D,NULL,a);
   if (u->method == 3)
      privmsg1(u->snick,a);
   if (u->method == 4)
      privmsg1(u->snick,a);
   if (u->method == 5)
      notice1(u->snick,a);
   if (u->method == 6)
      ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,a);
   
   
   }

void u_parseit(userinput *u) {
   int notfound = 0;
   
   if (!u->cmd || !strlen(u->cmd)) {
      u_respond(u,"*** User Command Not Recognized, try \"HELP\"");
      notfound = 1;
      }
   else if (strcmppart(u->cmd, "HELP"))
      u_help(u);
   else if (strcmppart(u->cmd, "XDL"))
      u_xdl(u);
   else if (strcmppart(u->cmd, "XDS"))
      xdccsave(0);
   else if (strcmppart(u->cmd, "DCLD"))
      u_dcld(u);
   else if (strcmppart(u->cmd, "DCL"))
      u_dcl(u);
   else if (strcmppart(u->cmd, "QUL"))
      u_qul(u);
   else if (strcmppart(u->cmd, "CLOSE"))
      u_close(u);
   else if (strcmppart(u->cmd, "NOMIN"))
      u_nomin(u);
   else if (strcmppart(u->cmd, "RMQ"))
      u_rmq_rpq(u);
   else if (strcmppart(u->cmd, "RPQ"))
      u_rmq_rpq(u);
   else if (strcmppart(u->cmd, "RAW"))
      writeserver(u->arg1e);
   else if (strcmppart(u->cmd, "INFO"))
      u_info(u);
   else if (strcmppart(u->cmd, "REMOVE"))
      u_remove(u);
   else if (strcmppart(u->cmd, "SEND"))
      u_send(u);
   else if (strcmppart(u->cmd, "PSEND"))
      u_psend(u);
   else if (strcmppart(u->cmd, "MESG"))
      u_mesg(u);
   else if (strcmppart(u->cmd, "MESQ"))
      u_mesq(u);
   else if (u->method==1 && strcmppart(u->cmd, "RESET")) {
      initscreen();
      gotobot();
      }
   else if (u->method==2 && strcmppart(u->cmd, "QUIT"))
      u_closedcc();
   else if (u->method==1 && strcmppart(u->cmd, "QUIT"))
      shutdowniroffer(0);
   else if (strcmppart(u->cmd, "SHUTDOWN"))
      shutdowniroffer(0);
   else if (strcmppart(u->cmd, "DSHUTDOWN"))
      u_delayedshutdown(u);
   else if (strcmppart(u->cmd, "SERVER"))
      switchserver();
   else if (strcmppart(u->cmd, "STATUS"))
      u_status(u);
   else if (strcmppart(u->cmd, "CHFILE"))
      u_chfile(u);
   else if (strcmppart(u->cmd, "CHDESC"))
      u_chdesc(u);
   else if (strcmppart(u->cmd, "CHNOTE"))
      u_chnote(u);
   else if (strcmppart(u->cmd, "CHMINS"))
      u_chmins(u);
   else if (strcmppart(u->cmd, "ADD"))
      u_add(u);
   else if (u->method==3 && strcmppart(u->cmd, "CHATME"))
      u_chatme(u);
   else if (strcmppart(u->cmd, "REHASH"))
      u_rehash(u);
   else if (strcmppart(u->cmd, "BOTINFO"))
      u_botinfo(u);
   else if (strcmppart(u->cmd, "IGNL"))
      u_ignl(u);
   else if (strcmppart(u->cmd, "IGNORE"))
      u_ignore(u);
   else if (strcmppart(u->cmd, "NOSAVE"))
      u_nosave(u);
   else if (strcmppart(u->cmd, "NOSEND"))
      u_nosend(u);
   else if (strcmppart(u->cmd, "NOLIST"))
      u_nolist(u);
   else if (strcmppart(u->cmd, "RENUMBER"))
      u_renumber(u);
   else if (strcmppart(u->cmd, "MSGREAD"))
      u_msgread(u);
   else if (strcmppart(u->cmd, "MSGDEL"))
      u_msgdel(u);
   else if (strcmppart(u->cmd, "MEMSTAT"))
      u_memstat(u);
   else if (u->method==1 && u->arg1 && strcmppart(u->cmd, "DEBUG")) {
      if (u->arg1[0] == '2') {
         debug = 1;
         debug2 = 0;
         }
      else if (u->arg1[0] == '1') {
         debug = 1;
         debug2 = 1;
         }
      else if (u->arg1[0] == '0') {
         debug = 0;
         debug2 = 0;
         }
      }
   else {
      u_respond(u,"*** User Command Not Recognized, try \"HELP\"");
      notfound = 1;
      }
   
   if (!notfound && u->method==1)
      ioutput3(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN ",u->cmd," Requested (stdin)");
   if (!notfound && u->method==2)
      ioutput3(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN ",u->cmd," Requested (DCC Chat)");
   if (!notfound && u->method==3)
      ioutput5(0,OUT_S|OUT_L|OUT_D,"0;35","ADMIN ",u->cmd," Requested (MSG: ",u->snick,")");
   
   u_fillwith_clean(u);
   
   }

void u_help(userinput *u) {
   if (u->method==1) u_respond(u,"-- User Commands (stdin) --");
   if (u->method==2) u_respond(u,"-- User Commands (dcc) --");
   if (u->method==3) u_respond(u,"-- User Commands (msg) --");
   u_respond(u,"   XDL             - Lists Offered Files");
   u_respond(u,"   DCL             - Lists Current Transfers");
   u_respond(u,"   DCLD            - Lists Current Transfers with Details");
   u_respond(u,"   QUL             - Lists Current Queue");
   u_respond(u,"   XDS             - Save XDCC File");
   u_respond(u,"   MSGREAD         - Show MSG log");
   u_respond(u,"   MSGDEL          - Delete all saved MSGs");
   u_respond(u," ");
   u_respond(u,"   CLOSE n         - Cancels Transfer with ID = n");
   u_respond(u,"   NOMIN n         - Disables Minspeed For Transfer ID n");
   u_respond(u,"   RMQ n           - Removes Main Queue Number n");
   u_respond(u,"   RPQ n           - Removes Pack Queue Number n");
   u_respond(u,"   SEND nick n     - Sends Pack n to nick");
   u_respond(u,"   PSEND channel   - Sends XDCC LIST to a channel");
   u_respond(u,"   NOSAVE n        - Disables XDCC AutoSave for next n minutes");
   u_respond(u,"   NOSEND n        - Disables XDCC Send for next n minutes");
   u_respond(u,"   NOLIST n        - Disables XDCC List and Plist for next n mins");
   u_respond(u," ");
   u_respond(u,"   INFO n          - Show Info for Pack n");
   u_respond(u,"   REMOVE n        - Removes Pack n");
   u_respond(u,"   RENUMBER x y    - Moves Pack x to y");
   u_respond(u,"   ADD <filename>  - Add New Pack With <filename>");
   u_respond(u,"   CHFILE n <msg>  - Change File of pack n to <msg>");
   u_respond(u,"   CHDESC n <msg>  - Change Description of pack n to <msg>");
   u_respond(u,"   CHNOTE n <msg>  - Change Note of pack n to <msg>");
   u_respond(u,"   CHMINS n x      - Change min speed of pack n to x KB");
   u_respond(u," ");
   u_respond(u,"   IGNL            - List Auto-Ignored People");
   u_respond(u,"   IGNORE n <host> - Ignored host (hostname) for n minutes");
   u_respond(u,"   RAW <command>   - Send <command> to server (RAW IRC)");
   u_respond(u,"   MESG <message>  - Message's all users who are transferring");
   u_respond(u,"   MESQ <message>  - Message's all users who are in a queue");
   u_respond(u,"   SERVER          - Switches to another server");
   u_respond(u,"   STATUS          - Show Useful Information");
   u_respond(u,"   BOTINFO         - Show Information about the bot status");
   u_respond(u,"   MEMSTAT         - Show Information about memory usage");
   u_respond(u,"   REHASH          - Re-Reads config file and reconfigures");
   if (u->method==1) u_respond(u,"   RESET           - Resets the Screen (Use if it gets funky)");
   if (u->method==1) u_respond(u,"   DEBUG n         - Set Debugging to n [1 or 0]");
   if (u->method==3) u_respond(u,"   CHATME          - Sends you a DCC Chat Request");
   if (u->method==2) u_respond(u,"   QUIT            - Close DCC Chat");
   if (u->method==1) u_respond(u,"   QUIT            - Shutdown iroffer");
   u_respond(u,"   SHUTDOWN        - Shutdown iroffer now");
   u_respond(u,"   DSHUTDOWN <act> - Shutdown iroffer once no transfers exist");
   u_respond(u,"-- End of Commands --");
   }

void u_xdl(userinput *u) {
   char *tempstr,*tempstr2,*tempstr3;
   char *spaces[] = { ""," ","  ","   ","    ","     ","      " };
   int a,i,p,m,s;
   
   if ((u->method == 4) && (nolisting > curtime)) return;
   
   tempstr = mycalloc(maxtextlength,"u_xdl");

   if ((u->method == 5) && (nolisting > curtime)) {
      snprintf(tempstr,maxtextlength-2,
            "The Owner Has Requested That No Lists Be Sent In The Next %li Minute%s",
            1+(nolisting-curtime)/60,((1+(nolisting-curtime)/60)!=1?"s":""));
      u_respond(u,tempstr);
      mydelete(tempstr);
      return;
      }

   tempstr2 = mycalloc(maxtextlength,"u_xdl");
   tempstr3 = mycalloc(maxtextlengthshort,"u_xdl");

   if (u->method==4 && plistminimal) m = 1; else m = 0;
   
   if (slotsmax-slotsfull < 0) a = slotsfull; else a = slotsmax;
   snprintf(tempstr,maxtextlength-2,
       "\2**\2 %i pack%s \2**\2  %i of %i slot%s open",
       numpacks,numpacks!=1?"s":"",a-slotsfull,a,a!=1?"s":"");
   if (slotsmax == slotsfull) {
      snprintf(tempstr2,maxtextlength-2,"%s, Queue: %i/%i",tempstr,inqueue,queuesize);
      strcpy(tempstr,tempstr2);
      }
   if (overallminspeed) {
      snprintf(tempstr2,maxtextlength-2,"%s, Min: %iKB/s",tempstr,overallminspeed);
      strcpy(tempstr,tempstr2);
      }
   if (record > 0.5 && !m) {
      snprintf(tempstr2,maxtextlength-2,"%s, Record: %1.1fKB/s",tempstr,record);
      strcpy(tempstr,tempstr2);
      }
   else if (!m) {
      snprintf(tempstr2,maxtextlength-2,"%s, (No Record Yet)",tempstr);
      strcpy(tempstr,tempstr2);
      }
   u_respond(u,tempstr);
   
   if (!m) {
      for (i=0,a=0; i<120; i++)
         a += xdccsent[i];
      snprintf(tempstr,maxtextlength-2,
          "\2**\2 Bandwidth Usage \2**\2 Current: %1.1fKB/s,",((float)a)/120.0/1024.0);
      if (maxb) {
         snprintf(tempstr2,maxtextlength-2,"%s Cap: %i.0KB/s,",tempstr,maxb/4);
         strcpy(tempstr,tempstr2);
         }
      if (sentrecord > 0.5) {
         snprintf(tempstr2,maxtextlength-2,"%s Record: %1.1fKB/s",tempstr,sentrecord);
         strcpy(tempstr,tempstr2);
         }
      else {
         snprintf(tempstr2,maxtextlength-2,"%s (No Record Yet)",tempstr);
         strcpy(tempstr,tempstr2);
         }
      u_respond(u,tempstr);
   
   
      snprintf(tempstr,maxtextlength-2,
          "\2**\2 To request a file type: \"/msg %s xdcc send #x\"",user_nick);
      u_respond(u,tempstr);
      }
   
   s = 0;
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if (p>(MAXXDCCS-1))
         break;
      if ( u->method==4 && i>plistlimit )
         break;
      s = max2(s,xdccs[p]->gets);
      }
   i = s; s = 5;
   if (i < 10000) s = 4;
   if (i < 1000) s = 3;
   if (i < 100) s = 2;
   if (i < 10) s = 1;
   snprintf(tempstr3,maxtextlengthshort-2,"\2#%%-2i\2 %%%iix [%%s] %%s",s);
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if (p>(MAXXDCCS-1))
         break;
      if ( u->method==4 && i>plistlimit )
         break;
      
      snprintf(tempstr,maxtextlength-2,
         tempstr3,
         i,
         xdccs[p]->gets,
         sizestr(1,tempstr2,xdccs[p]->size),
         xdccs[p]->desc);
      
      if (xdccs[p]->minspeed && xdccs[p]->minspeed != overallminspeed) {
         snprintf(tempstr2,maxtextlength-2,"%s [%iK/sec]",tempstr,xdccs[p]->minspeed);
         strcpy(tempstr,tempstr2);
         }
      u_respond(u,tempstr);
      
      if (xdccs[p]->note && strlen(xdccs[p]->note)) {
         snprintf(tempstr,maxtextlength-2," \2^-\2%s%s",spaces[s],xdccs[p]->note);
         u_respond(u,tempstr);
         }
      
      if (i == slotsmaxpack && inslotsmaxqueue) {
         snprintf(tempstr,maxtextlength-2," \2^-\2%sPack %i Has Slot Queue: %i/%i",
            spaces[s],i,inslotsmaxqueue,slotsmaxqueue);
         u_respond(u,tempstr);
         }
      }
   
   if (u->method==4 && numpacks > plistlimit) {
      snprintf(tempstr,maxtextlength-2,
         "\2**\2 %i Additional Pack%s Offered But Not Shown! \2**\2",
         numpacks-plistlimit,(numpacks-plistlimit)!=1?"s":"");
      u_respond(u,tempstr);
      }
   
   if (creditline) {
      snprintf(tempstr,maxtextlength-2,"\2**\2 %s \2**\2",creditline);
      u_respond(u,tempstr);
      }
   
   if (!m) {
      float toffered = 0;
      float tsnagged = 0;
   
      for (i=0; i<MAXXDCCS; i++)
         if (xdccs[i] && xdccs[i]->offered) {
            toffered += (float)xdccs[i]->size;
            tsnagged += ((float)xdccs[i]->gets)*((float)xdccs[i]->size);
            }
   
      snprintf(tempstr,maxtextlength-2,
         "Total Offered: %1.1f MB  Total Snagged: %1.0f MB",toffered/1024.0/1024.0,tsnagged/1024.0/1024.0);
      u_respond(u,tempstr);
      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   }

void u_dcl(userinput *u) {
   char *tempstr, *tempstr2, *y;
   int i;
   
   if (!slotsfull) {
      u_respond(u,"No Active Transfers");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_dcl");
   tempstr2 = mycalloc(maxtextlength,"u_dcl");

   snprintf(tempstr,maxtextlength-2,"Current Transfer%s",slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u,"   ID  User        File                               Status");
   
   for (i=0; i<MAXTRANS; i++)
      if (trans[i] != NULL) {
         
         if (trans[i]->status == 'L') y = "Listening";
         else if (trans[i]->status == 'W') y = "Finishing";
         else if (trans[i]->status == 'D') y = "Closing";
         else if (trans[i]->status == 'E') y = "Error";
         else if (trans[i]->status == 'S') y = "Sending";
         else y = "Unknown!";
         
         if (trans[i]->status == 'S') {
            snprintf(tempstr,maxtextlength-2,"   %2i  %-9s   %-32s   %s %2.0f%%",
               i,trans[i]->nick,getfilename(tempstr2,trans[i]->xpack->file),y,
               ((float)trans[i]->bytessent)*100.0/((float)trans[i]->xpack->size));
            }
         else
            snprintf(tempstr,maxtextlength-2,"   %2i  %-9s   %-32s   %s",
               i,trans[i]->nick,getfilename(tempstr2,trans[i]->xpack->file),y);
         
         u_respond(u,tempstr);
         
         }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void u_dcld(userinput *u) {
   char *tempstr, *tempstr2, *tempstr3, *y;
   int i,left,started;
   
   if (!slotsfull) {
      u_respond(u,"No Active Transfers");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_dcl");
   tempstr2 = mycalloc(maxtextlength,"u_dcl");
   tempstr3 = mycalloc(maxtextlengthshort,"u_dcl");

   snprintf(tempstr,maxtextlength-2,"Current Transfer%s",slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u," ID  User        File                               Status");
   u_respond(u,"  ^-    Speed    Current/    End    Start/Remain    Min   Resumed");
   u_respond(u," ----------------------------------------------------------------");
   
   for (i=0; i<MAXTRANS; i++)
      if (trans[i] != NULL) {
         
         if (trans[i]->status == 'L') y = "Listening";
         else if (trans[i]->status == 'W') y = "Finishing";
         else if (trans[i]->status == 'D') y = "Closing";
         else if (trans[i]->status == 'E') y = "Error";
         else if (trans[i]->status == 'S') y = "Sending";
         else y = "Unknown!";
         
         if (trans[i]->status == 'S') {
            snprintf(tempstr,maxtextlength-2," %2i  %-9s   %-32s   %s %2.0f%%",
               i,trans[i]->nick,getfilename(tempstr2,trans[i]->xpack->file),y,
               ((float)trans[i]->bytessent)*100.0/((float)trans[i]->xpack->size));
            }
         else
            snprintf(tempstr,maxtextlength-2," %2i  %-9s   %-32s   %s",
               i,trans[i]->nick,getfilename(tempstr2,trans[i]->xpack->file),y);
         
         u_respond(u,tempstr);
         
         if (trans[i]->status == 'S') {
            left = min2(359999,(trans[i]->xpack->size-trans[i]->bytessent)/((int)(max2(trans[i]->lastspeed,0.001)*1024)));
            started = min2(359999,curtime-trans[i]->connecttime);
            snprintf(tempstr2,maxtextlength-2,"%2iK",trans[i]->xpack->minspeed);
            snprintf(tempstr3,maxtextlengthshort-2,"%6liK",(trans[i]->startresume)/1024);
            
            snprintf(tempstr,maxtextlength-2,
                "  ^- %5.1fK/s    %6liK/%6liK   %2i%c%02i%c/%2i%c%02i%c    %3s   %7s",
                trans[i]->lastspeed,
                (trans[i]->bytessent)/1024,
                (trans[i]->xpack->size)/1024,
                started < 3600 ? started/60 : started/60/60 ,
                started < 3600 ? 'm' : 'h',
                started < 3600 ? started%60 : (started/60)%60 ,
                started < 3600 ? 's' : 'm',
                left < 3600 ? left/60 : left/60/60 ,
                left < 3600 ? 'm' : 'h',
                left < 3600 ? left%60 : (left/60)%60 ,
                left < 3600 ? 's' : 'm',
                (trans[i]->nomin || !(trans[i]->xpack->minspeed)) ? "no" : tempstr2 ,
                trans[i]->startresume ? tempstr3 : "no"
                );
            u_respond(u,tempstr);
            }
         }
   
   u_respond(u," ----------------------------------------------------------------");
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   }

void u_qul(userinput *u) {
   char *tempstr, *tempstr2, *tempstr3, *tempstr4;
   int i;
   
   if (!inqueue && !inslotsmaxqueue) {
      u_respond(u,"No Users Queued");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_qul");
   tempstr2 = mycalloc(maxtextlengthshort,"u_qul");
   tempstr3 = mycalloc(maxtextlengthshort,"u_qul");
   tempstr4 = mycalloc(maxtextlengthshort,"u_qul");
   
   u_respond(u,"Current Queue:");
   u_respond(u,"    #Q  User        File                               Waiting");
   
   for (i=1; i<=inqueue; i++) {
      snprintf(tempstr,maxtextlength-2,"   %2iM  %-9s   %-32s   %li Hr %li Min",
         i,
         mainqueue[i-1]->nick,
         getfilename(tempstr2,mainqueue[i-1]->xpack->file),
         (curtime-mainqueue[i-1]->queuedtime)/60/60,
         ((curtime-mainqueue[i-1]->queuedtime)/60)%60);
      u_respond(u,tempstr);
      }
   
   for (i=1; i<=inslotsmaxqueue; i++) {
      snprintf(tempstr,maxtextlength-2,"   %2iP  %-9s   %-32s   %li Hr %li Min",
         i,
         packqueue[i-1]->nick,
         getfilename(tempstr2,packqueue[i-1]->xpack->file),
         (curtime-packqueue[i-1]->queuedtime)/60/60,
         ((curtime-packqueue[i-1]->queuedtime)/60)%60);
      u_respond(u,tempstr);
      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(tempstr3);
   mydelete(tempstr4);
   
   }

void u_close(userinput *u) {
   
   int num = 0;
   if (u->arg1) num = atoi(u->arg1);
   
   if (num > MAXTRANS-1 || num < 0 || trans[num] == NULL)
      u_respond(u,"Invalid ID number, Try \"DCL\" for a list");
   else
      t_closeconn(trans[num],"Owner Requested Close");
   
   }

void u_nomin(userinput *u) {
   
   int num = 0;
   if (u->arg1) num = atoi(u->arg1);
   
   if (num > MAXTRANS-1 || num < 0 || trans[num] == NULL)
      u_respond(u,"Invalid ID number, Try \"DCL\" for a list");
   else
      trans[num]->nomin = 1;
   
   }

void u_rmq_rpq(userinput *u) {
   int i;
   int num = 0;
   if (u->arg1) num = atoi(u->arg1);
   
   if (u->cmd[1] == 'M') {
      if ( (num > MAXQUEUE) || (num < 1) || mainqueue[num-1] == NULL )
         u_respond(u,"Invalid ID number, Try \"QUL\" for a list");
      else {
         notice1(mainqueue[num-1]->nick,"*** Removed From Queue: Owner Requested Remove");
         mydelete(mainqueue[num-1]);
         for (i=num; i<inqueue; i++)
            mainqueue[i-1] = mainqueue[i];
         mainqueue[i] = NULL;
         inqueue--;
         }
      }
   else if (u->cmd[1] == 'P') {
      if ( (num > MAXQUEUE) || (num < 1) || packqueue[num-1] == NULL )
         u_respond(u,"Invalid ID number, Try \"QUL\" for a list");
      else {
         notice1(packqueue[num-1]->nick,"*** Removed From Queue: Owner Requested Remove");
         mydelete(packqueue[num-1]);
         for (i=num; i<inslotsmaxqueue; i++)
            packqueue[i-1] = packqueue[i];
         packqueue[i] = NULL;
         inslotsmaxqueue--;
         }
      }
   else {
      u_respond(u,"internal iroffer error: u_rmq_rpq(): unexpected case, report problem to PMG");
      }
   
   }

void u_info(userinput *u) {
   int num = 0;
   int i,p;
   char *tempstr, *tempstr2;
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_info");
   tempstr2 = mycalloc(maxtextlength,"u_info");
   
   snprintf(tempstr,maxtextlength-2,"Pack Info for Pack #%i:",num);
   u_respond(u,tempstr);
   
   snprintf(tempstr,maxtextlength-2,"Gets: %i, Size: %s (%li), Min: %iK/sec",
                xdccs[p]->gets,
                sizestr(1,tempstr2,xdccs[p]->size),
                xdccs[p]->size,
                xdccs[p]->minspeed);
   u_respond(u,tempstr);
   snprintf(tempstr,maxtextlength-2,"Filename:    %s",xdccs[p]->file);
   u_respond(u,tempstr);
   snprintf(tempstr,maxtextlength-2,"Description: %s",xdccs[p]->desc);
   u_respond(u,tempstr);
   snprintf(tempstr,maxtextlength-2,"Note:        %s",xdccs[p]->note);
   u_respond(u,tempstr);
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void u_remove(userinput *u) {
   int i,p;
   int num = 0;
   char *tempstr;
   if (u->arg1) num = atoi(u->arg1);
   
   if ( num < 1 || num > numpacks ) {
      u_respond(u,"Try a valid pack number");
      return;
      }
/*   if ( numpacks == 1 ) { */
/*      u_respond(u,"You must offer at least one pack"); */
/*      return; */
/*      } */
   
   tempstr = mycalloc(maxtextlength,"u_remove");
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   xdccs[p]->offered = 0;
   numpacks--;
   snprintf(tempstr,maxtextlength-2,"Removed Pack %i [%s]",
      num,xdccs[p]->desc);
   u_respond(u,tempstr);
   xdccsave(0);
   
   mydelete(tempstr);
   }

void u_send(userinput *u) {
   int num = 0;
   char *tempstr;
   if (u->arg2) num = atoi(u->arg2);
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Nick");
      return;
      }
   
   if (num > numpacks || num < 1) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_send");
   
   snprintf(tempstr,maxtextlength-2,"Sending %s pack %i",u->arg1,num);
   u_respond(u,tempstr);
   
   sendxdccfile(u->arg1,"man",num,NULL);
   
   mydelete(tempstr);
   }

void u_psend(userinput *u) {
   char *tempstr;
   userinput manplist;
  
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Channel");
      return;
      }
   
   u_fillwith_msg(&manplist,u->arg1,"A A A A A xdl");
   manplist.method = 4;
   u_parseit(&manplist);
   
   tempstr = mycalloc(maxtextlength,"u_psend");
   snprintf(tempstr,maxtextlength-2,"Sending PLIST to %s",u->arg1);
   mydelete(tempstr);
   
   }

void u_mesg(userinput *u) {
   int i;
   char *tempstr;
   
   if (!u->arg1e || !strlen(u->arg1e)) {
      u_respond(u,"Try Specifying a Message");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_mesg");
   for (i=0; i<MAXTRANS; i++)
      if (trans[i] != NULL) {
      snprintf(tempstr,maxtextlength-2,
         "NOTICE %s :MESSAGE FROM OWNER: %s",trans[i]->nick,u->arg1e);
      writeserver(tempstr);
      }
   snprintf(tempstr,maxtextlength-2,"Sent message to %i user%s",slotsfull,slotsfull!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

void u_mesq(userinput *u) {
   int i,count;
   char *tempstr;
   
   if (!u->arg1e || !strlen(u->arg1e)) {
      u_respond(u,"Try Specifying a Message");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_mesq");

   count=0;
   for (i=1; i<=inqueue; i++) {
      snprintf(tempstr,maxtextlength-2,
         "NOTICE %s :MESSAGE FROM OWNER: %s",mainqueue[i-1]->nick,u->arg1e);
      writeserver(tempstr);
      count++;
      }
   for (i=1; i<=inslotsmaxqueue; i++) {
      snprintf(tempstr,maxtextlength-2,
         "NOTICE %s :MESSAGE FROM OWNER: %s",packqueue[i-1]->nick,u->arg1e);
      writeserver(tempstr);
      count++;
      }
   snprintf(tempstr,maxtextlength-2,"Sent message to %i user%s",count,count!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

void u_closedcc() {
      ioutput1(0,OUT_S|OUT_L,"0;35","DCC CHAT: QUIT");
      writedccchat("Bye.");
      FD_CLR(dccchat, &readset);
      close(dccchat);
      dccchat = 1000;
      highestsock();
   }

void u_status(userinput *u) {
   char *tempstr = mycalloc(maxtextlength,"u_status");
   
   getstatusline(tempstr);
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   }

void u_chfile(userinput *u) {
   int num = 0;
   char *tempstr;
   xdcc *tempx;
   int i,p,xfiledescriptor;
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }

   if (!u->arg2 || !strlen(u->arg2)) {
      u_respond(u,"Try Specifying a Filename");
      return;
      }
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   for (i=0; xdccs[i]; i++) ;
   xdccs[i] = mycalloc(sizeof(xdcc),"u_chfile");
   
   xdccs[i]->offered = 1;
   strcpy(xdccs[i]->file,u->arg2);
   strcpy(xdccs[i]->desc,xdccs[p]->desc);
   if ( strlen(xdccs[p]->note) )
      strcpy(xdccs[i]->note,xdccs[p]->note);
   else
      strcpy(xdccs[i]->note,"");
   
   xdccs[i]->gets = xdccs[p]->gets;
   
   xdccs[i]->minspeed = overallminspeed;
   if ( xdccs[p]->minspeed != overallminspeed )
      xdccs[i]->minspeed = xdccs[p]->minspeed;

   xfiledescriptor=open(xdccs[i]->file, O_RDONLY);
   
   if (xfiledescriptor < 0 && filedir) {
      snprintf(xdccs[i]->file,maxtextlength-2,"%s/%s",filedir,u->arg2);
      xfiledescriptor=open(xdccs[i]->file, O_RDONLY);
      }
   
   if (xfiledescriptor < 0) {
      u_respond(u,"File Could Not Be Opened Or Read");
      mydelete(xdccs[i]);
      return;
      }
   
   xdccs[i]->size = lseek(xfiledescriptor, 0, SEEK_END);
   
   if ( xdccs[i]->size == 0 ) {
      u_respond(u,"File has size of 0 bytes!");
      mydelete(xdccs[i]);
      return;
      }
   
   close(xfiledescriptor);
   xdccs[p]->offered = 0;
   
   
   tempstr = mycalloc(maxtextlength,"u_chfile");
   snprintf(tempstr,maxtextlength-2,
      "CHFILE: [Pack %i] Old: %s New: %s",
      num,xdccs[p]->file,xdccs[i]->file);
   u_respond(u,tempstr);
   mydelete(tempstr);

   tempx = xdccs[i];
   xdccs[i] = xdccs[p];
   xdccs[p] = tempx;
   
   xdccsave(0);
   
   }

void u_add(userinput *u) {
   int i,xfiledescriptor;
   char *tempstr;
   
   if (!u->arg1 || !strlen(u->arg1)) {
      u_respond(u,"Try Specifying a Filename");
      return;
      }
   
   for (i=0; xdccs[i]; i++) ;
   xdccs[i] = mycalloc(sizeof(xdcc),"u_add");
   
   xdccs[i]->offered = 1;
   strcpy(xdccs[i]->file,u->arg1);
   strcpy(xdccs[i]->desc,"no description specified");
   strcpy(xdccs[i]->note,"");
   
   xdccs[i]->gets = 0;
   xdccs[i]->minspeed = overallminspeed;

   xfiledescriptor=open(xdccs[i]->file, O_RDONLY);
   
   if (xfiledescriptor < 0 && filedir) {
      snprintf(xdccs[i]->file,maxtextlength-2,"%s/%s",filedir,u->arg1);
      xfiledescriptor=open(xdccs[i]->file, O_RDONLY);
      }
   
   if (xfiledescriptor < 0) {
      u_respond(u,"File Could Not Be Opened Or Read");
      mydelete(xdccs[i]);
      return;
      }
   
   xdccs[i]->size = lseek(xfiledescriptor, 0, SEEK_END);
   
   if ( xdccs[i]->size == 0 ) {
      u_respond(u,"File has size of 0 bytes!");
      mydelete(xdccs[i]);
      return;
      }
   
   close(xfiledescriptor);
   
   numpacks++;
   
   tempstr = mycalloc(maxtextlength,"u_add");
   snprintf(tempstr,maxtextlength-2,
      "ADD PACK: [Pack: %i] [File: %s] Use CHDESC to add description",
      numpacks,xdccs[i]->file);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   xdccsave(0);
   
   }

void u_chdesc(userinput *u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 1 || num > numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (!u->arg2e || !strlen(u->arg2e)) {
      u_respond(u,"Try Specifying a Description");
      return;
      }
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chdesc");
   snprintf(tempstr,maxtextlength-2,
      "CHDESC: [Pack %i] Old: %s New: %s",
      num,xdccs[p]->desc,u->arg2e);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   strcpy(xdccs[p]->desc,u->arg2e);
   
   xdccsave(0);
   
   }

void u_chnote(userinput *u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   if (u->arg1) num = atoi(u->arg1);
   
   if (num < 1 || num > numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chnote");
   snprintf(tempstr,maxtextlength-2,
      "CHNOTE: [Pack %i] Old: %s New: %s",
      num,xdccs[p]->note,u->arg2e);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   if (!u->arg2e || !strlen(u->arg2e)) 
      strcpy(xdccs[p]->note,"");
   else
      strcpy(xdccs[p]->note,u->arg2e);
   
   xdccsave(0);
   
   }

void u_chmins(userinput *u) {
   int num = 0;
   int i,p;
   char *tempstr;
   
   if (u->arg1) num = atoi(u->arg1);
   if (num < 1 || num > numpacks) {
      u_respond(u,"Try Specifying a Valid Pack Number");
      return;
      }
   
   if (!u->arg2 || !strlen(u->arg2)) {
      u_respond(u,"Try Specifying a Minspeed");
      return;
      }

   for (i=1, p=0; i<=numpacks; i++, p++) {
      while (xdccs[p] == NULL || xdccs[p]->offered == 0)
         p++;
      if ( i == num )
         break;
      }
   
   tempstr = mycalloc(maxtextlength,"u_chmins");
   snprintf(tempstr,maxtextlength-2,
      "CHMINS: [Pack %i] Old: %i New: %i",
      num,xdccs[p]->minspeed,atoi(u->arg2));
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   xdccs[p]->minspeed = overallminspeed;
   if ( atoi(u->arg2) != overallminspeed )
      xdccs[p]->minspeed = atoi(u->arg2);
   
   xdccsave(0);
   
   }

void u_chatme(userinput *u) {
   
   u_respond(u,"Sending You A DCC Chat Request");
   
   if (setupdccchatout(u->snick))
      u_respond(u,"[Failed to listen, try again]");
   
   
   }

void u_rehash(userinput *u) {
   
   /* other variables */
   char *templine = mycalloc(maxtextlength,"u_rehash");
   char *tempc = mycalloc(2,"u_rehash");
   int i,j,k,found,filedescriptor,needtojump;
   
   if (u->method==6) u_respond(u,"Caught SIGUSR2, Rehashing...");
   
   snprintf(templine,maxtextlength-2,"Reloading %s ...",configfile);
   u_respond(u,templine);
   
   filedescriptor=open(configfile, O_RDONLY);
   if (filedescriptor < 0) {
      u_respond(u,"Couldn't Open Config File, Aborting rehash");
      mydelete(templine);
      mydelete(tempc);
      return;
      }
   
   for (i=0; i<MAXAHOST; i++)
      mydelete(adminhost[i]);
   
   for (i=0; i<MAXSRVS; i++)
      mydelete(server[i]);
   
   usenatip = 0;
   overallmaxspeeddaydays = 0x7F; /* all days */
   mydelete(plistchans);
   
   highmeminfo=1;
   
   i = 0;
   while(read(filedescriptor,tempc,1) == 1) {
      if (tempc[0] == '\n' || tempc[0] == 13) {  /* 13 is ^M */
         templine[i] = '\0';
         if ( templine[0] != '#' && strlen(templine) != 0 ) {
            for (i=strlen(templine)-1; i>2 && templine[i] == ' '; i--)
               templine[i] = '\0';
            getconfig_set(templine,1);
            }
         i = 0;
         }
      else {
         templine[i] = tempc[0];
         i++;
         }
       }
   
   /* see what needs to be redone */
   
   u_respond(u,"Reconfiguring...");
   
   needtojump=0;
   if (strcmp(vhost_ip,r_vhost_ip) || virthost != r_virthost)
      needtojump=1;
   
   k=0;
   /* part deleted channels, add common channels */
   for (i=0; i<MAXCHNLS && channel[i]; i++) {
      found = 0;
      for (j=0; j<MAXCHNLS && r_channel[j]; j++)
         if (!strcmp(channel[i],r_channel[j])) found = 1;
      if (!found) {
         snprintf(templine,maxtextlength-2,"PART %s",channel[i]);
         if (!needtojump) writeserver(templine);
         }
      else {
         t_channel[k] = mycalloc(maxtextlength,"u_rehash");
         strcpy(t_channel[k],channel[i]);
         t_onchan[k] = onchan[i];
         k++;
         }
      }
      
   /* join/add new channels */
   for (i=0; i<MAXCHNLS && r_channel[i]; i++) {
      found = 0;
      for (j=0; j<MAXCHNLS && channel[j]; j++)
         if (!strcmp(r_channel[i],channel[j])) found = 1;
      if (!found) {
         snprintf(templine,maxtextlength-2,"JOIN %s",r_channel[i]);
         if (!needtojump) writeserver(templine);
         t_channel[k] = mycalloc(maxtextlength,"u_rehash");
         strcpy(t_channel[k],r_channel[i]);
         t_onchan[k] = 0;
         k++;
         }
      }
      
   /* kill old channel lists */
   for (i=0; i<MAXCHNLS && channel[i]; i++)
      mydelete(channel[i]);
   for (i=0; i<MAXCHNLS && r_channel[i]; i++)
      mydelete(r_channel[i]);
      
   /* switch to new channel list */
   for (i=0; i<MAXCHNLS && t_channel[i]; i++) {
      channel[i] = t_channel[i];
      t_channel[i] = NULL;
      onchan[i] = t_onchan[i];
     /* printf("%s %i\n",channel[i],onchan[i]); */
      }
   
   if (needtojump) {
      u_respond(u,"vhost changed, reconnecting");
      mydelete(vhost_ip);
      vhost_ip = r_vhost_ip;
      r_vhost_ip = NULL;
      virthost = r_virthost;
      switchserver();
      /* switchserver takes care of joining channels */
      }
   else {
      mydelete(vhost_ip);
      vhost_ip = r_vhost_ip;
      r_vhost_ip = NULL;
      virthost = r_virthost;
      }
   
   if (strcmp(pidfile,r_pidfile)) {
      u_respond(u,"pidfile changed, switching");
      unlink(pidfile);
      writepidfile(r_pidfile);
      }
   mydelete(pidfile);
   pidfile = r_pidfile;
   r_pidfile = NULL;
   
   if (strcmp(user_nick,r_user_nick)) {
      u_respond(u,"user_nick changed, renaming");
      snprintf(templine,maxtextlength-2,"NICK %s",r_user_nick);
      writeserver2(templine,1);
      }
   mydelete(user_nick);
   user_nick = r_user_nick;
   r_user_nick = NULL;
   strcpy(caps_nick, user_nick);
   caps(caps_nick);
   
   
   if (strcmp(xdccfile,r_xdccfile))
      u_respond(u,"sorry, changing xdccfile is yet implemented");
   mydelete(r_xdccfile);
   
   
   maxb = overallmaxspeed;
   if (overallmaxspeeddayspeed != overallmaxspeed) {
      time_t Tp;
      struct tm *localt;
      time(&Tp);
      localt = localtime(&Tp);

      if (localt->tm_hour >= overallmaxspeeddaytimestart
          && localt->tm_hour < overallmaxspeeddaytimeend
          && ( overallmaxspeeddaydays & (1 << localt->tm_wday)) )
         maxb = overallmaxspeeddayspeed;
      }

   
   /* check for completeness */
   u_respond(u,"Checking for completeness of config file ...");
   
   if ( server[0] == NULL
        || user_nick == NULL || user_realname == NULL
        || user_modes == NULL || channel[0] == NULL
        || slotsmax == 0 || xdccautosavetime == 0 || xdccfile == 0)
      u_respond(u,"***WARNING*** missing vital information, fix and re-rehash ASAP");
   
   if ( autosend && ( autoword == NULL || automsg == NULL || !autopack ) )
      u_respond(u,"***WARNING*** incomplete autosend information, fix and re-rehash ASAP");
   
   if ( plist && ( plisttime == 0 || plistchans == NULL ) )
      u_respond(u,"***WARNING*** incomplete plist information, fix and re-rehash ASAP");
   
   u_respond(u,"Done.");
   
   highmeminfo=0;
   
   mydelete(tempc);
   mydelete(templine);

   }

void u_botinfo(userinput *u) {
   char *tempstr = mycalloc(maxtextlength,"u_botinfo");
   int i;

   u_respond(u,"BotInfo:");
   
   snprintf(tempstr,maxtextlength-2,
            "nick: %s, plist: %i mins, %i limit%s",
            user_nick, plisttime,plistlimit,(plistminimal?", minimal format":""));
   u_respond(u,tempstr);
   
   snprintf(tempstr,maxtextlength-2,
            "curent server: %s %s",
            curserverip,curserverport);
   u_respond(u,tempstr);
   
   for (i=0; channel[i] && i<MAXCHNLS; i++) {
      snprintf(tempstr,maxtextlength-2,
               "channel %s: %s",
               channel[i], (onchan[i]?"on":"not on channel!"));
      u_respond(u,tempstr);
      }
   
   snprintf(tempstr,maxtextlength-2,
            "bandwidth: lowsend: %i, minspeed: %i, maxspeed: %i",
            lowbdwth,overallminspeed,maxb/4);
   u_respond(u,tempstr);
   
   if (overallmaxspeed != overallmaxspeeddayspeed)
      snprintf(tempstr,maxtextlength-2,
            "           default max: %i, day max: %i ( %i:00 -> %i:59, days=\"%s%s%s%s%s%s%s\" )",
            overallmaxspeed/4,overallmaxspeeddayspeed/4,
            overallmaxspeeddaytimestart,overallmaxspeeddaytimeend-1,
            (overallmaxspeeddaydays & (1 << 1)) ? "M":"",
            (overallmaxspeeddaydays & (1 << 2)) ? "T":"",
            (overallmaxspeeddaydays & (1 << 3)) ? "W":"",
            (overallmaxspeeddaydays & (1 << 4)) ? "R":"",
            (overallmaxspeeddaydays & (1 << 5)) ? "F":"",
            (overallmaxspeeddaydays & (1 << 6)) ? "S":"",
            (overallmaxspeeddaydays & (1 << 0)) ? "U":"");
   else
      snprintf(tempstr,maxtextlength-2,
            "           default max: %i, day max: (same)",
            overallmaxspeed/4);
   u_respond(u,tempstr);
   
   snprintf(tempstr,maxtextlength-2,
            "files: xdcc: %s, pid: %s, log: %s, msg: %s",
            (xdccfile?xdccfile:"(none)"),
            (pidfile?pidfile:"(none)"),
            (logfile?logfile:"(none)"),
            (messagefile?messagefile:"(none)"));
   u_respond(u,tempstr);
   
   if (delayedshutdown) {
      u_respond(u,"NOTICE: Delayed shutdown activated, iroffer will shutdown once there are no active transfers");
      u_respond(u,"NOTICE: To cancel the delayed shutdown, issue \"SHUTDOWN CANCEL\"");
      }
   
   mydelete(tempstr);
   }


void u_ignl(userinput *u) {
   int i,haveignored,left,ago;
   char *tempstr;
   
   haveignored=0;
   for (i=0; i<MAXIGNL && ignorelist[i]; i++)
      if (ignorelist[i]->ignoring) haveignored++;
   
   if (!haveignored) {
      u_respond(u,"No Hosts Ignored");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_ignl");
   
   snprintf(tempstr,maxtextlength-2,"Current Ignore%s:",haveignored!=1?"s":"");
   u_respond(u,tempstr);
   u_respond(u,"   Last Request  Un-Ignore     Type   Hostname");
   
   for (i=0; i<MAXIGNL && ignorelist[i]; i++) {
      if (ignorelist[i]->ignoring) {
         ago = curtime-ignorelist[i]->lastcontact;
         left = IGN_TL*(ignorelist[i]->bucket-IGN_OFF);
         snprintf(tempstr,maxtextlength-2,"   %4i%c%02i%c ago   %4i%c%02i%c   %6s   %-32s",
                ago < 3600 ? ago/60 : ago/60/60 ,
                ago < 3600 ? 'm' : 'h',
                ago < 3600 ? ago%60 : (ago/60)%60 ,
                ago < 3600 ? 's' : 'm',
                left < 3600 ? left/60 : left/60/60 ,
                left < 3600 ? 'm' : 'h',
                left < 3600 ? left%60 : (left/60)%60 ,
                left < 3600 ? 's' : 'm',

            ignorelist[i]->manual ? "manual" : "auto",
            ignorelist[i]->hostname);
         u_respond(u,tempstr);
         }
      }
   
   mydelete(tempstr);
   }

void u_ignore(userinput *u) {
   int i, num=0, found;
   char *tempstr;
   
   if (u->arg1) num = atoi(u->arg1);
   if (!u->arg2 || strlen(u->arg2) < 4) {
      u_respond(u,"Try specifying a hostname longer than 4 characters");
      return;
      }
   
   for (found=i=0; (i<MAXIGNL && ignorelist[i] && !found); i++)
      if (!strcmp(ignorelist[i]->hostname,u->arg2)) found++;
   
   if (i == MAXIGNL) {
      outerror(1,"Out of ignore slots!, This shouldn't happen");
      u_respond(u,"Out of ignore slots!, This shouldn't happen");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_ignore");
   
   if (!found) {
      ignorelist[i] = mycalloc(sizeof(igninfo),"u_ignore_ignorelist[i]");
      strcpy(ignorelist[i]->hostname,u->arg2);
      ignorelist[i]->ignoring = 1;
      ignorelist[i]->firstignore = 0;
      ignorelist[i]->lastcontact = curtime;
      }
   else
      i--;
   ignorelist[i]->manual = 1;
   ignorelist[i]->bucket = (num*60)/IGN_TL;
   
   snprintf(tempstr,maxtextlength-2,
            "Ignore activated for *!*@%s which will last %i min",
            u->arg2,num);
   u_respond(u,tempstr);
   mydelete(tempstr);
   }


void u_nosave(userinput *u) {
   int num = 0;
   char *tempstr = mycalloc(maxtextlength,"u_nosave");
   
   if (u->arg1) num = atoi(u->arg1);
   noautosave=curtime + 60*num - 1;
   snprintf(tempstr,maxtextlength-2,
   "*** XDCC AutoSave has been disabled for the next %i minute%s",num,num!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
   }


void u_nosend(userinput *u) {
   int num = 0;
   char *tempstr = mycalloc(maxtextlength,"u_nosend");
   
   if (u->arg1) num = atoi(u->arg1);
   nonewcons=curtime + 60*num - 1;
   snprintf(tempstr,maxtextlength-2,
   "*** XDCC Send has been disabled for the next %i minute%s",num,num!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
   }


void u_nolist(userinput *u) {
   int num = 0;
   char *tempstr = mycalloc(maxtextlength,"u_nolist");
   
   if (u->arg1) num = atoi(u->arg1);
   nolisting=curtime + 60*num - 1;
   snprintf(tempstr,maxtextlength-2,
   "*** XDCC List and PLIST have been disabled for the next %i minute%s",num,num!=1?"s":"");
   u_respond(u,tempstr);
   
   mydelete(tempstr);
   
   }


void u_renumber(userinput *u) {
   int oldp = 0, newp = 0;
   int i,op,np;
   xdcc *t;
   char *tempstr;
   
   if (u->arg1) oldp = atoi(u->arg1);
   if (u->arg2) newp = atoi(u->arg2);
   
   if (oldp < 1 || oldp > numpacks || newp < 1 || newp > numpacks || newp == oldp ) {
      u_respond(u,"Invalid pack number");
      return;
      }
   
   /* find old */
   for (i=1, op=0; i<=numpacks; i++, op++) {
      while (xdccs[op] == NULL || xdccs[op]->offered == 0)
         op++;
      if ( i == oldp )
         break;
      }
   
   /* find new */
   for (i=1, np=0; i<=numpacks; i++, np++) {
      while (xdccs[np] == NULL || xdccs[np]->offered == 0)
         np++;
      if ( i == newp )
         break;
      }
   
   t = xdccs[op];
   if (np > op)
      for (i=op; i<np; i++)
         xdccs[i] = xdccs[i+1];
   if (np < op)
      for (i=op; i>np; i--)
         xdccs[i] = xdccs[i-1];
   xdccs[np] = t;
   
   tempstr = mycalloc(maxtextlength,"u_renumber");
   snprintf(tempstr,maxtextlength-2,"*** Moved pack %i to %i",oldp,newp);
   u_respond(u,tempstr);
   mydelete(tempstr);
   
   }


void u_msgread(userinput *u) {
   int fd,count=0,i;
   char *linedate, *linemask;
   int msgoffset;
   char *tempstr, *tempstr2;
   
   if (!messagefile) {
      u_respond(u,"no messagefile defined in config");
      return;
      }
   
   fd=open(messagefile, O_RDONLY);
   if (fd < 0) {
      u_respond(u,"messagefile couldn't be opened");
      return;
      }
   
   tempstr = mycalloc(maxtextlength,"u_msgread");
   tempstr2 = mycalloc(maxtextlength,"u_msgread");
   while (getfline(tempstr,fd,0) != NULL) {
      count++;
      linedate = getpart(tempstr,1,"u_msgread");
      linemask = getpart(tempstr,2,"u_msgread");
      msgoffset = sstrlen(linedate) + sstrlen(linemask) + 1;
      
      for (i=msgoffset; i<sstrlen(tempstr)+1; i++)
         tempstr[i-msgoffset] = tempstr[i];
      
      
      linedate = getdatestr(linedate,atoul(linedate));
      
      snprintf(tempstr2,maxtextlength-2,
      "MSGLOG: [%s] [%s]:",linedate,linemask);
      u_respond(u,tempstr2);
      snprintf(tempstr2,maxtextlength-2,
      "     ^-- %s",tempstr);
      u_respond(u,tempstr2);
      
      mydelete(linedate); mydelete(linemask);
      }
   
   snprintf(tempstr2,maxtextlength-2,
   "MSGLOG: %i message%s in log%s%s",
           count,
           count!=1?"s":"",
           count?", use MSGDEL to remove ":"",
           count>1?"them":(count==1?"it":""));
   u_respond(u,tempstr2);
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   close(fd);
   
   }


void u_msgdel(userinput *u) {
   
   if (!messagefile) {
      u_respond(u,"no messagefile defined in config");
      return;
      }
   
   if (truncate(messagefile,0) < 0) {
      u_respond(u,"couldn't delete messages");
      return;
      }
   
   u_respond(u,"MSGLOG: deleted all messages");
   
   }


void u_memstat(userinput *u) {
   int i;
   long numcount, numcountrecent, sizecount;
   char *tempstr = mycalloc(maxtextlength,"u_memstat");
   
   u_respond(u,"iroffer memory usage:");
      
   for (numcountrecent=numcount=sizecount=i=0; i<MAXMEMINFO; i++)
      if (meminfo[i].ptr != NULL) {
         numcount++;
         sizecount += meminfo[i].size;
         if (meminfo[i].alloctime > curtime-600)
            numcountrecent++;
         }
      
   snprintf(tempstr,maxtextlength-2,
     "%li bytes allocated for %li arrays (%li created in past 10 min)",
     sizecount,numcount,numcountrecent);
   u_respond(u,tempstr);
   
   if (u->arg1 && !strcmp(u->arg1,"list")) {
      
      u_respond(u,"iroffer memory usage details:");
      
      for (i=0; i<MAXMEMINFO; i++)
         if (meminfo[i].ptr != NULL) {
            
            snprintf(tempstr,maxtextlength-2,
              "id %4i | ptr 0x%8.8lX | size %4i | when %7lis | comment \"%s\"",
              i,
              (long)meminfo[i].ptr,
              meminfo[i].size,
              meminfo[i].alloctime-startuptime,
              meminfo[i].src ? meminfo[i].src : "unknown" );
            u_respond(u,tempstr);
            
            }
      
      }
   else
      u_respond(u,"for a detailed listing use \"memstat list\"");
   
   mydelete(tempstr);
   
   }


void u_delayedshutdown(userinput *u) {
   
   if (!u->arg1 || (strcmp(caps(u->arg1),"ACTIVATE") && strcmp(u->arg1,"CANCEL")) ) {
      u_respond(u,"Usage: DSHUTDOWN <activate|cancel>");
      return;
      }
   
   if (!strcmp(u->arg1,"ACTIVATE")) {
      u_respond(u,"Delayed shutdown activated, iroffer will shutdown once there are no active transfers");
      u_respond(u,"To cancel the delayed shutdown, issue \"SHUTDOWN CANCEL\"");
      delayedshutdown=1;
      }
   else if (!strcmp(u->arg1,"CANCEL")) {
      u_respond(u,"Delayed shutdown canceled");
      delayedshutdown=0;
      }
   
   }


