/**************************************************************************** 
** File: rip.h
**
** Author: Mike Borella
**
** Comments: Structure of RIP packets
**
*****************************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define RIP_CMD_RQ         1
#define RIP_CMD_RP         2
#define RIP_CMD_POLL       5
#define RIP_CMD_POLL_ENTRY 6

/*
 * Static part of RIP header
 */

typedef struct _RipHdr
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t domain;
  u_int8_t version;
  u_int8_t command;
#else
  u_int8_t command;
  u_int8_t version;
  u_int16_t domain;
#endif
} RipHdr;

/*
 * RIP route header
 */

typedef struct _RipRouteHdr
{
  u_int16_t addr_fam;
  u_int16_t route_tag;
  struct in_addr ipaddr;
  struct in_addr netmask;
  struct in_addr next_hop;
  u_int32_t metric;
} RipRouteHdr;

/*
 * RIP authentication header
 */

typedef struct _RipAuthHdr
{
  u_int16_t addr_fam;
  u_int16_t type;
  char passwd [16];
} RipAuthHdr;


void dump_rip(u_char *bp, int length);
