/*******************************
 General utility functions
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

/*** GnomeICU header files ***/
#include "common.h"
#include "timezone.h"

/*** Toplevel header files ***/
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>
#include <termios.h>

typedef struct 
{
  const char *name;
  WORD code;
} COUNTRY_CODE;

static COUNTRY_CODE Country_Codes[] = {
  { N_("USA"), 1 },
  { N_("Afghanistan"), 93 },
  { N_("Albania"), 355 },
  { N_("Algeria"), 213 },
  { N_("American Samoa"), 684 },
  { N_("Andorra"), 376 },
  { N_("Angola"), 244 },
  { N_("Anguilla"), 101 },
  { N_("Antigua"), 102 },
  { N_("Argentina"), 54 },
  { N_("Armenia"), 374 },
  { N_("Aruba"), 297 },
  { N_("Ascention Island"), 274 },
  { N_("Australia"), 61 },
  { N_("Australian Antartic Territory"), 6721 },
  { N_("Austria"), 43 },
  { N_("Azerbaijan"), 934 },
  { N_("Bahamas"), 103 },
  { N_("Bahrain"), 973 },
  { N_("Bangladesh"), 880 },
  { N_("Barbados"), 104 },
  { N_("Belarus"), 375 },
  { N_("Belgium"), 32 },
  { N_("Belize"), 501 },
  { N_("Benin"), 229 },
  { N_("Bermuda"), 105 },
  { N_("Bhutan"), 975 },
  { N_("Bolivia"), 591 },
  { N_("Bosnia Herzegovina"), 387 },
  { N_("Botswana"), 267 },
  { N_("Brazil"), 55 },
  { N_("British Virgin_Islands"), 106 },
  { N_("Brunei"), 673 },
  { N_("Bulgaria"), 359 },
  { N_("Burkina Faso"), 226 },
  { N_("Burundi"), 257 },
  { N_("Cambodia"), 855 },
  { N_("Cameroon"), 237 },
  { N_("Canada"), 107 },
  { N_("Cape Verde Islands"), 238 },
  { N_("Cayman Islands"), 108},
  { N_("Central African Republic"), 236},
  { N_("Chad"), 235},
  { N_("Christmas Island"), 672},
  { N_("Cocos Keeling Islands"), 6101},
  { N_("Comoros"), 2691},
  { N_("Congo"), 242},
  { N_("Cook Islands"), 682},
  { N_("Chile"), 56 },
  { N_("China"), 86 },
  { N_("Columbia"), 57 },
  { N_("Costa Rice"), 506 },
  { N_("Croatia"), 385 }, /* Observerd */
  { N_("Cuba"), 53 },
  { N_("Cyprus"), 357 },
  { N_("Czech Republic"), 42 },
  { N_("Denmark"), 45 },
  { N_("Diego Garcia"), 246},
  { N_("Djibouti"), 253},
  { N_("Dominica"), 109},
  { N_("Dominican Republic"), 110},
  { N_("Ecuador"), 593 },
  { N_("Egypt"), 20 },
  { N_("El Salvador"), 503 },
  { N_("Equitorial Guinea"), 240},
  { N_("Eritrea"), 291},
  { N_("Estonia"), 372},
  { N_("Ethiopia"), 251 },
  { N_("Former Yugoslavia"), 389},
  { N_("Faeroe Islands"), 298},
  { N_("Falkland Islands"), 500},
  { N_("Federated States of Micronesia"), 691 },
  { N_("Fiji"), 679 },
  { N_("Finland"), 358 },
  { N_("France"), 33 },
  { N_("French Antilles"), 596 },  /* Leave it */
  { N_("French Antilles"), 5901 }, /* Either on or the other is right :) */
  { N_("French Guiana"), 594 },
  { N_("French Polynesia"), 689 },
  { N_("Gabon"), 241 },
  { N_("Gambia"), 220 },
  { N_("Georgia"), 995 },
  { N_("Germany"), 49 },
  { N_("Ghana"), 233 },
  { N_("Gibraltar"), 350 },
  { N_("Greece"), 30 },
  { N_("Greenland"), 299 },
  { N_("Grenada"), 111 },
  { N_("Guadeloupe"), 590 },
  { N_("Guam"), 671 },
  { N_("Guantanomo Bay"), 5399 },
  { N_("Guatemala"), 502 },
  { N_("Guinea"), 224 },
  { N_("Guinea Bissau"), 245 },
  { N_("Guyana"), 592 },
  { N_("Haiti"), 509 },
  { N_("Honduras"), 504 },
  { N_("Hong Kong"), 852 },
  { N_("Hungary"), 36 },
  { N_("Iceland"), 354 },
  { N_("India"), 91 },
  { N_("Indonesia"), 62 },
  { N_("INMARSAT"), 870 },
  { N_("INMARSAT Atlantic East"), 870 },
  { N_("Iran"), 98 },
  { N_("Iraq"), 964 },
  { N_("Ireland"), 353 },
  { N_("Israel"), 972 },
  { N_("Italy"), 39 },
  { N_("Ivory Coast"), 225 },
  { N_("Japan"), 81 },
  { N_("Jordan"), 962 },
  { N_("Kenya"), 254 },
  { N_("South Korea"), 82 },
  { N_("Kuwait"), 965 },
  { N_("Liberia"), 231 },
  { N_("Libya"), 218 },
  { N_("Liechtenstein"), 4101 },
  { N_("Luxembourg"), 352 },
  { N_("Malawi"), 265 },
  { N_("Malaysia"), 60 },
  { N_("Mali"), 223 },
  { N_("Malta"), 356 },
  { N_("Mexico"), 52 },
  { N_("Monaco"), 33 },
  { N_("Morocco"), 212 },
  { N_("Namibia"), 264 },
  { N_("Nepal"), 977 },
  { N_("Netherlands"), 31 },
  { N_("Netherlands Antilles"), 599 },
  { N_("New Caledonia"), 687 },
  { N_("New Zealand"), 64 },
  { N_("Nicaragua"), 505 },
  { N_("Nigeria"), 234 },
  { N_("Norway"), 47 }, 
  { N_("Oman"), 968 },
  { N_("Pakistan"), 92 },
  { N_("Panama"), 507 },
  { N_("Papua New Guinea"), 675 },
  { N_("Paraguay"), 595 },
  { N_("Peru"), 51 },
  { N_("Philippines"), 63 },
  { N_("Poland"), 48 },
  { N_("Portugal"), 351 },
  { N_("Qatar"), 974 },
  { N_("Romania"), 40 },
  { N_("Russia"), 7 },
  { N_("Saipan"), 670 },
  { N_("San Marino"), 39 },
  { N_("Saudia Arabia"), 966 },
  { N_("Senegal"), 221},
  { N_("Singapore"), 65 },
  { N_("Slovakia"), 42 },
  { N_("South_Africa"), 27 },
  { N_("Spain"), 34 },
  { N_("Sri Lanka"), 94 },
  { N_("Suriname"), 597 },
  { N_("Sweden"), 46 },
  { N_("Switzerland"), 41 },
  { N_("Taiwan"), 886 },
  { N_("Tanzania"), 255 },
  { N_("Thailand"), 66 },
  { N_("Tunisia"), 216 },
  { N_("Turkey"), 90 },
  { N_("United Arab Emirates"), 971 },
  { N_("Uruguay"), 598 },
  { N_("UK"), 0x2c },
  { N_("Ukraine"), 380 },
  { N_("Vatican City"), 39 },
  { N_("Venezuela"), 58 },
  { N_("Vietnam"), 84 },
  { N_("Yemen"), 967 },
  { N_("Yugoslavia"), 38 },
  { N_("Zaire"), 243 },
  { N_("Zimbabwe"), 263 },
  { N_("Not entered"), 0 },
  { N_("Not entered"), 0xffff } 
};

/*** Global functions ***/
GList *get_time_zones( void )
{
	GList *l = NULL;
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
		l = g_list_append( l, _(time_zones[ cx ].str) );

	return l;
}

GList *get_country_codes( void )
{
  GList *l = NULL;
  gint cx;
  
  for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx ++ )
    l = g_list_append( l, _(Country_Codes[ cx ].name) );
  
  return l;
}

const gchar *Get_Country_Name( int code )
{
   gint i;
   
   for ( i = 0; Country_Codes[i].code != 0xffff; i++)
     if ( Country_Codes[i].code == code )
       return _(Country_Codes[i].name);

   return _(Country_Codes[i].name);
}

const gchar *Get_Time_Zone_String( int code )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
	if( time_zones[ cx ].gmt_offset == code )
		return _(time_zones[ cx ].str);

	return _(time_zones[ cx ].str);
}

int Get_Country_Code( const gchar *country )
{
	int cx;

	for( cx = 0; Country_Codes[ cx ].code != 0xffff; cx++ )
	  if( !strcmp( _(Country_Codes[ cx ].name), country ) )
	    return Country_Codes[ cx ].code;

	return 0;
}

int Get_Time_Zone( const gchar *desc )
{
	int cx;

	for( cx = 0; time_zones[ cx ].gmt_offset != -1; cx ++ )
	{
		if( !strcmp( _(time_zones[ cx ].str), desc ) )
		{
			return time_zones[ cx ].gmt_offset;
		}
	}
	if( !strcmp( _(time_zones[ cx ].str), desc ) )
		return time_zones[ cx ].gmt_offset;
	return 0;
}

GdkPixmap *GetIcon_p( DWORD status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return icon_offline_pixmap;
	}
   
	switch ( status & 0xffff )
	{
	case STATUS_ONLINE:
		return icon_online_pixmap;
		break;
	case STATUS_DND:
		return icon_dnd_pixmap;
		break;
	case STATUS_AWAY:
		return icon_away_pixmap;
		break;
	case STATUS_OCCUPIED:
		return icon_occ_pixmap;
		break;
	case STATUS_NA:
		return icon_na_pixmap;
		break;
	case STATUS_INVISIBLE:
		return icon_inv_pixmap;
		break;
	case STATUS_FREE_CHAT:
		return icon_ffc_pixmap;
		break;
	default:
		return icon_offline_pixmap;
		break;
	}
}

GdkBitmap *GetIcon_b( DWORD status )
{
	if ( STATUS_OFFLINE == status ) /* this because -1 & 0xFFFF is not -1 */
	{
		return icon_offline_bitmap;
	}
   
	switch ( status & 0xffff )
	{
	case STATUS_ONLINE:
		return icon_online_bitmap;
		break;
	case STATUS_DND:
		return icon_dnd_bitmap;
		break;
	case STATUS_AWAY:
		return icon_away_bitmap;
		break;
	case STATUS_OCCUPIED:
		return icon_occ_bitmap;
		break;
	case STATUS_NA:
		return icon_na_bitmap;
		break;
	case STATUS_INVISIBLE:
		return icon_inv_bitmap;
		break;
	case STATUS_FREE_CHAT:
		return icon_ffc_bitmap;
		break;
	default:
		return icon_offline_bitmap;
		break;
	}
}
	

/*******************************************************
Gets config info from the rc file in the users home 
directory.
********************************************************/
void Get_Unix_Config_Info( void )
{
#ifdef TRACE_FUNCTION
	g_print( "Get_Unix_Config_Info\n" );
#endif

	gnome_config_push_prefix( configfilename );

	if ( gnome_config_get_string( "Existence/exists" ) == NULL )
		Initialize_RC_File();

	gnome_config_pop_prefix();

	Read_RC_File();
}


/********************************************
Converts an ip number character sequence to
a DWORD
The IP number is stored in big endian byte
order in the icq protocol
*********************************************/
DWORD IP_2_DW( const guchar buf[] )
{
       DWORD i;

       i= buf[0];
       i <<= 8;
       i+= buf[1];
       i <<= 8;
       i+= buf[2];
       i <<= 8;
       i+= buf[3];

       return i;
}


/********************************************
Converts an intel endian character sequence to
a DWORD
*********************************************/
DWORD Chars_2_DW( const guchar buf[] )
{
	DWORD i;

	i= buf[3];
	i <<= 8;
	i+= buf[2];
	i <<= 8;
	i+= buf[1];
	i <<= 8;
	i+= buf[0];

	return i;
}

/********************************************
Converts an intel endian character sequence to
a WORD
*********************************************/
WORD Chars_2_Word( const guchar *buf )
{
	WORD i;

	i= buf[1];
	i <<= 8;
	i += buf[0];

	return i;
}

/********************************************
Converts a DWORD to an IP number character 
sequence
The IP number is stored in big endian byte order
for use in the icq protocol
*********************************************/
void DW_2_IP( guchar buf[], DWORD num )
{
       buf[0] = ( guchar ) ((num)>>24)& 0x000000FF;
       buf[1] = ( guchar ) ((num)>>16)& 0x000000FF;
       buf[2] = ( guchar ) ((num)>>8)& 0x000000FF;
       buf[3] = ( guchar ) (num) & 0x000000FF;
}

/********************************************
Converts a DWORD to
an intel endian character sequence 
*********************************************/
void DW_2_Chars( guchar buf[], DWORD num )
{
	buf[3] = ( guchar ) ((num)>>24)& 0x000000FF;
	buf[2] = ( guchar ) ((num)>>16)& 0x000000FF;
	buf[1] = ( guchar ) ((num)>>8)& 0x000000FF;
	buf[0] = ( guchar ) (num) & 0x000000FF;
}

/********************************************
Converts a WORD to
an intel endian character sequence 
*********************************************/
void Word_2_Chars( guchar buf[], WORD num )
{
	buf[1] = ( guchar ) (((unsigned)num)>>8) & 0x00FF;
	buf[0] = ( guchar ) ((unsigned)num) & 0x00FF;
}

void Add_User( UIN_T uin, const gchar *name, gboolean inlist )
{
	GSList *contact;
	CONTACT_PTR contactdata;

#ifdef TRACE_FUNCTION
	g_print( "Add_User\n" );
#endif

	contact = Contacts;

	while( contact != NULL )
	{
		if( uin == ((CONTACT_PTR)contact->data)->uin )
			return;
		contact = contact->next;
	}

	contactdata = g_new0( Contact_Member, 1 );

	contactdata->uin = uin;
	contactdata->icon_p = icon_offline_pixmap;
	contactdata->icon_b = icon_offline_bitmap;
	contactdata->stored_messages = NULL;
	contactdata->need_update = TRUE;
	contactdata->status = STATUS_OFFLINE;
	contactdata->last_status = STATUS_OFFLINE;
	contactdata->last_time = -1L;
	contactdata->current_ip = -1L;
	contactdata->port = 0;
	contactdata->sok = (SOK_T ) 0;
	contactdata->invis_list = FALSE;
	contactdata->gdk_input_tag = 0;
	contactdata->chat_away = 0;
	contactdata->chat_window = NULL;
	contactdata->chat_history = NULL;
	contactdata->chat_seq = 0;
	contactdata->chat_sok = 0;
	contactdata->chat_active = FALSE;
	contactdata->chat_active2 = FALSE;
	contactdata->chat_port = 0;
	contactdata->chat_bg_red =
	contactdata->chat_bg_green =
	contactdata->chat_bg_blue = 255;
	contactdata->chat_fg_red =
	contactdata->chat_fg_green =
	contactdata->chat_fg_blue = 0;
	contactdata->tcp_gdk_input = 0;
	contactdata->chat_gdk_input = 0;
	contactdata->oneline_in = NULL;
	contactdata->oneline_out = NULL;
	memcpy( contactdata->nick, name, sizeof( contactdata->nick ) - 1 );

	contactdata->pdata = NULL;
	contactdata->file_name = NULL;
	contactdata->file_short_name = NULL;
	contactdata->file_fd = 0;
	contactdata->file_offset = 0;
	contactdata->file_sending = FALSE;
	contactdata->file_info = NULL;
	contactdata->show_again = TRUE;
	contactdata->chat_reason = NULL;
	contactdata->info = g_new0( USER_INFO_STRUCT, 1 );
	contactdata->info->sex = NOT_SPECIFIED;
	contactdata->info->country = 1;

	if( inlist )
		contactdata->inlist = TRUE;

	Contacts = g_slist_append( Contacts, contactdata );

	send_info_req( uin );
	snd_contact_list();

	Show_Quick_Status_lower( UPDATE_OFFLINE, NULL );

	Save_RC();
}

void Init_New_User( void )
{
   srv_net_icq_pak pak;
   int s;
   struct timeval tv;
   fd_set readfds;
	SOK_T backup_sok;
	gchar *str;

	backup_sok = MainData->sok;

   MainData->sok = Connect_Remote( server, remote_port, STDERR );

   if ( ( MainData->sok == -1 ) || ( MainData->sok == 0 ) ) 
		g_error( _("Unable to create new user") );

	reg_new_user( passwd );

	for( ; ; )
	{
		tv.tv_sec = 3;
		tv.tv_usec = 500000;

		FD_ZERO(&readfds);
		FD_SET(MainData->sok, &readfds);

		/* don't care about writefds and exceptfds: */
		select(MainData->sok+1, &readfds, NULL, NULL, &tv);

		if (FD_ISSET(MainData->sok, &readfds))
		{
			s = SOCKREAD( &pak.head.ver, sizeof( pak ) - 2  );
			if ( Chars_2_Word( pak.head.cmd ) == SRV_NEW_UIN )
			{
				our_info->uin = Chars_2_DW( pak.head.UIN );
				str = g_strdup_printf( _("Your new UIN is %u"), our_info->uin );
				gtk_widget_show( gnome_message_box_new( _(str),
				                 GNOME_MESSAGE_BOX_INFO,
				                 GNOME_STOCK_BUTTON_OK, NULL ) );
				g_free( str );
				MainData->sok = backup_sok;
				return;
			}
		}
		else
			reg_new_user( passwd );
	}

	MainData->sok = backup_sok;
}
