/* gnome-napster, a GNOME Napster client.
 * Copyright (C) 1999 Evan Martin <eeyem@u.washington.edu>
 */


/* FIXME
 * This entire file is a big messy hack.  It should be thrown away and rewritten.
 */

#include <gnome.h>
#include <glib.h>
#include <pthread.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>

/* gettimeofday */
#include <sys/time.h>

/* open */
#include <sys/stat.h>
#include <fcntl.h>
/* network */
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "lnap.h"
#include "download.h"
#include "login.h" /* for the login info (client name) */
#include "gconfig.h" /* download path */
#include "util.h"

typedef enum {
	EG_QUEUED, EG_GETINFO, EG_REMOTEQUEUEFULL, EG_READY,
	EG_CONNECTING, EG_REQUESTING, EG_DOWNLOADING,
	EG_FILECOMPLETE, EG_ERROR
} EGetStatus;
static char *statuslookup[] = {
	"Queued", "Getting info...", "Remotely Queued", "Ready to download",
	"Connecting...", "Requesting file...", "Downloading...",
	"File complete", "Error downloading?", NULL
};

enum {
	COL_TITLE, COL_HOST, COL_STATUS, COL_COUNT
};
static char* titles[] = { "File", "Host", "Status" };

typedef struct {
	char host[20];
	int downloadcur;
	int downloadmax;
	GList *ldl;
	GList *lqueue;
	GMutex *mutex;
} shostqueue;

typedef struct {
	/* data returned by napster */
	struct in_addr sin_addr;
	int port;
	char title[256];
	char checksum[40];
	int conn;

	/* internal data */
	shostqueue *hq;
	pthread_t thread;
	int row;
	int shift; /* how much of the title to save */
	unsigned long filesize;
	unsigned long filebytes;
	EGetStatus status;
	char *errormsg;

	struct timeval timestamp;

	/* transfer rate calculations */
	long bytestamp;
	double kbps;
} sgetfile;

static GList *hostlist = NULL;
static int downloadcount = 0;
G_LOCK_DEFINE_STATIC(hostlist);

#define DOWNLOAD_UPDATE_FREQ 1000
//static int gtag_update = 0;

static GtkWidget *clist;
G_LOCK_DEFINE_STATIC(clist);

static void queuecheckall(void);
static void queuecheck(shostqueue *hq);
static void getinfo(sgetfile *gf);
static shostqueue* hostqueue_find(char *host, int newok);
static sgetfile* getfile_find(char *host, char *title, int newok);

#define TLOCK(x) { FUNCPRINT("lock"); g_mutex_lock(x); }
#define TUNLOCK(x) { FUNCPRINT("unlock"); g_mutex_unlock(x); }

static shostqueue* 
shostqueue_new(char *host) {
	shostqueue* hq = g_new0(shostqueue, 1);
	strcpy(hq->host, host);
	hq->mutex = g_mutex_new();
	hq->downloadmax = 2; /* FIXME */
	return hq;
}

static sgetfile* 
sgetfile_new(char *title) {
	sgetfile *gf;
	FUNCPRINT("title='%s'", title);
	gf = g_new0(sgetfile, 1);
	strcpy(gf->title, title);
	return gf;
}

static void 
list_update(int row) {
	sgetfile *gf;
	char buf[1024];

	gf = (sgetfile*) gtk_clist_get_row_data(GTK_CLIST(clist), row);
	/*FUNCPRINT("row=%d, status=%s", row, statuslookup[gf->status]);*/
	if (gf->status == EG_DOWNLOADING) {
		sprintf(buf, "%.2f/%.2fmb: %.1f%% (%.2fk/sec)", 
				gf->filebytes/(float)1000000, gf->filesize/(float)1000000, 
				100.0*gf->filebytes/(float)gf->filesize, gf->kbps);
		gtk_clist_set_text(GTK_CLIST(clist), row, COL_STATUS, buf);
	} else if (gf->status == EG_ERROR) {
		gtk_clist_set_text(GTK_CLIST(clist), row, COL_STATUS, gf->errormsg);
	} else {
		gtk_clist_set_text(GTK_CLIST(clist), row, COL_STATUS, statuslookup[gf->status]);
	}
	gtk_widget_queue_draw(clist);
}

void download_enqueue(char *host, char *title, int shift) {
	sgetfile *gf;
	gchar* add[COL_COUNT] = { "", "", "" };
	int row;

	FUNCPRINT("'%s', '%s'", host, title);

	printcf("Adding '%s' to download queue...", title);
	/* create the gf and hostqueue if it doesn't already exist */
	gf = getfile_find(host, title, TRUE); 
	gf->shift = shift;

	add[COL_TITLE] = short_path(gf->title, gf->shift);
	add[COL_HOST] = host;

	G_LOCK(clist);
	row = gtk_clist_append(GTK_CLIST(clist), add);
	gtk_clist_set_row_data(GTK_CLIST(clist), row, gf);
	gf->row = row;

	list_update(row);
	G_UNLOCK(clist);

	getinfo(gf);
}

static void 
getinfo(sgetfile *gf) {
	char buf[1024];

	gf->status = EG_GETINFO;
	G_LOCK(clist);
	list_update(gf->row);
	G_UNLOCK(clist);
	FUNCPRINT("gf=%p", gf);
	sprintf(buf, "%s \"%s\"", gf->hq->host, gf->title);
	FUNCPRINT("pack: '%s'\n", buf);
	nap_sendpacket(nap_socknap, NM_FILEINFO_REQUEST, strlen(buf)+1, buf);
}

void download_getinfo_cb(char *text) {
	sgetfile *gf;
	char host[20];
	char title[256];

	FUNCPRINT("packet='%s'", text);

	/* first grab only the host and title */
	sscanf(text, "%s %*u %*d \"%[^\"]\"", host, title);
	/* and look it up */
	gf = getfile_find(host, title, FALSE);
	g_assert(gf != NULL);

	/* then scan the rest of the data into the found gf */
	sscanf(text, "%s %u %d \"%[^\"]\" %s %d",
			host, &gf->sin_addr.s_addr, &gf->port, gf->title, gf->checksum, &gf->conn);
	gf->sin_addr.s_addr = nap_naptohl(gf->sin_addr.s_addr);

	gf->status = EG_READY;

	G_LOCK(clist);
	T( list_update(gf->row); )
	G_UNLOCK(clist);

	queuecheckall();
}

void download_remotequeuefull_cb(char *text) {
	sgetfile *gf;
	char host[20];
	char title[256];

	FUNCPRINT("packet='%s'", text);
	/* first grab only the host and title */
	sscanf(text, "%s \"%[^\"]\"", host, title);
	/* and look it up */
	gf = getfile_find(host, title, FALSE);
	g_assert(gf != NULL);

	sscanf(text, "%s \"%[^\"]\" %*d %*d",
			host, gf->title);
	gf->status = EG_REMOTEQUEUEFULL;
	G_LOCK(clist);
	T( list_update(gf->row); )
	G_UNLOCK(clist);
}

static void downloadcomplete(sgetfile *gf) {
	shostqueue *hq = gf->hq;
	GList *li = NULL;

	/* notify host queue that download has completed */
	FUNCPRINT("decrementing download count...");

	G_LOCK(hostlist);
	downloadcount--;
	G_UNLOCK(hostlist);

	TLOCK(hq->mutex);
	hq->downloadcur--;
	/* and remove from download list */
	li = g_list_find(hq->ldl, gf);
	hq->ldl = g_list_remove_link(hq->ldl, li);
	g_list_free_1(li);

	TUNLOCK(gf->hq->mutex);
	FUNCPRINT("queuecheck...");
	queuecheck(gf->hq);
}

static void* 
downloadproc(void* d) {
	const int buflen = 2048; /* just needs to be greater than MTU; 1500, i guess */
	int filefd = -1, sockfd = -1, len, i, ok;
	char *configpath = NULL;
	guchar buf[buflen];
	char dlpath[buflen], finalpath[buflen];
	struct sockaddr_in s;
	struct timeval ts;
	sgetfile *gf = (sgetfile*)d;

	FUNCPRINT("gf=%p", gf);
for (ok = FALSE; ok != TRUE; ok = TRUE) { /* a simplistic try..catch block */
	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		perror("sock"); break;
	}

	memset(&s, 0, sizeof(struct sockaddr_in));
	s.sin_family = AF_INET;
	s.sin_port = htons(gf->port);
	s.sin_addr.s_addr = gf->sin_addr.s_addr;

	gf->status = EG_CONNECTING;
	T( list_update(gf->row); )
	FUNCPRINT("connecting %s:%d...\n", inet_ntoa(s.sin_addr), ntohs(s.sin_port));
	if (connect(sockfd, (struct sockaddr*)&s, sizeof(struct sockaddr_in)) < 0) {
		perror("connect"); break;
	}

	gf->status = EG_REQUESTING;
	T( list_update(gf->row); )

	/* get "mysterious number" */
	FUNCPRINT("reading mysterious number 1");
	if (recv(sockfd, buf, 1, 0) < 0) /* retrieve the initial '1' */
		perror("recv");
	buf[1] = 0; 
	FUNCPRINT("number: %s", buf);
	
	/* the GET command must be two packets... ? */
	sprintf(buf, "GET");
	if (send(sockfd, buf, strlen(buf), 0) < 0) {
		perror("send"); break;
	}
	sprintf(buf, "%s \"%s\" 0", g_logininfo.user, gf->title); /* FIXME: last param (0) */
	FUNCPRINT("sending request...[%s]", buf);
	if (send(sockfd, buf, strlen(buf), 0) < 0) {
		perror("send"); break;
	}

	for (i = 0; i < buflen; i++) {
		recv(sockfd, buf+i, 1, 0);
		if (buf[i] == 255) break; /* 255 is the first byte of the mp3 */
	}
	buf[i] = 0;
	FUNCPRINT("they say '%s'", buf);
	if (strncmp(buf, "FILE NOT SHARED", 15) == 0) {
		FUNCPRINT("file not shared?!");
		gf->status = EG_ERROR;
		gf->errormsg = "File not shared!?";
		downloadcomplete(gf);
		return NULL;
	}

	gf->filesize = atol(buf);
	FUNCPRINT("file is %ld bytes", gf->filesize);
	
	/* and now the file comes in */
	configpath = gnome_config_get_string(CONFIG_PREFIX "/Paths/Download");
	sprintf(dlpath, "%s/pending/%s", 
			configpath ? configpath : "", /* avoid NULL */
			short_path(gf->title, gf->shift));
	for (i = 0; dlpath[i] != 0; i++) {
		if (dlpath[i] == '\\' || dlpath[i] == '/') {
			/* handle subdirs */
			dlpath[i] = 0;
			mkdir(dlpath, 0777);
			FUNCPRINT("making dir '%s'\n", dlpath);
			dlpath[i] = '/';
		}
	}
	if (configpath) g_free(configpath);
	FUNCPRINT("opening %s", dlpath);

	if ((filefd = open(dlpath, O_WRONLY|O_CREAT, 0666)) < 0) {
		perror("open"); break;
	}

	gf->status = EG_DOWNLOADING;

	T( list_update(gf->row); )

	buf[0] = 255; len = 1;
	gettimeofday(&gf->timestamp, NULL);
	do { /* write, then read, because we have the 255 byte from above */
		write(filefd, buf, len);
		gf->filebytes += len;

		/* and now, some kb/sec calculation.
		 * isn't it sad that the calculation code is 8 times the lines of the actual dl? 
		 * FIXME current code stops updating when no data comes in;
		 * it should show it's getting 0kb/sec somehow. */
		//if (gf->filebytes > 10000) break;  //FIXME download hack */
		gettimeofday(&ts, NULL);
		if ((ts.tv_sec - gf->timestamp.tv_sec) > 1) {
			double deltat, deltatu, deltab;
			deltab = (double)gf->filebytes - gf->bytestamp;
			deltat = (double)ts.tv_sec - gf->timestamp.tv_sec;
			deltatu = (double)ts.tv_usec - gf->timestamp.tv_usec;
			gf->kbps = deltab / ((deltat * 1000.0) + (deltatu / 1000.0));
			T( list_update(gf->row); )
			gf->bytestamp = gf->filebytes;
			gf->timestamp = ts;
		}
	} while ((len = recv(sockfd, buf, buflen, 0)) > 0);

	/* note that you get a "connection reset by peer" at the end
	 * of a _successful_transfer_! so it's only an error if the file 
	 * is incomplete, _and_ there was a recv() error 
	 */
	if ((gf->filebytes < gf->filesize) && (len == -1)) {
		perror("recv"); break; 
	}
}
	if (ok) {
		gf->status = EG_FILECOMPLETE;
		FUNCPRINT("file complete.");
		configpath = gnome_config_get_string(CONFIG_PREFIX "/Paths/Download");
		sprintf(finalpath, "%s%s", 
				configpath ? configpath : "", /* avoid NULL */
				short_path(gf->title, gf->shift));
		if (configpath) g_free(configpath);
		rename(dlpath, finalpath);
	} else {
		gf->errormsg = strerror(errno);
		gf->status = EG_ERROR;
	}

	if (filefd != -1) close(filefd);
	if (sockfd != -1) close(sockfd);
	T( list_update(gf->row); )

	downloadcomplete(gf);

	return NULL;
}

#if 0
/* this was an attempt at improving kb/sec calculations... */
static void kbsec_calc_row(int row) {
	sgetfile *gf;
	gf = gtk_clist_get_row_data(GTK_CLIST(clist), row);
	if (gf->status == EG_DOWNLOADING) {
		//FUNCPRINT("row=%d", row);
		/* DOWNLOAD_UPDATE_FREQ is already in milliseconds, so you don't
		 * need to multiply to get kilobytes/sec! */
		gf->kbps = ((double)gf->filebytes - gf->bytestamp)/
			((double)DOWNLOAD_UPDATE_FREQ);
		gf->bytestamp = gf->filebytes;
		list_update(row);
		T( gtk_widget_queue_draw(clist); )
	}
}

static gint kbsec_calc_all(gpointer d) {
	int row;

	/* this needs to iterate through all of the list elements.
	 * should i go through each host's dl queue?
	 * or through the clist? 
	 * i guess i'm doing the second option. */

	//FUNCPRINT("x");
	G_LOCK(clist);
	gtk_clist_freeze(GTK_CLIST(clist));
	for (row = 0; row < GTK_CLIST(clist)->rows; row++) {
		kbsec_calc_row(row);
	}
	G_UNLOCK(clist);

	return TRUE; /* continue running */
}
#endif

static void queuedownload(shostqueue *hq) {
	GList *lqueue = hq->lqueue;
	sgetfile *gf;
	FUNCPRINT("host=%s", hq->host);
	while (lqueue != NULL) {
		gf = lqueue->data;
		if (gf->status == EG_READY) {
			/* file ready for download: pop it on the download queue */
			FUNCPRINT("queueing another download");
			downloadcount++;
			gf->status = EG_DOWNLOADING;
			hq->lqueue = g_list_remove_link(hq->lqueue, lqueue);
			hq->ldl = g_list_append(hq->ldl, gf);
			hq->downloadcur++;
			pthread_create(&gf->thread, NULL, downloadproc, gf);
			return;
		}
		lqueue = lqueue->next;
	}
}

static int queuefileready(shostqueue *hq) {
	GList *lqueue;
	sgetfile *gf;

	FUNCPRINT("host=%s", hq->host);
	lqueue = hq->lqueue; 
	if (lqueue == NULL) return FALSE;
	while (lqueue != NULL) {
		gf = lqueue->data;
		if (gf->status == EG_READY) return TRUE; /* one file is ready; return */
		lqueue = lqueue->next;
	}
	/* if it gets here, then there are no "ready files";
	 * get info on the next available file, then return FALSE */
	lqueue = hq->lqueue; 
	while (lqueue != NULL) {
		if (gf->status == EG_QUEUED || gf->status == EG_REMOTEQUEUEFULL) {
			FUNCPRINT("trying to get info again");
			getinfo(gf);
			return FALSE;
		}
		lqueue = lqueue->next;
	}
	FUNCPRINT("return");
	return FALSE;
}

static void queuecheck(shostqueue *hq) {
	FUNCPRINT("host=%s", hq->host);
	TLOCK(hq->mutex);
	while (queuefileready(hq) &&          /* stuff on the queue and */
			g_list_length(hq->ldl) < hq->downloadmax /* and download queue isn't full */
			) {
		if (downloadcount > gnome_config_get_int(CONFIG_PREFIX "/Network/MaxGlobalDL=1")) {
			FUNCPRINT("max download count reached");
			TUNLOCK(hq->mutex);
			return;
		}
		/* add a download */
		FUNCPRINT("lqueue: %d, ldl: %d", g_list_length(hq->lqueue), g_list_length(hq->ldl));
		queuedownload(hq);
	} 
	TUNLOCK(hq->mutex);
}

static void queuecheckall() {
	GList *hl;
	shostqueue *hq;

	FUNCPRINT("(no args)");

	G_LOCK(hostlist);
	hl = hostlist;
	
	while (hl != NULL) {
		hq = hl->data;
		queuecheck(hq);
		hl = hl->next;
	}
	G_UNLOCK(hostlist);
}

static shostqueue* 
hostqueue_find(char *host, int newok) {
	GList *l;
	shostqueue *lhq = NULL;

	FUNCPRINT("host='%s' newok=%d", host, newok);
	/* search host list for host */
	G_LOCK(hostlist);
	l = hostlist;
	while (l != NULL) {
		lhq = l->data;
		g_assert(lhq != NULL);
		TLOCK(lhq->mutex);
		if (strcmp(lhq->host, host) == 0) {
			FUNCPRINT("found host '%s' on list.", lhq->host);
			TUNLOCK(lhq->mutex);
			break;
		}
		FUNCPRINT("it isn't host %s...", lhq->host);
		TUNLOCK(lhq->mutex);
		l = l->next;
	}
	if (l == NULL && newok) { /* no download proc for this host */
		FUNCPRINT("host '%s' not found, adding...", host);
		lhq = shostqueue_new(host);
		hostlist = g_list_append(hostlist, lhq);
	}
	G_UNLOCK(hostlist);
	return lhq;
}

static sgetfile*
getfile_find(char *host, char *title, int newok) {
	GList *l;
	sgetfile *gf = NULL;
	shostqueue *lhq = hostqueue_find(host, newok);

	FUNCPRINT("host='%s' title='%s' newok=%d", host, title, newok);
	if (lhq == NULL) return NULL;

	TLOCK(lhq->mutex);
	l = lhq->lqueue;
	while (l != NULL) {
		gf = l->data;
		if (strcmp(gf->title, title) == 0) {
			FUNCPRINT("found it!");
			break;
		}
		l = l->next;
	}
	if (l == NULL && newok) {
		gf = sgetfile_new(title);
		gf->hq = lhq;
		lhq->lqueue = g_list_append(lhq->lqueue, gf);
	}
	TUNLOCK(lhq->mutex);
	return gf;
}


GtkWidget* downloadtab_create(void) {
	GtkWidget *scroll;
	GtkWidget *vbox, *hbox;
	GtkWidget *b;

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 10);
		hbox = gtk_hbox_new(FALSE, 10);
			b = gtk_label_new("(To be implemented:)");
		gtk_box_pack_start(GTK_BOX(hbox), b, FALSE, FALSE, 0);
			b = gtk_button_new_with_label("Cancel");
		gtk_box_pack_start(GTK_BOX(hbox), b, FALSE, FALSE, 0);
			b = gtk_button_new_with_label("Up");
		gtk_box_pack_start(GTK_BOX(hbox), b, FALSE, FALSE, 0);
			b = gtk_button_new_with_label("Down");
		gtk_box_pack_start(GTK_BOX(hbox), b, FALSE, FALSE, 0);
			b = gtk_button_new_with_label("Resume");
		gtk_box_pack_start(GTK_BOX(hbox), b, FALSE, FALSE, 0);
		gtk_widget_set_sensitive(hbox, FALSE);
	/* FIXME don't even display the unimplemented stuff; it looks unprofessional.
	 * gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);*/
		scroll = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll), 
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
			clist = gtk_clist_new_with_titles(sizeof(titles)/sizeof(char*), titles);
			/*gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_MULTIPLE);
			gtk_clist_set_column_justification(GTK_CLIST(clist), COL_SIZE,
					GTK_JUSTIFY_RIGHT);
			gtk_clist_set_column_justification(GTK_CLIST(clist), COL_BITRATE,
					GTK_JUSTIFY_RIGHT);
			*/
			gtk_clist_set_column_width(GTK_CLIST(clist), COL_TITLE, 300);
			gtk_clist_set_column_width(GTK_CLIST(clist), COL_HOST, 50);
			/*gtk_clist_set_column_width(GTK_CLIST(clist), COL_SIZE, 60);
			gtk_clist_set_column_width(GTK_CLIST(clist), COL_HOST, 60);
			gtk_clist_set_column_width(GTK_CLIST(clist), COL_BITRATE, 40);*/
		gtk_container_add(GTK_CONTAINER(scroll), clist);
	gtk_box_pack_start(GTK_BOX(vbox), scroll, TRUE, TRUE, 0);

	//gtk_timeout_add(DOWNLOAD_UPDATE_FREQ, kbsec_calc_all, NULL);
	return vbox;
}

/*GtkWidget *paned;
	GtkWidget *f1, *f2;
	GtkWidget *l;
	
	paned = gtk_vpaned_new();
	gtk_container_set_border_width(GTK_CONTAINER(paned), 10);
	f1 = gtk_frame_new(NULL); gtk_frame_set_shadow_type(GTK_FRAME(f1), GTK_SHADOW_NONE);
	f2 = gtk_frame_new(NULL); gtk_frame_set_shadow_type(GTK_FRAME(f2), GTK_SHADOW_NONE);

	gtk_paned_pack1(GTK_PANED(paned), f1, FALSE, FALSE);

	gtk_container_add(GTK_CONTAINER(f1), gtk_label_new("hello, 1"));
	gtk_container_add(GTK_CONTAINER(f2), gtk_label_new("hello, 2"));*/

