#!/usr/bin/perl

# this script checks is the current version of /etc/dhcpd.leases is more
# current than the version stored in DDNSHOME.  If so, ddns.pl is called
# to create the ndupdate data file.  Then nsupdate is called to notify
# BIND of the changes.

# edit these for your own system
my $DDNSHOME="/root/DHCP-DNS";
my $DHCPD="/etc/dhcpd.leases";
my $DOMAIN="cyp.ugsolutions.com"; 
my $NSUPDATE="/usr/bin/nsupdate";

my $UPDATE="$DDNSHOME/nsupdate.data";
my $DHCPD_TEMP="$DDNSHOME/dhcpd.leases.last";
my $DDNS="$DDNSHOME/ddns.pl";
my $LOCKFILE="$DDNSHOME/lock";

my($ref,$data);
my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks);

# get timestamp on leases file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($DHCPD);
$data=$mtime;

# get timestamp on saved file
($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
 $blksize,$blocks)=stat($DHCPD_TEMP);
$ref=$mtime;

#print "$ref, $data\n";

if ($ref >= $data) {
    exit 0;
}

# are we locked? (JIC :-)
if (-e "$LOCKFILE") {
    exit 0;
}

# ok lock us up
`touch $LOCKFILE`;

$ENV{DDNSHOME}=$DDNSHOME;
$ENV{DHCPD}=$DHCPD;
$ENV{UPDATE}=$UPDATE;
$ENV{DHCPD_TEMP}=$DHCPD_TEMP;
$ENV{DNS_DOMAIN}=$DOMAIN;

# call ddns.pl
$command="$DDNS\n";
`$command`;

# now call nsupdate to notify BIND
$command="$NSUPDATE $UPDATE\n";
`$command`;

# unlock the process
`rm $LOCKFILE`;


