/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_ACCOUNT_TYPES
#define INCLUDED_ACCOUNT_TYPES

#ifdef ACCOUNT_INTERNAL_ACCESS
typedef struct attribute_struct
{
    char const *              key;
    char const *              val;
    struct attribute_struct * next;
} t_attribute;
#endif


typedef struct account_struct
#ifdef ACCOUNT_INTERNAL_ACCESS
{
    t_attribute * attrs;
    unsigned int  namehash; /* cached from attrs */
    unsigned int  uid;      /* cached from attrs */
    int           dirty;    /* 1==needs to be saved, 0==clean */
    int           loaded;   /* 1==loaded, 0==only on disk */
    int           accessed; /* 1==yes, 0==no */
    unsigned int  age; /* number of times it has not been accessed */
    char const *  filename;
}
#endif
t_account;

#endif


#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_ACCOUNT_PROTOS
#define INCLUDED_ACCOUNT_PROTOS

#define JUST_NEED_TYPES
#include "list.h"
#undef JUST_NEED_TYPES

extern t_account * account_create(char const * username, char const * passhash1);
extern void account_destroy(t_account * account);
extern int account_match(t_account * account, char const * username);
extern int account_save(t_account * account, unsigned int delta);
extern char const * account_get_strattr(t_account * account, char const * key);
extern void account_unget_strattr(char const * val);
extern int account_set_strattr(t_account * account, char const * key, char const * val);

extern int accountlist_load_default(void);
extern int accountlist_load(void);
extern void accountlist_unload_default(void);
extern int accountlist_unload(void);
extern int accountlist_get_length(void);
extern int accountlist_save(unsigned int delta);
extern t_account * accountlist_find_account(char const * username);
extern t_account * accountlist_add_account(t_account * account);
extern t_account * accountlist_get_first(t_list const * const * * save);
extern t_account * accountlist_get_next(t_list const * const * * save);

#endif
#endif

#include "account_wrap.h"

