/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#include <glib.h>
#include <string.h>
#include <ctype.h>

#include "bezerk.h"
#include "message.h"
#include "util.h"
#include "reply.h"
#include "send.h"
#include "irc.h"
#include "ch_utils.h"
#include "debug.h"

extern GdkColor colour_white;
extern GdkColor colour_blue;
extern GdkColor colour_red;

int process_alias(Connection *connection, char *alias, char *comm_string, BezWindow *window)
{
  Message *message;
  GSList *args, *arg_entry;
  char *current, *comm_cpy, *alias_cpy;
  GString *result;
  int arg_num;

  bs_function_enter();

  comm_cpy = g_strdup(comm_string);
  args = split_args(comm_cpy);
  alias_cpy = g_strdup(alias);
  current = bs_strtok(alias_cpy, " \t");

  result = g_string_new ("");

  while (current) {
    if (*current == '$') {
      current++;
      if (!*current) {
	  continue;
      } else if (*current == '#') {
	if ( window && (window->type == BEZ_CHANNEL) && window->channel.current_channel) {
	  g_string_append(result, window->channel.current_channel->name);
	  g_string_append(result, " ");
	}
      } else if (!strncmp("me", current, 2)) {
	g_string_append(result, BEZ_BASE_WINDOW(window)->connection->nick);
	g_string_append(result, " ");
      } else if (isdigit(*current)) {
	arg_num = *current - '0';
	current++;
	if (isdigit(*current)) {
	  arg_num *= 10;
	  arg_num += *current - '0';
	  current++;
	}
	if (arg_num > 0) {
	  arg_entry = g_slist_nth(args, arg_num-1);
	  if (arg_entry) {
	    g_string_append(result, arg_entry->data);
	    g_string_append(result, " ");
	  }
	  if (*current == '-') {
	    arg_entry = g_slist_nth(args, arg_num);
	    while(arg_entry) {
	      g_string_append(result, arg_entry->data);
	      g_string_append(result, " ");
	      arg_entry = g_slist_nth(args, ++arg_num);
	    }
	    /*g_string_append(result, " ");*/
	  }
	} else if ( (arg_num == 0) && comm_string) {
	  g_string_append(result, comm_string);
	  g_string_append(result, " ");
	}
      }
    } else {
      g_string_append(result, current);
      g_string_append(result, " ");
    }
    current = bs_strtok(NULL, " \t");
  }

  g_free(comm_cpy);
  g_free(alias_cpy);
  comm_cpy = g_strdup(result->str);

  if (result->str[0] == '/') {
    send_issue_command(comm_cpy+1, window);
  } else if (window->type == BEZ_MESSAGE) {
    irc_send_format(connection->sd, "PRIVMSG %s :%s", window->message.nick, comm_cpy);
    message = message_new(MT_NICK, connection, window->message.nick);
    message->parts = g_slist_append(message->parts, 
				   message_part_new(&colour_blue, NULL, NULL, "<"));
    message->parts = g_slist_append(message->parts,
				   message_part_new(&colour_white,NULL, NULL,
						    BEZ_BASE_WINDOW(window)->connection->nick));
    message->parts = g_slist_append(message->parts,
				   message_part_new(&colour_blue, NULL, NULL, "> "));
    message->parts = message_part_parse_new(message->parts, &colour_white, comm_cpy);    
  
  } else if ( (window->type == BEZ_CHANNEL) && window->channel.current_channel) {
    irc_send_format(connection->sd, "PRIVMSG %s :%s", window->channel.current_channel->name, comm_cpy);
    message = message_new(MT_CHANNEL, connection, window->channel.current_channel->name);
    message->parts = g_slist_append(message->parts, 
				   message_part_new(&colour_blue, NULL, NULL, "<"));
    message->parts = g_slist_append(message->parts,
				   message_part_new(&colour_white,NULL, NULL,
						    BEZ_BASE_WINDOW(window)->connection->nick));
    message->parts = g_slist_append(message->parts,
				   message_part_new(&colour_blue, NULL, NULL, "> "));
    message->parts = message_part_parse_new(message->parts, &colour_white, comm_cpy);
  }

  g_free(comm_cpy);

  bs_function_leave();
  return(1);
}
