#ifndef __PROMLIB_H
#define __PROMLIB_H

#include <asm/openprom.h>
#include <stdarg.h>

enum arch { sun4, sun4c, sun4m, sun4d, sun4e, sun4u, sununknown };

extern struct linux_romvec *romvec;

int prom_getchild (int);
int prom_getsibling (int);
int prom_getproplen (int, char *);
int prom_getproperty (int, char *, char *, int);
int prom_getint (int, char *);
int prom_getintdefault (int, char *, int);
int prom_getbool (int, char *);
void prom_getstring (int, char *, char *, int);
int prom_nodematch (int, char *);
int prom_searchsiblings (int, char *);
char *prom_firstprop (int, char *);
char *prom_nextprop (int, char *, char *);
int prom_node_has_property (int, char *);
int prom_setprop (int, char *, char *, int);
void prom_adjust_regs (struct linux_prom_registers *, int,
		       struct linux_prom_ranges *, int);
void prom_adjust_ranges (struct linux_prom_ranges *, int,
		         struct linux_prom_ranges *, int);
void prom_apply_obio_ranges (struct linux_prom_registers *, int);
void prom_puts (char *, int);
void prom_putchar (char);
char prom_getchar (void);
int prom_nbputchar (char);
int prom_nbgetchar (void);
void prom_printf (char *, ...);
void printn (long n, int b);
int p1275_cmd (char *, int, ...);
#define printf prom_printf

enum prom_major_version { PROM_V0, PROM_V2, PROM_V3, PROM_P1275 };
extern enum prom_major_version prom_vers;
extern unsigned int prom_rev, prom_prev;
extern int prom_root_node;
extern int prom_stdin, prom_stdout;
extern int prom_chosen;
extern struct linux_nodeops *prom_nodeops;
#endif
