/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
** CATALOG.C - This is the ODBC sample driver code for
** executing Data Dictionary functions.
*/

#include "myodbc.h"

static MYSQL_ROW fix_fields_copy(STMT FAR *hstmt,MYSQL_ROW row);
static int check_parameters(SQLHSTMT hstmt,SQLCHAR FAR *szTableQualifier,
			    SQLSMALLINT cbTableQualifier,SQLCHAR FAR *szTableOwner,
			    SQLSMALLINT cbTableOwner,SQLCHAR FAR *szTableName,
			    SQLSMALLINT *cbTableName, char *table_name,
			    bool no_wildcards);

//  Have DBMS set up result set of Tables.

uint SQLTABLES_order[]={2};
char *SQLTABLES_values[]={"","",NULL,"TABLE","MySQL table"};
char *SQLTABLES_qualifier_values[]={"",NULL,NULL,NULL,NULL};
char *SQLTABLES_owner_values[]={NULL,"",NULL,NULL,NULL};
char *SQLTABLES_type_values[]={NULL,NULL,NULL,"TABLE",NULL};

MYSQL_FIELD SQLTABLES_fields[] = {
  {"Table_qualifer","Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_owner","Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_name","Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN,0},
  {"Table_type","Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,5,0},
  {"Remarks","Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,11}};

const uint SQLTABLES_FIELDS=array_elements(SQLTABLES_values);

/*
** This may be changed in the future so that TableQualifier or owner points
** at different databases.
*/

SQLRETURN SQL_API SQLTables(SQLHSTMT hstmt,
			    SQLCHAR FAR *szTableQualifier,SQLSMALLINT cbTableQualifier,
			    SQLCHAR FAR *szTableOwner,SQLSMALLINT cbTableOwner,
			    SQLCHAR FAR *szTableName,SQLSMALLINT cbTableName,
			    SQLCHAR FAR *szTableType,SQLSMALLINT cbTableType)
{
  char Qualifier_buff[NAME_LEN+1],Owner_buff[NAME_LEN+1],Name_buff[NAME_LEN+1],
       *type_buff,*TableQualifier,*TableOwner,*TableName,*TableType;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLTables");
  DBUG_PRINT("enter",("Qualifier: '%s'  Owner: '%s'  Table: '%s'  Type: '%s'",
		      szTableQualifier ? (char*) szTableQualifier : "null",
		      szTableOwner ? (char*) szTableOwner : "null",
		      szTableName ? (char*) szTableName : "null",
		      szTableType ? (char*) szTableType : "null"));

  my_SQLFreeStmt(hstmt,MYSQL_RESET);
  if (!(type_buff=my_malloc(szTableType && cbTableType != SQL_NTS ? cbTableType+1 : 1,MYF(0))))
  {
    DBUG_RETURN(set_error(stmt->dbc,"S1001","Not enough memory",4001));
  }

  TableQualifier=fix_str((char FAR *) Qualifier_buff,szTableQualifier,
			 cbTableQualifier);
  TableOwner=    fix_str((char FAR*) Owner_buff,szTableOwner,cbTableOwner);
  TableName=     fix_str((char FAR*) Name_buff,szTableName,cbTableName);
  TableType=     fix_str((char FAR*) type_buff,szTableType,cbTableType);

  if (!strcmp(TableQualifier,"%") && !TableOwner[0] && !TableName[0])
  {
    /* Return set of allowed qualifiers */
    DBUG_PRINT("info",("Return set of table qualifiers / Catalog names"));
    stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
    stmt->result_array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_qualifier_values,
				      sizeof(SQLTABLES_qualifier_values),
				      MYF(0));
    stmt->result->row_count=1;
    mysql_link_fields(stmt,SQLTABLES_fields, SQLTABLES_FIELDS);
    my_free(type_buff,MYF(0));
    DBUG_RETURN(SQL_SUCCESS);
  }

  if (!TableQualifier[0] && !strcmp(TableOwner,"%") && !TableName[0])
  {
    /* Return set of allowed Table owners */
    DBUG_PRINT("info",("Return set of table owners / Schema names"));
    stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
    stmt->result_array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_owner_values,
				      sizeof(SQLTABLES_owner_values),
				      MYF(0));
    stmt->result->row_count=1;
    mysql_link_fields(stmt,SQLTABLES_fields, SQLTABLES_FIELDS);
    my_free(type_buff,MYF(0));
    DBUG_RETURN(SQL_SUCCESS);
  }

  if (!TableQualifier[0] && !TableOwner[0] && !TableName[0] &&
      !strcmp(TableType,"%"))
  {
    /* Return set of TableType qualifiers */
    DBUG_PRINT("info",("Return set of table types"));
    stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
    stmt->result_array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_type_values,
				      sizeof(SQLTABLES_type_values),
				      MYF(0));
    stmt->result->row_count=1;
    mysql_link_fields(stmt,SQLTABLES_fields, SQLTABLES_FIELDS);
    my_free(type_buff,MYF(0));
    DBUG_RETURN(SQL_SUCCESS);
  }

  /* Return empty set if unknown TableType or if Qualifier or Owner is used */

  if ((TableType[0] && !strinstr(TableType,"TABLE")) ||
      TableQualifier[0] && strcmp(TableQualifier,"%") &&
      strcmp(TableQualifier,stmt->dbc->database) ||
      TableOwner[0] && strcmp(TableOwner,"%") &&
      strcmp(TableOwner,stmt->dbc->database))
  {
    DBUG_PRINT("info",("Can't match anything; Returning empty set"));
    stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
    stmt->result->row_count=0;
    stmt->result_array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_values,
				      sizeof(SQLTABLES_values), MYF(0));
    mysql_link_fields(stmt,SQLTABLES_fields, SQLTABLES_FIELDS);
    my_free(type_buff,MYF(0));
    DBUG_RETURN(SQL_SUCCESS);
  }

  /* This was a normal request for tables.  Return matching tables */

  if (!(stmt->result=mysql_list_tables(&stmt->dbc->mysql,TableName)))
  {
    my_free(type_buff,MYF(0));
    DBUG_RETURN(set_error(stmt->dbc,"S1000","Could not read table names",0));
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->order=       SQLTABLES_order;
  stmt->order_count= array_elements(SQLTABLES_order);
  stmt->fix_fields=  fix_fields_copy;
  stmt->array=(MYSQL_ROW) my_memdup((gptr) SQLTABLES_values,
				    sizeof(SQLTABLES_values),MYF(0));

  if (stmt->dbc->flag & FLAG_NO_CATALOG)
  {
    stmt->array[0]="user";
    stmt->array[1]="user";
  }
  mysql_link_fields(stmt,SQLTABLES_fields,5);
  my_free(type_buff,MYF(0));
  DBUG_RETURN(SQL_SUCCESS);
}


static MYSQL_ROW fix_fields_copy(STMT FAR *stmt,MYSQL_ROW row)
{
  uint i;
  for (i=0 ; i < stmt->order_count; i++)
    stmt->array[stmt->order[i]]=row[i];
  return stmt->array;
}


//  Have DBMS set up result set of Columns.

char SC_type[10],SC_typename[20],SC_precision[10],SC_length[10],SC_scale[10],
  SC_nullable[10];

char *SQLCOLUMNS_values[]={"","",NULL,NULL,SC_type,SC_typename,
			   SC_precision,
			   SC_length,SC_scale,"10",SC_nullable,"MySQL column"};

MYSQL_FIELD SQLCOLUMNS_fields[] = {
  {"Table_cat","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_schema","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_name","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Column_name","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Data_type","MySQL_Catalog",NULL,FIELD_TYPE_SHORT,5,5,NOT_NULL_FLAG},
  {"Type_name","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,20,20,NOT_NULL_FLAG},
  {"Column_size","MySQL_Catalog",NULL,FIELD_TYPE_LONG,11,11},
  {"Buffer_length","MySQL_Catalog",NULL,FIELD_TYPE_LONG,11,11},
  {"Decimal_digits","MySQL_Catalog",NULL,FIELD_TYPE_SHORT,2,2},
  {"Num_prec_radix","MySQL_Catalog",NULL,FIELD_TYPE_SHORT,2,2},
  {"Nullable","MySQL_Catalog",NULL,FIELD_TYPE_SHORT,5,5,NOT_NULL_FLAG},
  {"Remarks","MySQL_Catalog",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN}};

const uint SQLCOLUMNS_FIELDS=array_elements(SQLCOLUMNS_values);


SQLRETURN SQL_API SQLColumns(SQLHSTMT hstmt,
			     SQLCHAR FAR *szTableQualifier, SQLSMALLINT cbTableQualifier,
			     SQLCHAR FAR *szTableOwner, SQLSMALLINT cbTableOwner,
			     SQLCHAR FAR *szTableName, SQLSMALLINT cbTableName,
			     SQLCHAR FAR *szColumnName, SQLSMALLINT cbColumnName)
{
  char buff[80],table_name[NAME_LEN+1],column_name[NAME_LEN+1];
  ulong transfer_length,precision,display_size;
  MYSQL_FIELD *curField;
  char **row;
  MEM_ROOT *alloc;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLColumns");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    return SQL_ERROR;
  if (!(stmt->result=mysql_list_fields(&stmt->dbc->mysql,table_name,
				       fix_str(column_name,szColumnName,
					       cbColumnName))))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->result_array= (char**) my_malloc(sizeof(char*)*SQLCOLUMNS_FIELDS*
					 stmt->result->field_count,
					 MYF(MY_FAE | MY_ZEROFILL));

  /* convert mysql fields to data that odbc wants */
  alloc=&stmt->result->field_alloc;

  for (row= stmt->result_array ;
       (curField = mysql_fetch_field(stmt->result)) ; )
  {
    int type;
    row[0]="";                /* No qualifers */
    row[1]="";                /* No owner */
    row[2]= curField->table;
    row[3]= curField->name;
    curField->max_length=curField->length;
    type=unireg_to_sql_datatype(stmt,curField,buff,&transfer_length,&precision,&display_size);
    row[5]=strdup_root(alloc,buff);
    sprintf(buff,"%d",type);
    row[4]=strdup_root(alloc,buff);
    sprintf(buff,"%ld",precision);
    row[6]=strdup_root(alloc,buff);
    sprintf(buff,"%ld",transfer_length);
    row[7]=strdup_root(alloc,buff);
    if (IS_NUM(curField->type))
    {
      sprintf(buff,"%d",curField->decimals);
      row[8]=strdup_root(alloc,buff);		/* scale */
      row[9]="10";
    }
    else
    {
       row[8]=row[9]=NullS;
    }
    sprintf(buff,"%d",(curField->flags & (NOT_NULL_FLAG | AUTO_INCREMENT_FLAG)) == NOT_NULL_FLAG ?
            SQL_NO_NULLS : SQL_NULLABLE);
    row[10]=strdup_root(alloc,buff);
    row[11]="";
    row+=SQLCOLUMNS_FIELDS;
  }
  stmt->result->row_count=stmt->result->field_count;
  mysql_link_fields(stmt,SQLCOLUMNS_fields,SQLCOLUMNS_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}


/* Have DBMS set up result set of Statistics. */

char SS_type[10];
uint SQLSTAT_order[]={2,3,5,7,8,9,10};
char *SQLSTAT_values[]={NULL,NULL,"","",NULL,"",SS_type,"","","","",NULL,NULL};

MYSQL_FIELD SQLSTAT_fields[] = {
  {"Table_qualifer","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_owner","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_name","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Non_unique","MySQL_Stat",NULL,FIELD_TYPE_SHORT,1,1,NOT_NULL_FLAG},
  {"Index_qualifer","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Index_name","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN},
  {"Type","MySQL_Stat",NULL,FIELD_TYPE_SHORT,1,1,NOT_NULL_FLAG},
  {"Seq_in_index","MySQL_Stat",NULL,FIELD_TYPE_SHORT,1,2,NOT_NULL_FLAG},
  {"Column_name","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,NAME_LEN,NOT_NULL_FLAG},
  {"Coallation","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,1,1},
  {"Cardinality","MySQL_Stat",NULL,FIELD_TYPE_LONG,11,11},
  {"Pages","MySQL_Stat",NULL,FIELD_TYPE_LONG,9,9},
  {"Filter","MySQL_Stat",NULL,FIELD_TYPE_VAR_STRING,10,10},
};

const uint SQLSTAT_FIELDS=array_elements(SQLSTAT_fields);

SQLRETURN SQL_API SQLStatistics(SQLHSTMT hstmt,
			      SQLCHAR FAR *szTableQualifier,
			      SQLSMALLINT cbTableQualifier,
			      SQLCHAR FAR *szTableOwner,SQLSMALLINT cbTableOwner,
			      SQLCHAR FAR *szTableName,SQLSMALLINT cbTableName,
			      SQLUSMALLINT fUnique,SQLUSMALLINT fAccuracy)
{
  char buff[100],table_name[NAME_LEN+1];
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLStatistics");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);
  remove_escape(table_name);
  strxmov(buff,"show keys from ",table_name,NullS);
  if (check_if_server_is_alive(stmt->dbc) ||
      mysql_query(&stmt->dbc->mysql,buff) ||
      !(stmt->result=mysql_store_result(&stmt->dbc->mysql)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  int2str(SQL_INDEX_OTHER,SS_type,10);
  stmt->order=       SQLSTAT_order;
  stmt->order_count= array_elements(SQLSTAT_order);
  stmt->fix_fields=  fix_fields_copy;
  stmt->array=(MYSQL_ROW) my_memdup((gptr) SQLSTAT_values,
				    sizeof(SQLSTAT_values),MYF(0));
  if (fUnique == SQL_INDEX_UNIQUE)
  {					/* This is too low level... */
    MYSQL_ROWS **prev,*pos;
    prev= &stmt->result->data->data;
    for (pos= *prev ; pos ; pos=pos->next)
    {
      if (pos->data[1][0] == '0')	/* Unlink nonunique index */
      {
	(*prev)=pos;
	prev= &pos->next;
      }
      else
	stmt->result->row_count--;
    }
    (*prev)=0;
     mysql_data_seek(stmt->result,0);   /* Restore pointer */
  }
  mysql_link_fields(stmt,SQLSTAT_fields,SQLSTAT_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of TablePrivileges.

SQLRETURN SQL_API SQLTablePrivileges(SQLHSTMT hstmt,
				     SQLCHAR FAR *szTableQualifier,
				     SQLSMALLINT cbTableQualifier,
				     SQLCHAR FAR *szTableOwner,
				     SQLSMALLINT cbTableOwner,
				     SQLCHAR FAR *szTableName,
				     SQLSMALLINT cbTableName)
{
  DBUG_ENTER("SQLTablePrivileges");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"08002",
			"MyODBC doesn't support this yet",4000));
}


//  Have DBMS set up result set of ColumnPrivileges.

SQLRETURN SQL_API SQLColumnPrivileges(SQLHSTMT hstmt,
				      SQLCHAR FAR *szTableQualifier,
				      SQLSMALLINT cbTableQualifier,
				      SQLCHAR FAR *szTableOwner,
				      SQLSMALLINT cbTableOwner,
				      SQLCHAR FAR *szTableName,
				      SQLSMALLINT cbTableName,
				      SQLCHAR FAR *szColumnName,
				      SQLSMALLINT cbColumnName)
{
  DBUG_ENTER("SQLColumnPrivileges");
  DBUG_RETURN(set_error(((STMT FAR*) hstmt)->dbc,"IM001",
			"MyODBC doesn't support this yet",4000));
}


//  Have DBMS set up result set of SpecialColumns.


MYSQL_FIELD SQLSPECIALCOLUMNS_fields[] = {
  {"Scope","MySQL_SpecialColumns",NULL,FIELD_TYPE_SHORT,5,5,
   NOT_NULL_FLAG},
  {"Column_name","MySQL_SpecialColumns",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"Data_type","MySQL_SpecialColumns",NULL,FIELD_TYPE_SHORT,5,5,
   NOT_NULL_FLAG},
  {"Type_name","MySQL_SpecialColumns",NULL,FIELD_TYPE_VAR_STRING,20,20,
   NOT_NULL_FLAG},
  {"Precision","MySQL_SpecialColumns",NULL,FIELD_TYPE_LONG,7,7},
  {"Length","MySQL_SpecialColumns",NULL,FIELD_TYPE_LONG,7,7},
  {"Scale","MySQL_SpecialColumns",NULL,FIELD_TYPE_SHORT,3,3},
  {"Pseudo_column","MySQL_SpecialColumns",NULL,FIELD_TYPE_SHORT,3,3}
};

const uint SQLSPECIALCOLUMNS_FIELDS=array_elements(SQLSPECIALCOLUMNS_fields);


SQLRETURN SQL_API SQLSpecialColumns(SQLHSTMT hstmt,SQLUSMALLINT fColType,
				    SQLCHAR FAR *szTableQualifier,
				    SQLSMALLINT cbTableQualifier,
				    SQLCHAR FAR *szTableOwner,
				    SQLSMALLINT cbTableOwner,
				    SQLCHAR FAR *szTableName,
				    SQLSMALLINT cbTableName,
				    SQLUSMALLINT fScope,
				    SQLUSMALLINT fNullable)
{
  char buff[80],table_name[NAME_LEN+1];
  uint field_count;
  ulong transfer_length,precision,display_size;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  char **row;
  MEM_ROOT *alloc;
  bool primary_key;
  MYSQL_FIELD *field;
  DBUG_ENTER("SQLSpecialColumns");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);

  if (!(stmt->result=mysql_list_fields(&stmt->dbc->mysql,table_name,0)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    return(SQL_ERROR);
  }

  if (fColType == SQL_ROWVER)
  {						/* Find possible timestamp */
    stmt->result_array=
      (char**) my_malloc(sizeof(char*)*SQLSPECIALCOLUMNS_FIELDS*
			 stmt->result->field_count, MYF(MY_FAE | MY_ZEROFILL));
    /* convert mysql fields to data that odbc wants */
    alloc=&stmt->result->field_alloc;
    field_count=0;
    mysql_field_seek(stmt->result,0);
    for (row= stmt->result_array ;
         (field = mysql_fetch_field(stmt->result)) ;
         )
    {
      int type;
      if ((field->type != FIELD_TYPE_TIMESTAMP))
        continue;
      field_count++;
      sprintf(buff,"%d",SQL_SCOPE_SESSION);
      row[0]=strdup_root(alloc,buff);
      row[1]= field->name;
      type=unireg_to_sql_datatype(stmt,field,buff,&transfer_length,&precision,&display_size);
      row[3]=strdup_root(alloc,buff);
      sprintf(buff,"%d",type);
      row[2]=strdup_root(alloc,buff);
      sprintf(buff,"%d",precision);
      row[4]=strdup_root(alloc,buff);
      sprintf(buff,"%d",transfer_length);
      row[5]=strdup_root(alloc,buff);
      sprintf(buff,"%d",field->decimals);
      row[6]=strdup_root(alloc,buff);
      sprintf(buff,"%d",SQL_PC_NOT_PSEUDO);
      row[7]=strdup_root(alloc,buff);
      row+=SQLSPECIALCOLUMNS_FIELDS;
    }
    stmt->result->row_count=field_count;
    mysql_link_fields(stmt,SQLSPECIALCOLUMNS_fields,
		      SQLSPECIALCOLUMNS_FIELDS);
    DBUG_RETURN(SQL_SUCCESS);
  }

  if (fColType != SQL_BEST_ROWID)
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
    
  /*
   * The optimal set of columns for identifing a row is either
   * the primary key, or if there is no primary key, then
   * all the fields.
   */

  /* Check if there is a primary (unique) key */
  primary_key=0;
  while ((field = mysql_fetch_field(stmt->result)))
  {
    if (field->flags & PRI_KEY_FLAG)
    {
      primary_key=1;
      break;
    }
  }
  stmt->result_array=
    (char**) my_malloc(sizeof(char*)*SQLSPECIALCOLUMNS_FIELDS*
		       stmt->result->field_count, MYF(MY_FAE | MY_ZEROFILL));

  /* convert mysql fields to data that odbc wants */
  alloc=&stmt->result->field_alloc;
  field_count=0;
  mysql_field_seek(stmt->result,0);
  for (row= stmt->result_array ;
       (field = mysql_fetch_field(stmt->result)) ;
       )
  {
    int type;
    if (primary_key && !(field->flags & PRI_KEY_FLAG))
      continue;
#ifndef SQLSPECIALCOLUMNS_RETURN_ALL_COLUMNS
    /* The ODBC 'standard' doesn't want us to return all columns if there is
       no primary or unique key */
    if (!primary_key)
      continue;
#endif    
    field_count++;
    sprintf(buff,"%d",SQL_SCOPE_SESSION);
    row[0]=strdup_root(alloc,buff);
    row[1]= field->name;
    type=unireg_to_sql_datatype(stmt,field,buff,&transfer_length,&precision,
				&display_size);
    row[3]=strdup_root(alloc,buff);
    sprintf(buff,"%d",type);
    row[2]=strdup_root(alloc,buff);
    sprintf(buff,"%d",precision);
    row[4]=strdup_root(alloc,buff);
    sprintf(buff,"%d",transfer_length);
    row[5]=strdup_root(alloc,buff);
    sprintf(buff,"%d",field->decimals);
    row[6]=strdup_root(alloc,buff);
    sprintf(buff,"%d",SQL_PC_NOT_PSEUDO);
    row[7]=strdup_root(alloc,buff);
    row+=SQLSPECIALCOLUMNS_FIELDS;
  }
  stmt->result->row_count=field_count;
  mysql_link_fields(stmt,SQLSPECIALCOLUMNS_fields,
		    SQLSPECIALCOLUMNS_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of PrimaryKeys.

MYSQL_FIELD SQLPRIM_KEYS_fields[] = {
  {"Table_qualifer","MySQL_Primary_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_owner","MySQL_Primary_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"Table_name","MySQL_Primary_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN, NOT_NULL_FLAG},
  {"Column_name","MySQL_Primary_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN, NOT_NULL_FLAG},
  {"Key_seq","MySQL_Primary_keys",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Pk_name","MySQL_Primary_keys",NULL,FIELD_TYPE_VAR_STRING,128,0},
};

const uint SQLPRIM_KEYS_FIELDS=array_elements(SQLPRIM_KEYS_fields);

SQLRETURN SQL_API SQLPrimaryKeys(SQLHSTMT hstmt,
			       SQLCHAR FAR *szTableQualifier,
			       SQLSMALLINT cbTableQualifier,
			       SQLCHAR FAR *szTableOwner,SQLSMALLINT cbTableOwner,
			       SQLCHAR FAR *szTableName,SQLSMALLINT cbTableName)
{
  char buff[100],table_name[NAME_LEN+1],**data;
  STMT FAR *stmt=(STMT FAR*) hstmt;
  uint row_count;
  MYSQL_ROW row;
  DBUG_ENTER("SQLPrimaryKeys");

  if (check_parameters(hstmt,szTableQualifier,cbTableQualifier,szTableOwner,
		       cbTableOwner,szTableName,&cbTableName,table_name,1))
    DBUG_RETURN(SQL_ERROR);
  remove_escape(table_name);
  strxmov(buff,"show keys from ",table_name,NullS);
  if (check_if_server_is_alive(stmt->dbc) ||
      mysql_query(&stmt->dbc->mysql,buff) ||
      !(stmt->result=mysql_store_result(&stmt->dbc->mysql)))
  {
    strmov(stmt->dbc->sqlstate,"S1000");
    DBUG_RETURN(SQL_ERROR);
  }
  stmt->result_array= (char**) my_malloc(sizeof(char*)*SQLPRIM_KEYS_FIELDS*
					 (ulong) stmt->result->row_count,
					 MYF(MY_FAE | MY_ZEROFILL));
  row_count=0;
  data=stmt->result_array;
  while ((row = mysql_fetch_row(stmt->result)))
  {
    if (row[1][0] == '0')			/* If unique index */
    {
      if (row_count && !strcmp(row[3],"1"))
	break;					/* Allready found unique key */
      row_count++;
      data[0]=data[1]=0;
      data[2]=row[0];
      data[3]=row[4];
      data[4]=row[3];
      data[5]="PRIMARY";
      data+=SQLPRIM_KEYS_FIELDS;
    }
  }
  stmt->result->row_count=row_count;
  mysql_link_fields(stmt,SQLPRIM_KEYS_fields,SQLPRIM_KEYS_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}

/*
** Have DBMS set up result set of ForeignKeys.
** mysql dosen't have foreing key, return empty set
*/

MYSQL_FIELD SQLFORE_KEYS_fields[] = {
  {"Pktable_qualifer","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"PkTable_owner","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"PkTable_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"PkColumn_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"fktable_qualifier","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0,
   NOT_NULL_FLAG},
  {"fkTable_owner","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,0},
  {"fkTable_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"fkColumn_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,NAME_LEN,
   NAME_LEN,NOT_NULL_FLAG},
  {"Key_seq","MySQL_Foreign_keys",NULL,FIELD_TYPE_SHORT,2,2,NOT_NULL_FLAG},
  {"Update_rule","MySQL_Foreign_keys",NULL,FIELD_TYPE_SHORT,2,2},
  {"Delete_rule","MySQL_Foreign_keys",NULL,FIELD_TYPE_SHORT,2,2},
  {"Fk_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,128,0},
  {"Pk_name","MySQL_Foreign_keys",NULL,FIELD_TYPE_VAR_STRING,128,0},
};

const uint SQLFORE_KEYS_FIELDS=array_elements(SQLFORE_KEYS_fields);

SQLRETURN SQL_API SQLForeignKeys(SQLHSTMT hstmt,
			       SQLCHAR FAR *szPkTableQualifier,
			       SQLSMALLINT cbPkTableQualifier,
			       SQLCHAR FAR *szPkTableOwner,SQLSMALLINT cbPkTableOwner,
			       SQLCHAR FAR *szPkTableName,SQLSMALLINT cbPkTableName,
			       SQLCHAR FAR *szFkTableQualifier,
			       SQLSMALLINT cbFkTableQualifier,
			       SQLCHAR FAR *szFkTableOwner,SQLSMALLINT cbFkTableOwner,
			       SQLCHAR FAR *szFkTableName,SQLSMALLINT cbFkTableName)
{
  STMT FAR *stmt=(STMT FAR*) hstmt;
  DBUG_ENTER("SQLForeignKeys");

  my_SQLFreeStmt(hstmt,MYSQL_RESET);
  stmt->result=(MYSQL_RES*) my_malloc(sizeof(MYSQL_RES),MYF(MY_ZEROFILL));
  stmt->result->eof=1;
  mysql_link_fields(stmt,SQLFORE_KEYS_fields,SQLFORE_KEYS_FIELDS);
  DBUG_RETURN(SQL_SUCCESS);
}


//  Have DBMS set up result set of Procedures.

SQLRETURN SQL_API SQLProcedures(SQLHSTMT hstmt,
			      SQLCHAR FAR *szProcQualifier,SQLSMALLINT cbProcQualifier,
			      SQLCHAR FAR *szProcOwner,SQLSMALLINT cbProcOwner,
			      SQLCHAR FAR *szProcName,SQLSMALLINT cbProcName)
{
  return set_error(((STMT FAR*)hstmt)->dbc,"08002",
		   "MyODBC doesn't support this yet",4000);
}


//  Have DBMS set up result set of ProcedureColumns.

SQLRETURN SQL_API SQLProcedureColumns(SQLHSTMT hstmt,
				    SQLCHAR FAR *szProcQualifier,
				    SQLSMALLINT cbProcQualifier,
				    SQLCHAR FAR *szProcOwner,SQLSMALLINT cbProcOwner,
				    SQLCHAR FAR *szProcName,SQLSMALLINT cbProcName,
				    SQLCHAR FAR *szColumnName,SQLSMALLINT cbColumnName)
{
  return set_error(((STMT FAR*)hstmt)->dbc,"08002",
		   "MyODBC doesn't support this yet",4000);
}


static int check_parameters(SQLHSTMT hstmt,SQLCHAR FAR *szTableQualifier,
			    SQLSMALLINT cbTableQualifier,SQLCHAR FAR *szTableOwner,
			    SQLSMALLINT cbTableOwner, SQLCHAR FAR *szTableName,
			    SQLSMALLINT *cbTableName,
			    char *table_name,bool no_wildcards)
{
#ifdef NOT_NEEDED
  {
    char buff[128],*res;
    if ((szTableQualifier &&
         strcmp(res=fix_str(buff,szTableQualifier,cbTableQualifier),"%") &&
         res[0]) ||
        (szTableOwner && strcmp(res=fix_str(buff,szTableOwner,cbTableOwner),"%") &&
         res[0]))
    {
      DBUG_PRINT("error",("szTableQualifier: '%s'  szTableOwner: '%s'  res: '%s'",
			   szTableQualifier,szTableOwner,res));
      return set_error(((STMT FAR*) hstmt)->dbc,
  		       "S1C00","Can't use tablequalifer or owners",0);
    }
  }
#endif
  /* Check table name and copy it to table_name */
  if (!szTableName)
  {
    szTableName="";
    *cbTableName=0;
  }
  if (*cbTableName == SQL_NTS)
    *cbTableName=strlen(szTableName);
  if ((uint) *cbTableName > NAME_LEN)
    return set_error(((STMT FAR*) hstmt)->dbc,"SC1090","Invalid table name",0);
  strmake(table_name,szTableName,*cbTableName);
  if (no_wildcards && (!table_name[0] || strchr(table_name,'%')))
    return(set_error(((STMT FAR*) hstmt)->dbc,"S1C00",
		     "Can't use wildcards in table name",0));
  my_SQLFreeStmt(hstmt,MYSQL_RESET);
  return 0;
}
