/* This file is part of Malaga, a system for Natural Language Analysis.
 * Copyright (C) 1995-1999 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* description ==============================================================*/

/* This module defines a Malaga library to analyse words and sentences. */

/* types ====================================================================*/

#ifndef ANALYSIS
#define ANALYSIS
typedef enum {MORPHOLOGY, SYNTAX} grammar_t; /* types of grammatic analysis */

typedef enum {BREAK_NODE, FINAL_NODE, 
	      INTER_NODE, PRUNED_NODE} tree_node_type_t;

typedef struct /* a node of the analysis tree */
{
  int_t index; /* index of this analysis tree node */
  tree_node_type_t type;
  int_t mother_index; /* -1 or index of mother analysis tree node */
  string_t rule_name; /* NULL or name of the rule that created result */
  string_t right_surf; /* NULL or right surface */
  value_t right_cat; /* NULL or right cat */
  string_t result_surf; /* result surface */
  value_t result_cat; /* NULL or result cat */
  string_t rule_set; /* NULL or successor rules */
} analysis_node_t;
#endif

/* variables ================================================================*/

string_t malaga_error; 
/* If one of the functions below has created an error, this variable
 * contains an error message. If a function did its job, it is NULL. */

/* functions ================================================================*/

extern void init_libmalaga (string_t project_file);
/* Initialise this module. */

extern void terminate_libmalaga (void);
/* Terminate this module. */

extern void set_option (string_t option);
/* Set a libmalaga option. */

extern string_t get_info (grammar_t grammar);
/* Return information about <grammar>. */

extern bool_t analyse_item (string_t item, grammar_t grammar, 
			    bool_t build_tree);
/* Analyse <item> according to <grammar>.
 * <grammar> must be MORPHOLOGY or SYNTAX.
 * If <build_tree> == TRUE, create an analysis tree.
 * Return TRUE if there is at least one analysis result. */

extern value_t next_analysis_result (void);
/* Get the next result of the last call of "analyse_item".
 * Return NULL if there is no more result. */

extern analysis_node_t *next_analysis_node (void);
/* Get the next analysis tree node of the last call of "analyse_item".
 * Return NULL if there is no more node. 
 * The analysis node is valid until this function is called again. */

/* end of file ==============================================================*/
