/*  NCatalog , the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "data.h"


/*utilise lorsque un disque est ajout a la liste*/
void init_folder( Folder *folder, Folder *parent, char *name,unsigned long int taille, unsigned long int date,char style)
{

  folder->name = (char *)malloc((strlen(name)+1)*sizeof(char));
  strcpy(folder->name,name);
  folder->taille = taille;

  folder->taille = folder->taille & size_mask;
  folder->type = style;
  folder->information = NULL;
  folder->date = date;
  folder->categorie = 0;
  folder->description = 0;
  folder->nb_folders = 0;
  folder->nb_files = 0;
  folder->folders = NULL;
  folder->files = NULL;
  folder->parent = parent;
} 


/*utilise au moment ou on charge un catalogue depuis un fichier */
void add_folder( Folder *folder, Folder *parent, char *name,char *information,unsigned char type,unsigned long int taille, unsigned long int date,  unsigned char categorie, unsigned short int description)
{ 
  folder->name = (char *)malloc((strlen(name)+1)*sizeof(char));
  strcpy(folder->name,name);
  folder->name[strlen(name)] = '\0';
  if((information != NULL)&&(strlen(information) != 0))
    {
      folder->information = (char *)malloc((strlen(information)+1)*sizeof(char));
      strcpy(folder->information,information);
      folder->information[strlen(information)] = '\0';
    }
  else 
    {
      folder->information = (char *) malloc(sizeof(char));
      folder->information[0] = '\0';
    }
  folder->taille = taille;
  folder->type = type & 127;
  folder->date = date;
  folder->categorie = 0;
  folder->description = 0;
  folder->nb_folders = 0;
  folder->nb_files = 0;
  folder->folders = NULL;
  folder->files = NULL;
  folder->parent = parent;
  folder->categorie = categorie;
  folder->description = description;

} 


void change_name(Folder *folder,char *name)
{
  folder->name=(char *)realloc(folder->name, (strlen(name)+1)*sizeof(char));
  strcpy(folder->name,name);
}


/* traitement des infos sur la date, la taille et le type. */

char *get_time(unsigned long nb_sec)
{
  struct tm *time;

  time = localtime(&nb_sec);
  sprintf(date,"%d/%d/%d %d:%d:%d\n",1900 + time->tm_year,time->tm_mon + 1,time->tm_mday,time->tm_hour,time->tm_min,time->tm_sec);       
  return(date);
}


char *get_size(unsigned long nb_octs)
{
  sprintf(taille,"%lu",nb_octs & size_mask);
  return(taille);
}

int get_type(unsigned long type_info)
{
  //int temp;

 // temp = type_info>>30;
 // return(temp);
  return(type_info);
}

int is_file(Folder *folder)
{
  if (folder->type == 3) return(1);
  return(0);
}

int is_folder(Folder *folder)
{
  if (folder->type == 2) return(1);
  return(0);
}

int is_link(Folder *folder)
{
  if (folder->type == 4) return(1);
  return(0);
}



int is_disk(Folder *folder)
{
  if (folder->type == 1) return(1);
  return(0);
}




/* traitement de l'ajout, la supression de description ou catgorie */

int add_categorie(char *info)
{
  int i;
  if (strlen(info) == 0) return(0);
  for(i=1;i<nb_categories;i++)
    {
      if(strcmp(info,categories[i]) == 0) return(i);
    }
  nb_categories++;
  categories = (char **)realloc(categories,nb_categories*sizeof(char *));
  categories[nb_categories -1] = (char *)malloc((strlen(info) +1)*sizeof(char));
  strcpy(categories[nb_categories -1],info);
  return(nb_categories -1);
}


int add_description(char *info)
{
  int i;
  if (strlen(info) == 0) return(0);
  
  for(i=1;i<nb_descriptions;i++)
    {
      if(strcmp(info,descriptions[i]) == 0)
	{
	  return(i);
	}
    }
  nb_descriptions++;
  descriptions = (char **)realloc(descriptions,nb_descriptions*sizeof(char *));
  descriptions[nb_descriptions -1] = (char *)malloc((strlen(info) +1)*sizeof(char));
  strcpy(descriptions[nb_descriptions -1],info);
  return(nb_descriptions -1);
}



void update_description(int desc_nb,char *info)
{
  descriptions[desc_nb] = (char *)realloc(descriptions[desc_nb],(strlen(info) +1)*sizeof(char));
  strcpy(descriptions[desc_nb],info);
}



/* verifie que la description n'est pas deja utilise ailleur!*/
/* en ne testant pas les objets qui vont etre modifis */
int scan_description(Folder *foldchange, Folder* folder,unsigned short desc_nb,int recursive)
{
  int i;
  int a = 0;

  for(i=0;i<folder->nb_folders;i++)
    {  
      if((folder == foldchange)&&(recursive = 1))
	{
	  
	}
      else
	a = a + scan_description(foldchange,&folder->folders[i],desc_nb,recursive);
    }
  for(i=0;i<folder->nb_files;i++)
    {   
      if ((folder->files[i].description == desc_nb)&&(foldchange != &folder->files[i])) a++;
    }
  
   if((folder->description == desc_nb)&&(foldchange != folder)) return(1);
   else if (a != 0) return(1);
   else return(0);

}


/*fonction a appeler pour changer la description d'un folder */
int change_description(Folder *folder,unsigned short desc_nb,int recursive,char *info)
{
  int i;
  
  if ((desc_nb != 0)&&(scan_description(folder,&racine,desc_nb,recursive) != 0))
    {
      i =  add_description(info);
      return(i);
    }
  else if (desc_nb == 0)
    {
      i = add_description(info);
      return(i);
    }
  else
    {
      update_description(desc_nb,info);
      return(desc_nb);
    }
}
