/*  NCatalog, the GTKtalog ncurses GUI.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <fnmatch.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <curses.h>

#include "data.h"
#include "loadcat.h"
#include "search.h"
#include "console_search.h"

search_info *search_files;
int cat_search; //contient le numero de la categories recherche! -1 si toutes!
int nb_search_desc;
int *search_descs;



int nb_files;
int nb_folders;


void take_desc_tab(int sensitive, char *temp)
{
  int i;
  
  nb_search_desc = -1;

  if (strlen(temp) == 0)
    {
      search_descs = (int *)malloc(sizeof(int));
      search_descs[0] = 0;
      nb_search_desc = 1;
      return;
    }
  if ((strcmp(temp,"*") == 0)&&(strlen(temp) == 1))
    {
      nb_search_desc = -1;
      return;
    }
  for (i=0;i<nb_descriptions;i++)
    {
      if (((sensitive!=1)&&(fnmatch(temp,descriptions[i],(1 << 4)) == 0))||((sensitive==1)&&(fnmatch(temp,descriptions[i],0) == 0)))
	{
	  if (nb_search_desc < 1)
	    {
	      search_descs = (int *)malloc(sizeof(int));
	      search_descs[0] = i;
	      nb_search_desc = 1;
	    }  
	  else 
	    {
	      search_descs = (int *)realloc(search_descs,(nb_search_desc)*sizeof(int));  
	      search_descs[nb_search_desc] = i;
	      nb_search_desc++;
	    }
	}
    }
}


void affiche_string(int i, int j, char *data)
{
  int k;

  if (i+strlen(data) > 79)
    {
      for(k=i;k<80;k++)
	{
	   mvaddch(j,k,data[k-i]);
	}
    }
  else
    {
      for(k=0;k<strlen(data);k++)
	{
	   mvaddch(j,k+i,data[k]);
	}
    }
}


int start_search(char *name_info,char *desc_info,char *info_info,int cat_info)
{
  int i;
  char cur_path[]="/";
  char tmp[3];
  int case_sensitive;
 
  if(first_search == 0)
    {
      for(i=0;i<nb_files;i++)
	{
	  search_files[i].folder = NULL;
	}
      free(search_files);
      search_files = NULL;
    
    }
  
  first_search = 0;
  nb_files = 0;

  case_sensitive = 0; //pas de case sensitive
  take_desc_tab(case_sensitive,tmp);//creer la liste des valeur des description valide
  cat_search = cat_info;

  if(search_files != NULL) free(search_files);
  search_files = NULL;
  search_files = (search_info *)malloc(sizeof(search_info));


  if (racine.nb_folders > 0)
    {
      for(i=0;i<racine.nb_folders;i++)
	{
	  console_search_in_data(&racine.folders[i], name_info, info_info,1 /*in_filename*/,1 /*in_foldername*/,case_sensitive,racine.folders[i].name, cur_path);
	}
    }
  return 1;
}



int test_file(char *filename, char *dataname,int sensitive)
{
  int i;
  
  if (sensitive == 0)
    {
      i = fnmatch(filename,dataname, (1 << 4)/* FNM_CASEFOLD*/);
      return(i);
    }
  else 
    {
      i = fnmatch(filename,dataname,0);
      return(i);
    }
}

int test_desc(int desc)
{
  int i;

  if (nb_search_desc == -1) return(1);
  else
    {
      for(i=0;i<nb_search_desc;i++)
	{
	  if (search_descs[i] == desc) return(1);
	}
    }
  return(0);
}



int test_cat(int cat)
{
  if (cat_search == -1) return(1);
  else if (cat_search == cat)return(1);
  return(0);
}




void console_search_in_data(Folder *folder, char *filename,char *infostring, int in_file, int in_folder, int sensitive, char *cur_disk, char *cur_path)
{
  char *path;
  int i;


  if (is_disk(folder) == 0)
    {
      path = (char *)malloc((strlen(cur_path)+strlen(folder->name)+2)*sizeof(char));
      sprintf(path,"%s%s/",cur_path,folder->name);
     /* path = g_strconcat(cur_path,folder->name,NULL);
      path = g_strconcat(path,"/",NULL);*/
    }
  else
    {
      path = (char *)malloc((strlen(cur_path)+1)*sizeof(char)); 
      strcpy(path,cur_path);
    }
  if ((in_folder == 1)&& (test_file(filename, folder->name, sensitive) == 0)&&(test_cat(folder->categorie) == 1)&&(test_desc(folder->description) == 1)&&
      ((folder->information != NULL)&&(test_file(infostring, folder->information, sensitive) == 0)))
    {
      search_files = (search_info *)realloc(search_files,(nb_files +1)*sizeof(search_info));
      search_files[nb_files].data = (char *) malloc((strlen(path)+strlen(cur_disk)+7)*sizeof(char));
      sprintf(search_files[nb_files].data,"[%s]->%s",cur_disk,path);
      search_files[nb_files].val = 0;
      search_files[nb_files].folder = folder;
      fflush(stdout);
      
      nb_files++;
      nb_folders++;
    }
  if ((folder->nb_files > 0)&&(in_file == 1))
    {
      for(i=0;i<folder->nb_files;i++)
	{
	  if((test_file(filename, folder->files[i].name, sensitive) == 0)&&(test_cat(folder->files[i].categorie) == 1)&&(test_desc(folder->files[i].description) == 1&&((folder->files[i].information != NULL)&&(test_file(infostring, folder->files[i].information, sensitive) == 0))))
	    {
	      search_files = (search_info *)realloc(search_files,(nb_files +1)*sizeof(search_info));
	      search_files[nb_files].data = (char *) malloc((strlen(path)+strlen(cur_disk)+7)*sizeof(char));
	      sprintf(search_files[nb_files].data,"[%s]->%s",cur_disk,path);
	      search_files[nb_files].val = 0;
	      search_files[nb_files].folder = &folder->files[i];
	   
	      nb_files++;  
	    }
	}
    }
  if (folder->nb_folders > 0)
    {
      for(i=0;i<folder->nb_folders;i++)
	{
	  console_search_in_data(&folder->folders[i], filename,infostring, in_file, in_folder, sensitive, cur_disk, path);
	}
    }
}
