/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  A big part of the source code in this file come from:
 *  x11amp - graphically mp3 player..
 *  Copyright (C) 1998-1999  Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

#include "addisk.h"
#include "images.h"
#include "icons.h"
#include "erreur.h"
#include "selectdir.h"
#include "data.h"
#include "edit.h"


GtkWidget *entry;
GtkWidget *seldir_path_entry;

typedef struct
{
  gboolean scanned;
  gchar *path;
  Folder *folder;
} DirNode;



static gboolean check_for_subdir(gchar *path)
{
	DIR *dir;
	struct dirent *dirent;
	struct stat statbuf;
	gchar *npath;
	
	if((dir=opendir(path))!=NULL)
	{
		while((dirent=readdir(dir))!=NULL)
		{
			if(dirent->d_name[0]!='.')
			{
				npath=g_strconcat(path,dirent->d_name,"/",NULL);
				stat(npath,&statbuf);
				g_free(npath);
				if(S_ISDIR(statbuf.st_mode))
				{
					closedir(dir);
					return TRUE;
				}
			}
		}
		closedir(dir);
	}
	return FALSE;
}


static void destroy_cb(gpointer data)
{
	DirNode *node=data;
	g_free(node->path);
	g_free(node);
}

static void expand_cb(GtkWidget *widget,GtkCTreeNode *parent_node)
{
	DIR *dir;
	struct dirent *dirent;
	gchar *path,*text,*dummy="dummy";
	struct stat statbuf;
	GtkCTreeNode *node,*sub_node;
	DirNode *parent_dirnode,*dirnode;
	gboolean has_subdir=FALSE;

	
	parent_dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),parent_node);
	if(!parent_dirnode->scanned)
	{
		gtk_clist_freeze(GTK_CLIST(widget));
		node=gtk_ctree_find_by_row_data(GTK_CTREE(widget),parent_node,NULL);
		gtk_ctree_remove_node(GTK_CTREE(widget),node);
		if((dir=opendir(parent_dirnode->path))!=NULL)
		{
			while((dirent=readdir(dir))!=NULL)
			{
				path=g_strconcat(parent_dirnode->path,dirent->d_name,NULL);
				stat(path,&statbuf);
				if(S_ISDIR(statbuf.st_mode)&&dirent->d_name[0]!='.')
				{
					dirnode=g_malloc0(sizeof(DirNode));
					dirnode->path=g_strconcat(path,"/",NULL);
					text=dirent->d_name;
					if(check_for_subdir(dirnode->path))
						has_subdir=TRUE;
					else
						has_subdir=FALSE;
					node=gtk_ctree_insert_node(GTK_CTREE(widget),parent_node,NULL,&text,4,folder_pixmap,folder_mask,ofolder_pixmap,ofolder_mask,!has_subdir,FALSE);
					gtk_ctree_node_set_row_data_full(GTK_CTREE(widget),node,dirnode,destroy_cb);
					if(has_subdir)
						sub_node=gtk_ctree_insert_node(GTK_CTREE(widget),node,NULL,&dummy,4,NULL,NULL,NULL,NULL,FALSE,FALSE);
				}
				g_free(path);
			}
			closedir(dir);
			gtk_ctree_sort_node(GTK_CTREE(widget),parent_node);
		}
		gtk_clist_thaw(GTK_CLIST(widget));	
		parent_dirnode->scanned=TRUE;
	}
}


static void ok_clicked(GtkWidget *widget,GtkWidget *dir_tree)
{
  GtkCTreeNode *dir_node;
  DirNode *dirnode;
  GList *list_node;
  GtkWidget *window;
  void (*handler)(gchar *);
  gchar *temp;
  
  list_node = GTK_CLIST(dir_tree)->selection;
  while(list_node)
    {
      dir_node=list_node->data;
      dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(dir_tree),dir_node);
      handler=(void (*)(gchar *))gtk_object_get_user_data(GTK_OBJECT(dir_tree));
      list_node = g_list_next(list_node);
    }
  window = gtk_object_get_user_data(GTK_OBJECT(widget));
  
  if (strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"") == 0)
    {
      erreur_dialog(widget, "You have to write","the disk label","Error!");
      return;
    }
  else
    {
      if (folder_exist_in(&racine,gtk_entry_get_text(GTK_ENTRY(entry)), dir_tree) == 1) return; 
    }
  if (strcmp(gtk_entry_get_text(GTK_ENTRY(seldir_path_entry)),"") == 0)
    {
      erreur_dialog(widget, "You have to set","the disk location","Error!");
      return;
    }
 
  dirnode->path[strlen(dirnode->path)-1] = '\0';
  temp = gtk_entry_get_text(GTK_ENTRY(seldir_path_entry));
  disk_path = g_strdup(temp);
//  add_disk_from_folder(dirnode->path, gtk_entry_get_text(GTK_ENTRY(entry)), &racine); 
  start_add_disk(disk_path, gtk_entry_get_text(GTK_ENTRY(entry)));
  gtk_widget_destroy(window);
  is_modified = 1;
}



static void cb_signal(GtkWidget *widget,GtkCTreeNode *node,gint z)
{
  DirNode *dirnode;

  dirnode=gtk_ctree_node_get_row_data(GTK_CTREE(widget),node);
  gtk_entry_set_text (GTK_ENTRY (seldir_path_entry), dirnode->path);

}



void show_select_dir_win()
{
  
  GtkWidget *dir_tree,*window,*scroll_win,*vbox,*bbox,*ok,*cancel;
  gchar *root_text="/",*node_text="dummy";
  GtkCTreeNode *root_node,*node;
  DirNode *dirnode;
  GtkWidget *frame;

  void (*handler)(gchar *);
  
  window=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window),"Select Disk location");
  gtk_container_border_width(GTK_CONTAINER(window),10);
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);

  vbox=gtk_vbox_new(FALSE,10);
  gtk_container_add(GTK_CONTAINER(window),vbox);
  
  scroll_win=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_win),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scroll_win,250,200);
  gtk_box_pack_start(GTK_BOX(vbox),scroll_win,TRUE,TRUE,0);
  gtk_widget_show(scroll_win);
  
  gtk_widget_realize(window);
 

 if(!folder_pixmap)
    {
      folder_pixmap=gdk_pixmap_create_from_xpm_d((GdkWindow*) window->window,&folder_mask,NULL,folder_xpm);
      ofolder_pixmap=gdk_pixmap_create_from_xpm_d(window->window,&ofolder_mask,NULL,ofolder_xpm);
    }
 
  
  dir_tree=gtk_ctree_new(1,0);
  gtk_clist_set_column_auto_resize(GTK_CLIST(dir_tree),0,TRUE);
  gtk_clist_set_selection_mode(GTK_CLIST(dir_tree),GTK_SELECTION_SINGLE);
  gtk_ctree_set_line_style(GTK_CTREE(dir_tree),GTK_CTREE_LINES_DOTTED);
  gtk_signal_connect(GTK_OBJECT(dir_tree),"tree_expand",GTK_SIGNAL_FUNC(expand_cb),NULL);
  gtk_signal_connect (GTK_OBJECT(dir_tree), "tree_select_row",GTK_SIGNAL_FUNC(cb_signal), NULL);
  gtk_container_add(GTK_CONTAINER(scroll_win),dir_tree);
  gtk_object_set_user_data(GTK_OBJECT(dir_tree),(gpointer)handler);
  
  root_node=gtk_ctree_insert_node(GTK_CTREE(dir_tree),NULL,NULL,&root_text,4,folder_pixmap,folder_mask,ofolder_pixmap,ofolder_mask,FALSE,FALSE);
  dirnode=g_malloc0(sizeof(DirNode));
  dirnode->path=g_strdup("/");
  gtk_ctree_node_set_row_data_full(GTK_CTREE(dir_tree),root_node,dirnode,destroy_cb);
  node=gtk_ctree_insert_node(GTK_CTREE(dir_tree),root_node,NULL,&node_text,4,NULL,NULL,NULL,NULL,TRUE,TRUE);
  gtk_ctree_expand(GTK_CTREE(dir_tree),root_node);
  gtk_widget_show(dir_tree);


  seldir_path_entry = gtk_entry_new_with_max_length (50);
  gtk_box_pack_start (GTK_BOX (vbox), seldir_path_entry, FALSE, TRUE, 0);
  gtk_widget_show (seldir_path_entry);

  
  frame = gtk_frame_new ("Disk Label");
 
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, TRUE, 0);
  gtk_widget_show (frame);
  
  entry = gtk_entry_new_with_max_length (50);
  gtk_entry_set_text (GTK_ENTRY (entry), "");
  gtk_entry_select_region (GTK_ENTRY (entry),
			   0, GTK_ENTRY(entry)->text_length);
  gtk_container_add (GTK_CONTAINER (frame), entry);
  gtk_widget_show (entry);
  
  
  bbox=gtk_hbutton_box_new();
  gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox),GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox),5);
 
  ok=gtk_button_new_with_label("Ok");
  gtk_object_set_user_data(GTK_OBJECT(ok),window);
  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
  gtk_window_set_default(GTK_WINDOW(window),ok);
  gtk_box_pack_start(GTK_BOX(bbox),ok,TRUE,TRUE,0);
  gtk_signal_connect(GTK_OBJECT(ok),"clicked",GTK_SIGNAL_FUNC(ok_clicked),dir_tree);
  gtk_widget_show(ok);
  
  cancel=gtk_button_new_with_label("Cancel");
  GTK_WIDGET_SET_FLAGS(cancel,GTK_CAN_DEFAULT);
  gtk_box_pack_start(GTK_BOX(bbox),cancel,TRUE,TRUE,0);
  gtk_signal_connect_object(GTK_OBJECT(cancel),"clicked",GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(window));
  gtk_widget_show(cancel);
  
  gtk_box_pack_start(GTK_BOX(vbox),bbox,FALSE,FALSE,0);
  gtk_widget_show(bbox);
  gtk_widget_show(vbox);
  
  gtk_widget_show(window);
  
  gtk_ctree_select(GTK_CTREE(dir_tree),root_node);

  gtk_entry_set_text (GTK_ENTRY (seldir_path_entry), disk_path);
}

