/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

#define LIMIT(x) (((x)<0)?0:((x)>255)?255:(x))

int main() {

  int y, cr, cb, r, g, b, h, v, i, j, res, n = 0 ; FILE *file ;
  unsigned char rgb[3], buf[9], name[13] ; struct stat st ;
  int *rp, *gp, *bp, N=0, ptr ;

  rp = calloc(768*576,sizeof(int)) ;
  gp = calloc(768*576,sizeof(int)) ;
  bp = calloc(768*576,sizeof(int)) ;

  while ( fread(buf,1,8,stdin) == 8 ) {

    res = sscanf(buf,"%3d %3d\n",&h,&v) ; ptr = 0 ; N++ ;
    fprintf(stderr,"yuvsum: %dx%d image #%d\n",h,v,N) ;

    for ( i=0 ; i<v ; i++ ) for ( j=0 ; j<h ; j+=2 ) {

	if (!fread(buf,4,1,stdin)) break ;
	cb = buf[1] - 128 ; cr = buf[3] - 128 ;

	y = buf[0] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	*(rp+ptr) += LIMIT(r) ; *(gp+ptr) += LIMIT(g) ; *(bp+ptr) += LIMIT(b) ;
        ptr++ ;

	y = buf[2] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	*(rp+ptr) += LIMIT(r) ; *(gp+ptr) += LIMIT(g) ; *(bp+ptr) += LIMIT(b) ;
        ptr++ ; } }

  while (1) {
    snprintf(name,sizeof(name),"tv%06d.ppm",++n) ;
    if (lstat(name,&st)) break ; }

  file = fopen(name,"w") ;
  if (!file) { perror("fopen() failed") ; exit(0) ; }
  fprintf(stderr,"yuvsum: %d images: %s\n",N,name) ;

  fprintf(file,"P6\n%d %d\n255\n",h,v) ; ptr = 0 ;
  for ( i=0 ; i<v ; i++ ) for ( j=0 ; j<h ; j++ ) {
    rgb[0] = *(rp+ptr)/N ; rgb[1] = *(gp+ptr)/N ; rgb[2] = *(bp+ptr)/N ;
    fwrite(rgb,3,1,file) ; ptr++ ; }

  fclose(file) ; return(0) ; }
