

#ifndef __processing_h__
#define __processing_h__

#include "triagetypes.h"
#include "texture2d.h"
#include "pixels.h"

CTexture2d* DepthToColor(CTexture2d& aSource,PlatInt aMinDepth, PlatInt aMaxDepth);

void SobelFilterLines(CTexture2d& aTarget,CTexture2d& aSource);

CTexture2d* CombinePixels(CTexture2d& aSource,PlatInt aBits);


/** Quantize :
 * all values above n0 but lower than n1 should be mapped to n0.
 */
template<class T>
    inline void Quantize(CTexture2d& aTexture,
                         PlatUInt aLow, PlatUInt aHigh,
                         T& aMapper)
{
    PlatInt i;
    PlatInt nr = aTexture.NrItems();
    for (i=0;i<nr;i++)
    {
        PlatPixel original = aTexture[i];
        PlatUInt value = aMapper.Get(original);
        if (value>=aLow && value <aHigh)
        {
            value = aLow;
            aTexture[i] = aMapper.Convert(original,value);
        }
    }
}

/* Classes that can be used for qualtizing. */

class QuantizeDepth
{
public:
    inline PlatUInt Get(PlatPixel aPixel)
    {
        return aPixel;
    };
    inline PlatPixel Convert(PlatPixel aPixel,PlatUInt aValue)
    {
        return aValue;
    };
};


class QuantizeRed
{
public:
    inline PlatUInt Get(PlatPixel aPixel)
    {
        return Red(aPixel);
    };
    inline PlatPixel Convert(PlatPixel aPixel,PlatUInt aValue)
    {
        return Pixel(aValue,Green(aPixel),Blue(aPixel),Alpha(aPixel));
    };
};

class QuantizeGreen
{
public:
    inline PlatUInt Get(PlatPixel aPixel)
    {
        return Green(aPixel);
    };
    inline PlatPixel Convert(PlatPixel aPixel,PlatUInt aValue)
    {
        return Pixel(Red(aPixel),aValue,Blue(aPixel),Alpha(aPixel));
    };
};
class QuantizeBlue
{
public:
    inline PlatUInt Get(PlatPixel aPixel)
    {
        return Blue(aPixel);
    };
    inline PlatPixel Convert(PlatPixel aPixel,PlatUInt aValue)
    {
        return Pixel(Red(aPixel),Green(aPixel),aValue,Alpha(aPixel));
    };
};

#endif
