
/* example4 : Show off some post processing to perform an implicit
 * plot of a 2d function.
 */


// examples4.cpp materials.h geometry.h
//
// CTriage constructor: iRenderFlags not reset.


#include <stdio.h>
#include "triage.h"

#include "render.h"
#include "inliners.h"
#include "pixels.h"
#include "targagrabber.h"
#include "matrix.h"
#include "processing.h"
#include "geometry.h"
#include "materials.h"

#define NSTEPS 64

#define WIDTH  640
#define HEIGHT 480

CTexture2d texture(WIDTH,HEIGHT);
CTexture2d depth(WIDTH,HEIGHT);
CTriage    triage(texture,depth);

//PlatPixel const red   = Pixel(255,0,0,255);
//PlatPixel const black = Pixel(0,0,0,255);
//#define red   0xff0000ff
//#define green 0xff00ff00
//#define black 0xff000000


template<PlatInt weight>
class CWeight
{
public:
    CWeight(CTriage& aTriage) :iTriage(aTriage) {};
    inline PlatInt Weight(CVector& aPos, CVector& aNormal) const
    {
        return weight;
    };
private:
    CTriage& iTriage;
};


template<PlatInt len>
class CCosineY
{
public:
    CCosineY(CTriage& aTriage) :iTriage(aTriage) {};
    inline PlatInt Weight(CVector& aPos, CVector& aNormal) const
    {
      PlatInt angle = (PlatInt)(FixedMul(aPos.xf[1],len)/64.0);
      Fixed oscillate = (FixedOne+iTriage.Trig().Cos(angle));
      return FixedToWeight(FixedMul(FixedHalf,oscillate));
    };
private:
    CTriage& iTriage;
};

template<PlatInt len>
class CCosineZ
{
public:
    CCosineZ(CTriage& aTriage) :iTriage(aTriage) {};
    inline PlatInt Weight(CVector& aPos, CVector& aNormal) const
    {
      PlatInt angle = (PlatInt)(FixedMul(aPos.xf[2],len)/64.0);
      Fixed oscillate = (FixedOne+iTriage.Trig().Cos(angle));
      return FixedToWeight(FixedMul(FixedHalf,oscillate));
    };
private:
    CTriage& iTriage;
};



CMixColors<CDiffuse<PP(255,127,63,255)>, CAmbient<PP(255,127,63,255)>,CWeight<30000> > mix0(triage);
CMixColors<CAmbient<PP(255,0,0,255)>,CDiffuse<PP(0,255,0,255)>,CWeight<20000> > mix1(triage);
CMixColors<CDiffuse<PP(255,0,0,255)>,CAmbient<PP(0,255,0,255)>,CWeight<20000> > mix2(triage);
CMixColors<CDiffuse<PP(255,0,0,255)>,CAmbient<PP(0,255,0,0)>,CCosineZ<1000> > mix3(triage);


#define DS(_n,_m)  void _n(Fixed radius){DrawSphere(triage,radius,_m,NSTEPS);}

DS(DrawSphere0,mix0)
DS(DrawSphere1,mix1)
DS(DrawSphere2,mix2)
DS(DrawSphere3,mix3)

PlatInt seed=21313;

void ResetRandom()
{
  seed=21313;
}

PlatInt Random()
{
  seed = (seed+4242342)%6865675;
  return seed;
}

void RandomSphere()
{
  PlatInt r = 20+(Random()%50);
  Fixed radius = IntToFixed(r);
  PlatInt type   =    (Random()%4);
  PlatInt dx     = 40+(Random()%500);
  PlatInt dy     = 40+(Random()%300);
  PlatInt dz     = 40+(Random()%500);

  triage.Transform().PushMatrix();
  triage.Translate(IntToFixed(dx),IntToFixed(dy),IntToFixed(dz));
  triage.SetFlag(KFlagBackFace);
  
  switch (type)
  {
  case 0: DrawSphere0(radius); break;
  case 1: DrawSphere1(radius); break;
  case 2: DrawSphere2(radius); break;
  case 3: DrawSphere3(radius); break;
  }
  triage.ClearFlag(KFlagBackFace);
  triage.Transform().PopMatrix();
}


//x'=x+z*(dx/dz)     1   0  dxdz 0
//y'=y+z*(dy/dz)     0   1  dydz 0
//z'=0               0   0  0    0
//                   0   0  0    1

int main(void)
{
    Clear(texture, Pixel(255,255,255,0));
    Clear(depth, 1000);

    triage.SetFlag(KFlagLessDepth);
    triage.Transform().PushMatrix();

    // Tilt the camera slightly...
//    triage.RotateX(320);
    triage.RotateX(320);

    ResetRandom();
    int i;
    for (i=0;i<10;i++)
    {
      RandomSphere();
    }

    {    
      PlatPixel     c=Pixel(0,255,0,255);
      CVector       v0(IntToFixed( 0),IntToFixed(0), IntToFixed(0));
      CVector       v1(IntToFixed(540),IntToFixed(0), IntToFixed(0));
      CVector       v2(IntToFixed(0 ),IntToFixed(540),IntToFixed(0));
      CVector       v3(IntToFixed(540),IntToFixed(540),IntToFixed(0));

      triage.Transform().PushMatrix();
      triage.Translate(IntToFixed( 0),
                       IntToFixed( 360),
                       IntToFixed( 0));
      triage.Quad(v0,c,v1,c,v2,c,v3,c);
      triage.Transform().PopMatrix();
    }
    
    triage.ClearFlag(KFlagLessDepth);
    triage.Transform().PopMatrix();

    SaveAsTarga("example4.tga",&texture[0],
                texture.Width(), texture.Height());

    system("xv example4.tga &");
   
    return 0;
}

