
/*
 * Example terminal client for the yacas Computer Algebra library.
 * It is heavily tailored to Unix (Linux), but you should be able
 * to easily make a version that links with libyacas.a and provides
 * an interface for a different platform.
 * The platform-dependent parts are readline.cpp (which maintains
 * a history for keyed-in expressions on the command line), and
 * the directories it looks in for input files.
 */

#include <stdio.h>
#include "yacas.h"

CYacas* yacas=NULL;


void ReportNrCurrent()
{
#ifdef LISP_DEBUGHEAP
    extern long theNrCurrent;
    extern long theNrConstructed;
    extern long theNrDestructed;
    extern long theNrTokens;
    extern long theNrDefinedBuiltIn;
    extern long theNrDefinedUser;
    printf("left-over: %ld objects\n",theNrCurrent);
    printf("%ld constructed, %ld destructed\n",theNrConstructed,theNrDestructed);
    printf("nr tokens: %ld \n",theNrTokens);
    printf("-------------------------------\n");
    printf("Total %d functions defined (%d built-in, %d user)\n",
           theNrDefinedBuiltIn+theNrDefinedUser,
           theNrDefinedBuiltIn,theNrDefinedUser);
#endif
}


//TODO global!!!
static LispBoolean busy=true;

LispBoolean Busy()
{
    return busy;
}



void LispExit(LispEnvironment& aEnvironment, LispPtr& aResult,
              LispPtr& aArguments)
{
    busy=false;
    Check(0,KQuitting);
}


void my_exit(void)
{
    delete yacas;
    ReportNrCurrent();
}

void ShowResult(char *prompt)
{
    if (yacas->Error()[0] != '\0')
    {
        printf("%s\n",yacas->Error());
    }
    else
    {
        printf("%s%s\n",prompt,yacas->Result());
    }
    fflush(stdout);
}

#include "deffile.h" //TODO test!

int main(void)
{
    int line=0;
	char inpline[256];

    yacas = CYacas::NewL();
    atexit(my_exit);

    (*yacas)()().Commands().SetAssociation(LispEvaluator(LispExit),
         (*yacas)()().HashTable().LookUp("Exit"));


    /*TODO test!
     LispStringPtr dummy =
     (*yacas)()().HashTable().LookUp("\"dummy\"");
    LoadDefFile((*yacas)()(), dummy);
    //TODO
    */

	// Figure out a another way to specify the script dir
    yacas->Evaluate("DefaultDirectory(\"c:\\\\temp\\\\yacas-1.0.9\\\\scripts\\\\\");");

    yacas->Evaluate("Load(\"yacasinit\");");
    ShowResult("");

    printf("To exit Yacas, enter  Exit(); or Ctrl-c.\n");

    while (Busy())
    {
        printf("In( %d ) = ",line);
        gets(inpline);
        if (inpline)
        {
			yacas->Evaluate(inpline);
			char prompt[30];
			sprintf(prompt,"Out( %d ) = ",line);
			ShowResult(prompt);
			line++;
			
            memset(inpline, '\0', sizeof(inpline));
        }
    }
    return 0;
}


