
#ifndef __ramdisk_h__
#define __ramdisk_h__

#include "lisphash.h"
#include "lispstring.h"
#include "grower.h"

// LispRamDisk is an associated hash of strings that can be treated
// as files.

class LispRamFile
{
public:
    LispRamFile(LispCharPtr aFileContents)
        : iFileContents(aFileContents,LispTrue)
    {
    };
    LispRamFile(const LispRamFile& orig)
        : iFileContents(orig.iFileContents.String(),LispTrue)
        {
        }
    LispStringPtr Contents()
    {
        return &iFileContents;
    }
private:
    LispString iFileContents;
};

class LispRamDisk : public LispAssociatedHash<LispRamFile>
{
};

#endif

