// grower started 1998 ayal Pinkus
//
// Template class that handles dynamic growing arrays.
 
#ifndef _GROWER_H_
#define _GROWER_H_

#include "stubs.h"

//TODO remove? #define TDtByte LispChar

class CArrayGrowerBase
{
public:
    virtual ~CArrayGrowerBase();
    inline int NrItems() const {return iNrItems;}
    inline void SetNrItems(int aNrItems);
    void GrowTo(int aNrItems);
    void Delete(int aIndex, int aCount=1);
    void MoveBlock(int aSrcIndex, int aTrgIndex);
    int BaseAppend(LispChar* aValue);
    void Clear();
    inline LispBoolean ArrayOwnedExternally();

protected:
    inline CArrayGrowerBase(int aItemSize, int aGranularity);
    inline LispChar* BaseItem(int aIndex);

protected:
    LispInt iItemSize;
    LispInt iNrItems;
    LispChar* iArray;
    LispInt iNrAllocated;
    LispInt iGranularity;
    LispBoolean iArrayOwnedExternally;
};

template <class T> 
class CArrayGrower : public CArrayGrowerBase
{
public:
    CArrayGrower(int aGranularity=8);
    inline T& operator[](const int aIndex);
    inline T& Item(const int aIndex);
    inline int Append(T aValue);
    inline void Move(int aSrcIndex, int aTrgIndex);
    inline void Insert(int aIndex, T& aObj);
    inline void SetExternalArray(T* aArray, LispInt aNrItems);
};


#include "grower.inl"


#endif


