
#include "commandline.h"

CCommandLine::~CCommandLine()
{
    LispInt i;
    for (i=0;i<iHistory.NrItems();i++)
    {
        delete iHistory[i];
    }
}

void CCommandLine::GetHistory(LispInt aLine)
{
    iLine.SetNrItems(0);
    LispInt i;
    for (i=0;i<iHistory[aLine]->NrItems();i++)
    {
        iLine.Append((*iHistory[aLine])[i]);
    }
}

void CCommandLine::ReadLine(LispCharPtr prompt)
{
    int cursor=0;
    int history=iHistory.NrItems();
    int promptlen = PlatStrLen(prompt);
    iLine.SetNrItems(1);
    iLine[0] = '\0';

    ShowLine(prompt,promptlen,cursor);
    
    for (;;)
    {
        int c=GetKey();
        switch (c)
        {
        case eDelete:
            if (cursor<iLine.NrItems()-1)
            {
                iLine.Delete(cursor);
            }
            break;
        case eBackSpace:
            if (cursor>0)
            {
                cursor--;
                iLine.Delete(cursor);
            }
            break;
        case eLeft:
            if (cursor>0)
                cursor--;
            break;
        case eRight:
            if (cursor<iLine.NrItems()-1)
                cursor++;
            break;
            break;
        case eUp:
            if (history>0)
            {
                history--;
                GetHistory(history);
                cursor = iLine.NrItems()-1;
            }
            break;
        case eDown:
            if (history<iHistory.NrItems()-1)
            {
                history++;
                GetHistory(history);
                cursor = iLine.NrItems()-1;
            }
            else if (history == iHistory.NrItems()-1)
            {
                iLine.SetNrItems(1);
                iLine[0] = '\0';
                cursor = iLine.NrItems()-1;
            }
            break;
        case eHome:
            cursor=0;
            break;
        case eEnd:
            cursor=iLine.NrItems()-1;
            break;
        case eEnter:
            if (iLine.NrItems()>1)
            {
                NewLine();
                LispStringPtr ptr = new LispString();
                *ptr = iLine.String();
                iHistory.Append(ptr);
            }
            return;
            break;
        default:
            {
                LispChar cc=(LispChar)c;
                iLine.Insert(cursor,cc);
            }
            cursor++;
            break;
        }
        switch (c)
        {
        case ')': ShowOpen(prompt,promptlen,'(',')',cursor); break;
        case '}': ShowOpen(prompt,promptlen,'{','}',cursor); break;
        case ']': ShowOpen(prompt,promptlen,'[',']',cursor); break;
        case '\"': ShowOpen(prompt,promptlen,'\"','\"',cursor); break;
        }
        ShowLine(prompt,promptlen,cursor);
    }
}

void CCommandLine::ShowOpen(LispCharPtr prompt,LispInt promptlen,
                            LispChar aOpen, LispChar aClose, LispInt aCurPos)
{
    LispInt count=1;
    aCurPos--;
    aCurPos--;
    while (aCurPos>0 && count>0)
    {
        if (iLine[aCurPos] == aOpen)
        {
            count--;
        }
        else if (iLine[aCurPos] == aClose)
        {
            count++;
        }
        aCurPos--;
    }
    if (count == 0)
    {
        ShowLine(prompt,promptlen,aCurPos+1);
        Pause();
    }
}
