/*
 * Copyright 1996 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: saml-parse.h,v 1.2 1996/09/15 16:02:39 bousch Exp $
 *
 * Definitions, prototypes and data structures for the default parser
 */

#ifndef _SAML_PARSE_H
#define _SAML_PARSE_H

/* We need this for the FILE structure */
#include <stdio.h>

/* Non-character token types */
#define STOK_EOF	0
#define STOK_INTEGER	258
#define STOK_LITERAL	259

/*
 * It the last token was not a simple character, saml_token should
 * contain the whole token (null-terminated). The parser will not free
 * this space, so the lexer is responsible for reusing the space.
 */
extern char *saml_token;

/* The address of the lexer */
extern int (*saml_lexer)(void);

void saml_init_lexer_fd (FILE *fd);
void saml_init_lexer_mem (const void *start, size_t length);

#endif	/* _SAML_PARSE_H */
