function shade(x, y, z, levels, cont )

# shade(x, y, z [, levels [, contour] )
# shade(z [, levels [, contour] )
#
# plot shade of matrix z versus vectors x,y.
# level can be a scalar speficying the number of shade levels,
# or a vector, specifying where the shade level must be
# if contour exists, each shade level will be contoured with 'countour' color

global __pl __pl_inited

if (!exist("__pl_inited") || plglevel == 0)
	figure(0)
endif

__pl_strm = plgstrm + 1;

if (nargin == 1 && is_matrix(x))
	levels = 20;
	cont = 0;
	z = x; x = 1:rows(z); y = 1:columns(z);
elseif (nargin == 2 && is_matrix(x))
	cont = 0; levels = y;
	z = x; x = 1:rows(z); y = 1:columns(z);
elseif (nargin == 3 && is_scalar(z))
	levels = y; cont = z;
	z = x; x = 1:rows(z); y = 1:columns(z);
elseif (nargin == 3)
	levels = 20;
	cont = 0;
elseif (nargin == 4)
	cont = 0;
endif

if (is_scalar(levels) && levels == 1)	# segmentation violation!
	levels = 2;
endif

# plot color and pen width of boundary of shade region

max_color = 0; max_width = 0;
	
if (cont)
	min_color = cont; min_width = 1;
else
	min_color = 0; min_width = 0;
endif

xlen = length (x); ylen = length (y);
	
if (ishold == 0)
	xm = min(min(x)); xM = max(max(x));
	ym = min(min(y)); yM = max(max(y));
	zm = min(min(z)); zM = max(max(z));
			
	if (__pl.axis_st(__pl_strm))
		xm = __pl.axis(__pl_strm,1); xM = __pl.axis(__pl_strm,2);
		ix = find(x >= xm & x <= xM);
		x=x(ix); z=z(ix,:);

		if (length(__pl.axis(__pl_strm,:)) >= 4)	
			ym = __pl.axis(__pl_strm,3); yM = __pl.axis(__pl_strm,4);
			iy = find(y >= ym & y <= yM);
			y=y(iy); z=z(:,iy);
		else
			__pl.axis(__pl_strm,3) = ym; __pl.axis(__pl_strm,4) = yM;
		endif
		if (length(__pl.axis(__pl_strm,:)) == 6)
			zm = __pl.axis(__pl_strm,5); zM = __pl.axis(__pl_strm,6);
		else
			__pl.axis(__pl_strm,5) = zm; __pl.axis(__pl_strm,6) = zM;
		endif
	else	# make axis() return current axis
		__pl.axis(__pl_strm,1) = xm; __pl.axis(__pl_strm,2) = xM;
		__pl.axis(__pl_strm,3) = ym; __pl.axis(__pl_strm,4) = yM;
		__pl.axis(__pl_strm,5) = zm; __pl.axis(__pl_strm,6) = zM;		
	endif
	
	__pl.plcol(__pl_strm) = 1;
	plcol(15);pllsty(1);
	__pl_plenv(xm, xM, ym, yM, 0, 0);
else
	if (columns(__pl.axis(__pl_strm,:)) != 6)
		 error("You must contour/shade plot something before entering hold mode");
	endif
	xm = __pl.axis(__pl_strm,1); xM = __pl.axis(__pl_strm,2);
	ym = __pl.axis(__pl_strm,3); yM = __pl.axis(__pl_strm,4);
	zm = __pl.axis(__pl_strm,5); zM = __pl.axis(__pl_strm,6);
	z = z(find(x >= xm & x <= xM), find(y >= ym & y <= yM));	
endif

tr = [(xM-xm)/(xlen-1); 0; xm; 0; (yM-ym)/(ylen-1); ym];
	
if (!is_scalar(levels))
	n = length(levels)-1;
	clevel = levels;
else
	n = levels;
	clevel = linspace(zm, zM, levels+1);
endif
	
for i = 1:n
	plpsty(0);

	plshade(z, '0', xm, xM, ym, yM, 
		clevel(i), clevel(i+1),
		1, (i-1) / (n-1), 1,
		min_color, min_width, max_color, max_width, 1, tr);
endfor

if (__pl.grid(__pl_strm))		# this has to be done after shading
		plcol(15);
		plbox("bcnsgt",0,0,"bcnsgtv",0,0)
	else
		plcol(15);
		plbox("bcnst",0,0,"bcnstv",0,0)
endif

plcol(15);
pllab(tdeblank(__pl.xlabel(__pl_strm,:)), tdeblank(__pl.ylabel(__pl_strm,:)), tdeblank(__pl.tlabel(__pl_strm,:)));
plflush;	

endfunction
