function autostyle(x)

# autostyle "on" | "off"
#
# increases line style after each plot.
# Usefull for B&W plots

global __pl

if (!exist("__pl_inited") || plglevel == 0)
	figure(0)
endif

__pl_strm = plgstrm+1;

  if (nargin == 0)
    __pl.lstlyle(__pl_strm) = 1;
  elseif (nargin == 1)
    if (isstr (x))
      if (strcmp ("off", x))
        __pl.lstlyle(__pl_strm) = 0;
      elseif (strcmp ("on", x))
        __pl.lstlyle(__pl_strm) = 1;
      else
    help autostyle
      endif
    else
      error ("autostyle: argument must be a string");
    endif
  else
    error ("usage: autostyle (\"on\" | \"off\")");
  endif

endfunction

