%exyplots( epsFile,x,y,xData,yData,dash,color)
% written by Stefan Mueller stefan.mueller@fgan.de 1997

function exyplots( epsFile,x,y,xData,yData,dash,color)
  if (nargin~=7)
    usage ('exyplot ( epsFile,x,y,xData,yData,dash,color)');
  end
  [rows colums]=size(xData);
  if rows==1
    nData=colums;
    xyData=[xData; yData];
  else
    nData=rows;
    xyData=[xData'; yData'];
  end
  xyData=reshape(xyData,1,2*nData);
  array=sprintf('%1.2f ',xyData);
  fprintf(epsFile,'/plotdata[%s] def\n',array);
  fprintf(epsFile,'currentrgbcolor %1.2f %1.2f %1.2f setrgbcolor\n',...
          color(1),color(2),color(3));
  fprintf(epsFile,'%1.2f %1.2f translate\n',x,y);
  fprintf(epsFile,'0 2 plotdata length 2 sub\n');
  fprintf(epsFile,'{ dup plotdata exch get\n');
  fprintf(epsFile,'exch 1 add plotdata exch get\n');
  fprintf(epsFile,...
    '2 copy translate %s neg exch neg exch translate }for\n',dash);
  fprintf(epsFile,'%1.2f %1.2f translate\n',-x,-y);
  fprintf(epsFile,'setrgbcolor\n');
